/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.rdql.Printable;
import com.hp.hpl.jena.rdql.Settable;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.ValueException;
import com.hp.hpl.jena.rdql.parser.ParsedLiteral;

public class WorkingVar
extends ParsedLiteral
implements Value,
Printable,
Settable,
Cloneable {
    public WorkingVar() {
    }

    public WorkingVar(Value value) {
        super(value);
    }

    public boolean isNumber() {
        this.forceInt();
        if (!this.isInt) {
            this.forceDouble();
        }
        return this.isSet && (this.isInt || this.isDouble);
    }

    public boolean isInt() {
        this.forceInt();
        return this.isSet && this.isInt;
    }

    public boolean isDouble() {
        this.forceDouble();
        return this.isSet && this.isDouble;
    }

    private void forceInt() {
        if (!this.isSet || this.isInt || !this.isString) {
            return;
        }
        try {
            this.valInt = Long.parseLong(this.valString);
            this.isInt = true;
            this.isDouble = true;
            this.valDouble = this.valInt;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void forceDouble() {
        if (!this.isSet || this.isDouble || !this.isString) {
            return;
        }
        try {
            this.valDouble = Double.parseDouble(this.valString);
            this.isDouble = true;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public long getInt() {
        this.forceInt();
        if (!this.isSet || !this.isInt) {
            throw new ValueException("Not an int: " + this);
        }
        return this.valInt;
    }

    public double getDouble() {
        this.forceDouble();
        if (!this.isSet || !this.isDouble) {
            throw new ValueException("Not a long: " + this);
        }
        return this.valDouble;
    }
}

