/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.rdql.WorkingVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResultBinding {
    ResultBinding parent = null;
    List varNames = new ArrayList();
    List values = new ArrayList();
    List causalTriples = null;
    Query query = null;

    public ResultBinding(ResultBinding resultBinding) {
        this.parent = resultBinding;
    }

    public ResultBinding() {
        this(null);
    }

    public int add(String string, Value value) {
        this.varNames.add(string);
        this.values.add(value);
        this.check();
        return this.varNames.size() - 1;
    }

    public int add(String string, RDFNode rDFNode) {
        this.varNames.add(string);
        this.values.add(rDFNode);
        this.check();
        return this.varNames.size() - 1;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addTriple(Statement statement) {
        if (this.causalTriples == null) {
            this.causalTriples = new ArrayList();
        }
        this.causalTriples.add(statement);
    }

    public Set getTriples() {
        HashSet hashSet = new HashSet();
        this.getTriples(hashSet);
        return hashSet;
    }

    private void getTriples(Collection collection) {
        if (this.causalTriples == null) {
            this.causalTriples = new ArrayList();
            if (this.query != null) {
                Model model = this.query.getSource();
                try {
                    Iterator iterator = this.query.getTriplePatterns().iterator();
                    while (iterator.hasNext()) {
                        Triple triple = (Triple)iterator.next();
                        Triple triple2 = QueryEngine.substituteIntoTriple(triple, this);
                        RDFNode rDFNode = QueryEngine.convertNodeToRDFNode(triple2.getSubject(), model);
                        RDFNode rDFNode2 = QueryEngine.convertNodeToRDFNode(triple2.getPredicate(), model);
                        if (rDFNode2 instanceof Resource) {
                            rDFNode2 = model.createProperty(((Resource)rDFNode2).getURI());
                        }
                        RDFNode rDFNode3 = QueryEngine.convertNodeToRDFNode(triple2.getObject(), model);
                        Statement statement = model.createStatement((Resource)rDFNode, (Property)rDFNode2, rDFNode3);
                        collection.add(statement);
                    }
                }
                catch (Exception exception) {
                    System.err.println("ResultBinding.getTriples: Substitution error: " + exception);
                }
            }
        }
        if (this.causalTriples == null) {
            return;
        }
        collection.addAll(this.causalTriples);
    }

    public Model mergeTriples(Model model) {
        Set set = this.getTriples();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            model.add((Statement)iterator.next());
        }
        return model;
    }

    public ResultBindingIterator iterator() {
        return new ResultBindingIterator(this);
    }

    public Object get(String string) {
        return this.lookup(string, 0);
    }

    private Object lookup(String string, int n) {
        int n2 = n;
        while (n2 < this.varNames.size()) {
            if (string.equals((String)this.varNames.get(n2))) {
                Object e = this.values.get(n2);
                return this.values.get(n2);
            }
            ++n2;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookup(string, 0);
    }

    public Value getValue(String string) {
        Object object = this.get(string);
        return ResultBinding.convert(object);
    }

    private static Value convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Resource) {
            String string = ((Resource)object).getURI();
            WorkingVar workingVar = new WorkingVar();
            workingVar.setRDFResource((Resource)object);
            return workingVar;
        }
        if (object instanceof Literal) {
            WorkingVar workingVar = new WorkingVar();
            workingVar.setRDFLiteral((Literal)object);
            return workingVar;
        }
        throw new RDQL_InternalErrorException("ResultBinding: unexpected object class: " + object.getClass().getName());
    }

    void setParent(ResultBinding resultBinding) {
        this.parent = resultBinding;
    }

    public int size() {
        int n = this.varNames.size();
        if (this.parent != null) {
            n += this.parent.size();
        }
        return n;
    }

    public void check() {
        int n = 0;
        while (n < this.varNames.size()) {
            String string = (String)this.varNames.get(n);
            Object object = this.lookup(string, n + 1);
            ++n;
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.varNames.size()) {
            if (n != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("(" + this.varNames.get(n) + ", " + this.values.get(n) + ")");
            ++n;
        }
        if (this.parent != null && (string = this.parent.toString()) != null && string.length() != 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static class ResultBindingIterator
    implements Iterator {
        boolean active;
        boolean doneThisOne;
        ResultBinding binding;
        int i;

        ResultBindingIterator(ResultBinding resultBinding) {
            this.binding = resultBinding;
            this.i = -1;
            this.doneThisOne = true;
            this.active = true;
        }

        public boolean hasNext() {
            if (this.doneThisOne) {
                this.advance();
            }
            return this.active;
        }

        public Object next() {
            this.advance();
            this.doneThisOne = true;
            return this.binding.varNames.get(this.i);
        }

        public String varName() {
            if (!this.active) {
                return null;
            }
            return (String)this.binding.varNames.get(this.i);
        }

        public Value value() {
            if (!this.active) {
                return null;
            }
            return ResultBinding.convert(this.binding.values.get(this.i));
        }

        public void remove() {
            throw new UnsupportedOperationException("ResultsBindingIterator.remove");
        }

        private boolean advance() {
            if (!this.active) {
                return false;
            }
            if (!this.doneThisOne) {
                return true;
            }
            ++this.i;
            if (this.i >= this.binding.varNames.size()) {
                this.i = -1;
                this.binding = this.binding.parent;
                this.doneThisOne = true;
                if (this.binding == null) {
                    this.active = false;
                    return this.active;
                }
                return this.advance();
            }
            this.doneThisOne = false;
            return this.active;
        }
    }
}

