/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsMem;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Value;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ResultSet;
import java.io.PrintWriter;
import java.util.Iterator;

public class QueryResultsFormatter {
    QueryResults queryResults;
    QueryResultsMem all = null;
    int numRows = -2;
    int numCols = -2;
    int[] colWidths = null;
    static final String notThere = "<<unset>>";
    public static final String resultsNamespace = "http://jena.hpl.hp.com/2003/03/queryResults#";

    public QueryResultsFormatter(QueryResults queryResults) {
        this.queryResults = queryResults;
    }

    public int numColumns() {
        return this.queryResults.getResultVars().size();
    }

    public int numRows() {
        return this.numRows;
    }

    private void colWidths() {
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        this.numCols = this.queryResults.getResultVars().size();
        this.numRows = 0;
        this.colWidths = new int[this.numCols];
        int n = 0;
        while (n < this.numCols) {
            this.colWidths[n] = ((String)this.queryResults.getResultVars().get(n)).length();
            ++n;
        }
        while (this.all.hasNext()) {
            ++this.numRows;
            ResultBinding resultBinding = (ResultBinding)this.all.next();
            int n2 = -1;
            Iterator iterator = this.queryResults.getResultVars().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getVarAsString(resultBinding, string);
                if (this.colWidths[++n2] >= string2.length()) continue;
                this.colWidths[n2] = string2.length();
            }
        }
        this.all.reset();
    }

    public void close() {
        this.queryResults.close();
        this.queryResults = null;
        this.all = null;
        this.colWidths = null;
    }

    public Model toModel() {
        Model model = ModelFactory.createDefaultModel();
        this.asRDF(model);
        return model;
    }

    public Resource asRDF(Model model) {
        Resource resource = model.createResource();
        resource.addProperty(RDF.type, ResultSet.ResultSet);
        Iterator iterator = this.queryResults.getResultVars().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            resource.addProperty(ResultSet.resultVariable, string);
        }
        int n = 0;
        QueryResults queryResults = this.queryResults;
        while (queryResults.hasNext()) {
            ++n;
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            Resource resource2 = model.createResource();
            resource.addProperty(ResultSet.solution, resource2);
            Iterator iterator2 = this.queryResults.getResultVars().iterator();
            while (iterator2.hasNext()) {
                Resource resource3 = model.createResource();
                String string = (String)iterator2.next();
                Object object = resultBinding.get(string);
                RDFNode rDFNode = null;
                if (object == null) {
                    rDFNode = ResultSet.undefined;
                } else {
                    if (!(object instanceof RDFNode)) {
                        System.err.println("Class wrong: " + object.getClass().getName());
                        continue;
                    }
                    rDFNode = (RDFNode)resultBinding.get(string);
                }
                resource3.addProperty(ResultSet.variable, string);
                resource3.addProperty(ResultSet.value, rDFNode);
                resource2.addProperty(ResultSet.binding, resource3);
            }
        }
        resource.addProperty(ResultSet.size, n);
        return resource;
    }

    public void dump(PrintWriter printWriter, boolean bl) {
        if (this.queryResults.getResultVars().size() == 0) {
            printWriter.println("# ==== No variables ====");
            printWriter.flush();
            return;
        }
        boolean bl2 = true;
        printWriter.println("# Variables:");
        Iterator iterator = this.queryResults.getResultVars().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            printWriter.print("?" + string + " ");
            bl2 = false;
        }
        printWriter.println(".");
        printWriter.println("# Data:");
        printWriter.flush();
        if (bl) {
            this.dumpAligned(printWriter);
        } else {
            this.dumpRaw(printWriter);
        }
    }

    private void dumpRaw(PrintWriter printWriter) {
        this.numCols = this.queryResults.getResultVars().size();
        QueryResults queryResults = this.queryResults;
        while (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            Iterator iterator = this.queryResults.getResultVars().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this.getVarAsString(resultBinding, string);
                printWriter.print("?");
                printWriter.print(string);
                printWriter.print(" ");
                printWriter.print(string2);
                printWriter.print(" ");
            }
            printWriter.println(".");
        }
        this.queryResults.close();
    }

    private void dumpAligned(PrintWriter printWriter) {
        Object object;
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] stringArray = new String[this.numCols];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numCols) {
            stringArray[n2] = object = (String)this.queryResults.getResultVars().get(n2);
            n += this.colWidths[n2];
            ++n2;
        }
        object = this.all;
        while (object.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)object.next();
            int n4 = 0;
            while (n4 < this.numCols) {
                StringBuffer stringBuffer = new StringBuffer(120);
                String string = (String)this.queryResults.getResultVars().get(n4);
                stringBuffer.append('?');
                stringBuffer.append(string);
                stringBuffer.append(' ');
                String string2 = this.getVarAsString(resultBinding, string);
                int n5 = this.colWidths[n4];
                stringBuffer.append(string2);
                int n6 = 0;
                while (n6 < n5 - string2.length()) {
                    stringBuffer.append(' ');
                    ++n6;
                }
                stringBuffer.append(' ');
                printWriter.print(stringBuffer);
                ++n4;
            }
            printWriter.println(" .");
        }
        this.all.close();
        printWriter.flush();
    }

    public void printAll(PrintWriter printWriter) {
        this.printAll(printWriter, " | ", null);
    }

    public void printAll(PrintWriter printWriter, String string) {
        this.printAll(printWriter, string, null);
    }

    public void printAll(PrintWriter printWriter, String string, String string2) {
        if (this.queryResults.getResultVars().size() == 0) {
            printWriter.println("==== No variables ====");
            printWriter.flush();
            return;
        }
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] stringArray = new String[this.numCols];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numCols) {
            String string3;
            stringArray[n2] = string3 = (String)this.queryResults.getResultVars().get(n2);
            n += this.colWidths[n2];
            if (n2 > 0) {
                n += string.length();
            }
            ++n2;
        }
        this.printRow(printWriter, stringArray, string, string2);
        int n4 = 0;
        while (n4 < n) {
            printWriter.print('=');
            ++n4;
        }
        printWriter.println();
        QueryResultsMem queryResultsMem = this.all;
        while (queryResultsMem.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResultsMem.next();
            int n5 = 0;
            while (n5 < this.numCols) {
                String string4 = (String)this.queryResults.getResultVars().get(n5);
                stringArray[n5] = this.getVarAsString(resultBinding, string4);
                ++n5;
            }
            this.printRow(printWriter, stringArray, string, string2);
        }
        this.all.reset();
        printWriter.flush();
    }

    private void printRow(PrintWriter printWriter, String[] stringArray, String string, String string2) {
        if (stringArray.length != this.numCols) {
            throw new RDQL_InternalErrorException("QueryResultsFormatter.printRow: Row length (" + stringArray.length + ") != numCols (" + this.numCols + ")");
        }
        int n = 0;
        while (n < this.numCols) {
            String string3 = stringArray[n];
            int n2 = this.colWidths[n];
            StringBuffer stringBuffer = new StringBuffer(120);
            if (n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string3);
            int n4 = 0;
            while (n4 < n2 - string3.length()) {
                stringBuffer.append(' ');
                ++n4;
            }
            printWriter.print(stringBuffer);
            ++n;
        }
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println();
    }

    public void printHTML(PrintWriter printWriter) {
        Object object;
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
            this.numRows = this.all.size();
        }
        printWriter.println("<table>");
        printWriter.println("  <tr>");
        int n = 0;
        while (n < this.queryResults.getResultVars().size()) {
            object = (String)this.queryResults.getResultVars().get(n);
            printWriter.print("    <th>");
            printWriter.print((String)object);
            printWriter.print("</th>");
            printWriter.println();
            ++n;
        }
        printWriter.println("  </tr>");
        while (this.all.hasNext()) {
            printWriter.println("  <tr>");
            object = (ResultBinding)this.all.next();
            int n2 = 0;
            while (n2 < this.queryResults.getResultVars().size()) {
                String string = (String)this.queryResults.getResultVars().get(n2);
                Value value = ((ResultBinding)object).getValue(string);
                String string2 = value == null ? notThere : value.toString();
                printWriter.print("    <td>");
                printWriter.print(string2);
                printWriter.print("</td>");
                printWriter.println();
                ++n2;
            }
            printWriter.println("  </tr>");
        }
        printWriter.println("</table>");
        printWriter.flush();
        this.all.reset();
    }

    public void consume() {
        QueryResults queryResults = this.queryResults;
        while (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            ResultBinding.ResultBindingIterator resultBindingIterator = resultBinding.iterator();
            while (resultBindingIterator.hasNext()) {
                resultBindingIterator.next();
                String string = resultBindingIterator.varName();
                Value value = resultBindingIterator.value();
            }
        }
    }

    private String getVarAsString(ResultBinding resultBinding, String string) {
        Object object = resultBinding.get(string);
        String string2 = notThere;
        if (object != null) {
            if (!(object instanceof RDFNode)) {
                string2 = "Found a " + object.getClass().getName();
            } else if (object instanceof Literal) {
                Literal literal = (Literal)object;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('\"').append(literal.toString()).append('\"');
                if (!literal.getLanguage().equals("")) {
                    stringBuffer.append("@").append(literal.getLanguage());
                }
                if (literal.getDatatype() != null) {
                    stringBuffer.append("^^<").append(literal.getDatatypeURI()).append(">");
                }
                string2 = stringBuffer.toString();
            } else {
                string2 = resultBinding.getValue(string).asQuotedString();
            }
        }
        return string2;
    }
}

