/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdql.QSys;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsStream;
import com.hp.hpl.jena.rdql.ResultBinding;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.aidministrator.rdf.client.SesameClient;
import nl.aidministrator.rdf.client.model.Literal;
import nl.aidministrator.rdf.client.model.Resource;
import nl.aidministrator.rdf.client.model.Value;
import nl.aidministrator.rdf.client.query.QueryResultListener;

public class QueryEngineSesame
implements QueryExecution {
    static Map repositoryBNodes = new HashMap();
    static final int bufferCapacity = 5;
    Object endOfPipeMarker = new Object();
    SesameClient sesameClient = null;
    String repository;
    String repositoryKey;
    Query query;
    boolean initialized = false;
    volatile boolean queryStop = false;
    long queryStartTime = -1L;
    volatile long queryExecTime = -1L;
    int idQueryExecution = 0;

    public QueryEngineSesame(Query query, String string, String string2) throws MalformedURLException {
        this(query, new URL(string), string2);
    }

    public QueryEngineSesame(Query query, URL uRL, String string) throws MalformedURLException {
        this.sesameClient = new SesameClient(uRL);
        this.repository = string;
        this.query = query;
        this.repositoryKey = this.repositoryKey(this.sesameClient.getServerURL().toExternalForm(), this.repository);
        if (!repositoryBNodes.containsKey(this.repositoryKey)) {
            repositoryBNodes.put(this.repositoryKey, new HashMap());
        }
    }

    private String repositoryKey(String string, String string2) {
        return string + "<" + string2 + ">";
    }

    public void init() {
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    public QueryResults exec() {
        if (this.query.getResultVars().size() == 0) {
            return null;
        }
        this.init();
        final BoundedBuffer boundedBuffer = new BoundedBuffer(5);
        this.queryStartTime = System.currentTimeMillis();
        ++this.idQueryExecution;
        new Thread("Sesame-" + this.idQueryExecution){

            public void run() {
                try {
                    ModelMem modelMem = new ModelMem();
                    Map map = (Map)repositoryBNodes.get(QueryEngineSesame.this.repositoryKey);
                    QueryEngineSesame.this.sesameClient.evalRdqlQuery(QueryEngineSesame.this.query.toString(), QueryEngineSesame.this.repository, (QueryResultListener)new QueryResultsBuilder(modelMem, QueryEngineSesame.this.query.getResultVars(), boundedBuffer, map));
                }
                catch (IOException iOException) {
                    System.err.println("Panic: Error in SesameClient.evalRdqlQuery");
                    try {
                        boundedBuffer.put(QueryEngineSesame.this.endOfPipeMarker);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
            }
        }.start();
        ResultsIterator resultsIterator = new ResultsIterator(boundedBuffer);
        return new QueryResultsStream(this.query, this, resultsIterator);
    }

    public QueryResults exec(ResultBinding resultBinding) {
        throw new UnsupportedOperationException("QueryEngineSesame.exec(ResultBinding)");
    }

    public void abort() {
        this.queryStop = true;
    }

    public void close() {
        this.queryStop = true;
    }

    static {
        if (System.getProperty("org.xml.sax.driver") == null) {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        }
    }

    private class ResultsIterator
    implements Iterator {
        BoundedBuffer pipe;
        Object nextThing;

        ResultsIterator(BoundedBuffer boundedBuffer) {
            this.pipe = boundedBuffer;
            this.nextThing = null;
        }

        public boolean hasNext() {
            try {
                boolean bl;
                if (QueryEngineSesame.this.queryStop) {
                    return false;
                }
                if (this.nextThing == null) {
                    this.nextThing = this.pipe.take();
                }
                boolean bl2 = bl = this.nextThing != QueryEngineSesame.this.endOfPipeMarker;
                if (!bl && QueryEngineSesame.this.query.executeTime == -1L) {
                    QueryEngineSesame.this.query.executeTime = System.currentTimeMillis() - QueryEngineSesame.this.queryStartTime;
                }
                return bl;
            }
            catch (InterruptedException interruptedException) {
                QSys.unhandledException(interruptedException, "QueryEngineSesame.ResultsIterator", "hasNext");
                return false;
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            Object object = this.nextThing;
            this.nextThing = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException("QueryEngineSesame.ResultsIterator.remove");
        }
    }

    private class QueryResultsBuilder
    implements QueryResultListener {
        boolean verbose = false;
        boolean firstInRow = true;
        ResultBinding currentRow;
        int columnIndex = 0;
        BoundedBuffer output;
        Model model;
        List resultVars;
        Map bNodeMap;

        QueryResultsBuilder(Model model, List list, BoundedBuffer boundedBuffer, Map map) {
            this.model = model;
            this.output = boundedBuffer;
            this.resultVars = list;
            this.bNodeMap = map;
        }

        public void startQueryResult() {
            if (this.verbose) {
                System.out.println("---- Start results of Sesame RDQL query");
            }
        }

        public void endQueryResult() {
            if (this.verbose) {
                System.out.println("---- End results of Sesame RDQL query");
                System.out.println();
            }
            try {
                this.output.put(QueryEngineSesame.this.endOfPipeMarker);
            }
            catch (InterruptedException interruptedException) {
                QSys.unhandledException(interruptedException, "QueryResultsBuilder", "endQueryResult");
                return;
            }
        }

        public void startTuple() {
            this.firstInRow = true;
            this.columnIndex = 0;
            this.currentRow = new ResultBinding();
            this.currentRow.setQuery(QueryEngineSesame.this.query);
        }

        public void endTuple() {
            if (this.verbose) {
                System.out.println();
            }
            try {
                this.output.put((Object)this.currentRow);
            }
            catch (InterruptedException interruptedException) {
                QSys.unhandledException(interruptedException, "QueryResultsBuilder", "endTuple");
                QueryEngineSesame.this.queryStop = true;
            }
            this.currentRow = null;
        }

        public void tupleValue(Value value) {
            try {
                if (!this.firstInRow && this.verbose) {
                    System.out.print("  ");
                }
                this.firstInRow = false;
                String string = (String)QueryEngineSesame.this.query.getResultVars().get(this.columnIndex);
                RDFNode rDFNode = null;
                if (value instanceof Resource) {
                    Resource resource;
                    String string2;
                    if (this.verbose) {
                        System.out.print("<" + value + ">");
                    }
                    if ((string2 = (resource = (Resource)value).getURI()) == null || string2.equals("")) {
                        System.err.print("Panic: empty URI <" + value + ">");
                        return;
                    }
                    if (string2.startsWith("_anon")) {
                        if (!this.bNodeMap.containsKey(string2)) {
                            this.bNodeMap.put(string2, this.model.createResource());
                        }
                        rDFNode = (RDFNode)this.bNodeMap.get(string2);
                    } else {
                        rDFNode = this.model.createResource(resource.getURI());
                    }
                } else if (value instanceof Literal) {
                    if (this.verbose) {
                        System.out.print(value);
                    }
                    Literal literal = (Literal)value;
                    String string3 = literal.getValue();
                    rDFNode = this.model.createLiteral(string3);
                } else if (this.verbose) {
                    System.out.print("Unknown/");
                    String string4 = value.getClass().getName();
                    string4 = string4.substring(string4.lastIndexOf(46) + 1);
                    System.out.print(string4 + "::" + value);
                }
                ++this.columnIndex;
                this.currentRow.add(string, rDFNode);
            }
            catch (RDFException rDFException) {
                QSys.unhandledException(rDFException, "QueryResultsBuilder", "tupleValue");
                return;
            }
        }
    }
}

