/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSimpleListStatements
extends TestCase {
    Model model = null;
    static boolean booleanValue = true;
    static char charValue = (char)99;
    static long longValue = 456L;
    static float floatValue = 5.67f;
    static double doubleValue = 6.78;
    static String stringValue = "stringValue";
    static String langValue = "en";
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements;

    public TestSimpleListStatements(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements == null ? (class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements = TestSimpleListStatements.class$("com.hp.hpl.jena.rdf.model.test.TestSimpleListStatements")) : class$com$hp$hpl$jena$rdf$model$test$TestSimpleListStatements);
    }

    protected void setUp() throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.createResource("http://example.org/boolean").addProperty(RDF.value, booleanValue);
        this.model.createResource("http://example.org/char").addProperty(RDF.value, charValue);
        this.model.createResource("http://example.org/long").addProperty(RDF.value, longValue);
        this.model.createResource("http://example.org/float").addProperty(RDF.value, floatValue);
        this.model.createResource("http://example.org/double").addProperty(RDF.value, doubleValue);
        this.model.createResource("http://example.org/string").addProperty(RDF.value, stringValue);
        this.model.createResource("http://example.org/langString").addProperty(RDF.value, stringValue, langValue);
    }

    protected void tearDown() throws Exception {
        this.model = null;
    }

    public void testBoolean() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, booleanValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Assert.assertEquals((Object)stmtIterator.nextStatement().getSubject().getURI(), (Object)"http://example.org/boolean");
        }
        Assert.assertEquals((int)1, (int)n);
    }

    public void testChar() {
        StmtIterator stmtIterator = this.model.listStatements((Resource)null, (Property)null, charValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Assert.assertEquals((Object)stmtIterator.nextStatement().getSubject().getURI(), (Object)"http://example.org/char");
        }
        Assert.assertEquals((int)1, (int)n);
    }

    public void testLong() {
        StmtIterator stmtIterator = this.model.listStatements((Resource)null, (Property)null, longValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Assert.assertEquals((Object)stmtIterator.nextStatement().getSubject().getURI(), (Object)"http://example.org/long");
        }
        Assert.assertEquals((int)1, (int)n);
    }

    public void testFloat() {
        StmtIterator stmtIterator = this.model.listStatements((Resource)null, (Property)null, floatValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Assert.assertEquals((Object)stmtIterator.nextStatement().getSubject().getURI(), (Object)"http://example.org/float");
        }
        Assert.assertEquals((int)1, (int)n);
    }

    public void testDouble() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, doubleValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Assert.assertEquals((Object)stmtIterator.nextStatement().getSubject().getURI(), (Object)"http://example.org/double");
        }
        Assert.assertEquals((int)1, (int)n);
    }

    public void testString() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, stringValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Assert.assertEquals((Object)stmtIterator.nextStatement().getSubject().getURI(), (Object)"http://example.org/string");
        }
        Assert.assertEquals((int)1, (int)n);
    }

    public void testLangString() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, stringValue, langValue);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            Assert.assertEquals((Object)stmtIterator.nextStatement().getSubject().getURI(), (Object)"http://example.org/langString");
        }
        Assert.assertEquals((int)1, (int)n);
    }

    public void testAll() {
        StmtIterator stmtIterator = this.model.listStatements(null, null, (RDFNode)null);
        int n = 0;
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        Assert.assertEquals((int)7, (int)n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

