/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.rdf.model.DoesNotReifyException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestReifiedStatements
extends GraphTestBase {
    private Context blue;
    private Context red;
    static final String aURI = "spoo:theInvisibleMan";
    static final String anotherURI = "spoo:ChevyChase";
    protected static Set empty = TestReifiedStatements.arrayToSet(new Object[0]);
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$test$TestReifiedStatements;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$ReifiedStatement;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public TestReifiedStatements(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$rdf$model$test$TestReifiedStatements == null ? (class$com$hp$hpl$jena$rdf$model$test$TestReifiedStatements = TestReifiedStatements.class$("com.hp.hpl.jena.rdf.model.test.TestReifiedStatements")) : class$com$hp$hpl$jena$rdf$model$test$TestReifiedStatements);
    }

    public void setUp() {
        this.red = new Context("red");
        this.blue = new Context("blue");
    }

    public void testBasicReification() {
        Model model = this.red.model;
        Resource resource = model.createResource(aURI);
        model.add(resource, RDF.type, RDF.Statement);
        model.add(resource, RDF.subject, this.red.S);
        model.add(resource, RDF.predicate, this.red.P);
        model.add(resource, RDF.object, this.red.O);
        RDFNode rDFNode = resource.as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = TestReifiedStatements.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
        Assert.assertEquals((String)"can recover statement", (Object)this.red.SPO, (Object)((ReifiedStatement)rDFNode).getStatement());
    }

    public void testReificationCombinations() {
        Model model = this.red.model;
        Resource resource = model.createResource(aURI);
        Resource resource2 = model.createResource(anotherURI);
        Property property = (Property)resource.as(class$com$hp$hpl$jena$rdf$model$Property == null ? (class$com$hp$hpl$jena$rdf$model$Property = TestReifiedStatements.class$("com.hp.hpl.jena.rdf.model.Property")) : class$com$hp$hpl$jena$rdf$model$Property);
        Object[][] objectArray = new Object[][]{{model.createStatement(resource, RDF.type, RDF.Statement), new Integer(1)}, {model.createStatement(resource, RDF.subject, this.red.S), new Integer(2)}, {model.createStatement(resource, RDF.predicate, this.red.P), new Integer(4)}, {model.createStatement(resource, RDF.object, this.red.O), new Integer(8)}, {model.createStatement(resource2, property, this.red.O), new Integer(16)}, {model.createStatement(resource, property, this.red.O), new Integer(32)}, {model.createStatement(resource2, RDF.subject, this.red.S), new Integer(64)}, {model.createStatement(resource2, RDF.predicate, this.red.P), new Integer(128)}, {model.createStatement(resource2, RDF.object, this.red.O), new Integer(256)}, {model.createStatement(resource2, RDF.type, RDF.Statement), new Integer(512)}};
        this.testCombinations(model, resource, 0, objectArray, objectArray.length);
    }

    private void testCombinations(Model model, Resource resource, int n, Object[][] objectArray, int n2) {
        if (n2 == 0) {
            try {
                ReifiedStatement reifiedStatement = (ReifiedStatement)resource.as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = TestReifiedStatements.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
                Assert.assertTrue((String)("should not reify: not all components present [" + n + "]: " + reifiedStatement), ((n & 0xF) == 15 ? 1 : 0) != 0);
            }
            catch (DoesNotReifyException doesNotReifyException) {
                GraphTestBase.assertFalse("should reify: all components present", n == 15);
            }
        } else {
            int n4 = n2 - 1;
            Statement statement = (Statement)objectArray[n4][0];
            int n5 = (Integer)objectArray[n4][1];
            this.testCombinations(model, resource, n, objectArray, n4);
            model.add(statement);
            this.testCombinations(model, resource, n + n5, objectArray, n4);
            model.remove(statement);
        }
    }

    public void testThisWillBreak() {
        Resource resource = this.red.model.createResource(aURI);
        this.red.SPO.createReifiedStatement(aURI);
        this.red.model.add(resource, RDF.subject, resource);
    }

    public void testDirtyReification() {
        Model model = this.red.model;
        Resource resource = model.createResource(aURI);
        model.add(resource, RDF.type, RDF.Statement);
        model.add(resource, RDF.subject, this.red.S);
        model.add(resource, RDF.subject, this.red.P);
        this.testDoesNotReify("boo", resource);
    }

    public void testDoesNotReify(String string, Resource resource) {
        try {
            resource.as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = TestReifiedStatements.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
            Assert.fail((String)(string + " (" + resource + ")"));
        }
        catch (DoesNotReifyException doesNotReifyException) {}
    }

    public void testConstructionFromStatements() {
        this.testConstructionFromStatements(this.red);
        this.testConstructionFromStatements(this.blue);
    }

    public void testConstructionFromStatements(Context context) {
        Model model = context.model;
        Statement statement = context.SPO;
        this.testStatementAndModel("fromStatement", statement.createReifiedStatement(), model, statement);
    }

    public void testStatementAndModel(String string, ReifiedStatement reifiedStatement, Model model, Statement statement) {
        Assert.assertEquals((String)(string + ": recover statement"), (Object)statement, (Object)reifiedStatement.getStatement());
        Assert.assertEquals((String)(string + ": recover model"), (Object)model, (Object)reifiedStatement.getModel());
    }

    public void testConstructionFromModels() {
        this.testConstructionFromModels(this.red);
        this.testConstructionFromModels(this.blue);
    }

    public void testConstructionFromModels(Context context) {
        Model model = context.model;
        Statement statement = context.SPO;
        this.testStatementAndModel("fromModel", model.createReifiedStatement(statement), model, statement);
    }

    public void testConstructionByURI() {
        this.testConstructionByURI(this.red);
        this.testConstructionByURI(this.blue);
    }

    public void testConstructionByURI(Context context) {
        Model model = context.model;
        Statement statement = context.SPO;
        ReifiedStatement reifiedStatement = model.createReifiedStatement("spoo:handle", statement);
        ReifiedStatement reifiedStatement2 = statement.createReifiedStatement("spoo:gripper");
        Assert.assertEquals((String)"recover statement (URI)", (Object)statement, (Object)reifiedStatement.getStatement());
        Assert.assertEquals((String)"recover URI", (Object)"spoo:handle", (Object)reifiedStatement.getURI());
        Assert.assertEquals((String)"recover URI", (Object)"spoo:gripper", (Object)reifiedStatement2.getURI());
    }

    public void testConversion() {
        Context context = this.red;
        Model model = context.model;
        Statement statement = context.SPO;
        ReifiedStatement reifiedStatement = model.createReifiedStatement("spoo:handle", statement);
        ReifiedStatement reifiedStatement2 = (ReifiedStatement)model.createResource("spoo:handle").as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = TestReifiedStatements.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
        Assert.assertEquals((String)"recover statement", (Object)statement, (Object)reifiedStatement2.getStatement());
    }

    public void testDoesNotReifyUnknown() {
        Model model = this.red.model;
        this.testDoesNotReify("red model should not reify rubbish", this.red.model.createResource("spoo:rubbish"));
    }

    public void testDoesNotReifyElsewhere() {
        Model model = this.red.model;
        ReifiedStatement reifiedStatement = model.createReifiedStatement("spoo:rubbish", this.red.SPO);
        this.testDoesNotReify("blue model should not reify rubbish", this.blue.model.createResource("spoo:rubbish"));
    }

    public static Set arrayToSet(Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < objectArray.length) {
            hashSet.add(objectArray[n]);
            ++n;
        }
        return hashSet;
    }

    public Set getSetRS(Model model) {
        return this.iteratorToSet(model.listReifiedStatements());
    }

    public void testListReifiedStatements() {
        Model model = this.red.model;
        Assert.assertEquals((String)"initially: no reified statements", (Object)empty, (Object)this.getSetRS(model));
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, this.red.SPO);
        model.add((Resource)reifiedStatement, this.red.P, this.red.O);
        Set set = TestReifiedStatements.arrayToSet(new Object[]{reifiedStatement});
        Assert.assertEquals((String)"post-add: one reified statement", (Object)set, (Object)this.getSetRS(model));
        this.red.model.add(this.red.S, this.red.P, reifiedStatement);
        Assert.assertEquals((String)"post-add: still one reified statement", (Object)set, (Object)this.getSetRS(model));
        ReifiedStatement reifiedStatement2 = model.createReifiedStatement(anotherURI, this.blue.SPO);
        Set set2 = TestReifiedStatements.arrayToSet(new Object[]{reifiedStatement, reifiedStatement2});
        model.add((Resource)reifiedStatement2, this.red.P, this.red.O);
        Assert.assertEquals((String)"post-add: still one reified statement", (Object)set2, (Object)this.getSetRS(model));
    }

    public void testListDoesntCrash() {
        ReifiedStatement reifiedStatement = this.red.model.createReifiedStatement(this.red.SPO);
        ReifiedStatement reifiedStatement2 = this.red.model.createReifiedStatement(this.blue.SPO);
        Assert.assertTrue((String)"should be non-empty", (boolean)this.red.model.listReifiedStatements().hasNext());
    }

    public Set getSetRS(Model model, Statement statement) {
        return this.iteratorToSet(model.listReifiedStatements(statement));
    }

    public void testListReifiedSpecificStatements() {
        Statement statement = this.red.SPO;
        Statement statement2 = this.blue.SPO;
        Model model = this.red.model;
        Assert.assertEquals((String)"no statements should match st", (Object)empty, (Object)this.getSetRS(model, statement));
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, this.red.SPO);
        ReifiedStatement reifiedStatement2 = model.createReifiedStatement(anotherURI, this.blue.SPO);
        model.add((Resource)reifiedStatement, this.red.P, this.red.O);
        Set set = TestReifiedStatements.arrayToSet(new Object[]{reifiedStatement2});
        model.add((Resource)reifiedStatement2, this.red.P, this.red.O);
        Assert.assertEquals((String)"now one matching statement", (Object)set, (Object)this.getSetRS(model, statement2));
    }

    public void testStatementListReifiedStatements() {
        Statement statement = this.red.SPO;
        Model model = this.red.model;
        Assert.assertEquals((String)"it's not there yet", (Object)empty, (Object)this.iteratorToSet(statement.listReifiedStatements()));
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, statement);
        Set set = TestReifiedStatements.arrayToSet(new Object[]{reifiedStatement});
        model.add((Resource)reifiedStatement, this.red.P, this.red.O);
        Assert.assertEquals((String)"it's here now", (Object)set, (Object)this.iteratorToSet(statement.listReifiedStatements()));
    }

    public void testIsReified() {
        Statement statement = this.red.SPO;
        Model model = this.red.model;
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, statement);
        model.add((Resource)reifiedStatement, this.red.P, this.red.O);
        Assert.assertTrue((String)"st should be reified now", (boolean)statement.isReified());
        Assert.assertTrue((String)"m should have st reified now", (boolean)model.isReified(statement));
        GraphTestBase.assertFalse("this new statement should not be reified", model.createStatement(this.blue.S, this.blue.P, this.blue.O).isReified());
    }

    public void testGetAny() {
        Resource resource = this.red.model.getAnyReifiedStatement(this.red.SPO);
        Assert.assertTrue((String)"should get reified statement back", (boolean)(resource instanceof ReifiedStatement));
        Assert.assertEquals((String)"should get me the statement", (Object)this.red.SPO, (Object)((ReifiedStatement)resource).getStatement());
    }

    public void testRemoveReificationWorks() {
        Statement statement = this.red.SPO;
        Model model = this.red.model;
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, statement);
        Assert.assertTrue((String)"st is now reified", (boolean)statement.isReified());
        model.removeAllReifications(statement);
        GraphTestBase.assertFalse("st is no longer reified", statement.isReified());
    }

    public void testRR() {
        Statement statement = this.red.SPO;
        Model model = this.red.model;
        ReifiedStatement reifiedStatement = model.createReifiedStatement(aURI, statement);
        ReifiedStatement reifiedStatement2 = model.createReifiedStatement(anotherURI, statement);
        model.removeReification(reifiedStatement);
        this.testNotReifying(model, aURI);
        Assert.assertTrue((String)"st is still reified", (boolean)statement.isReified());
        model.removeReification(reifiedStatement2);
        GraphTestBase.assertFalse("st should no longer be reified", statement.isReified());
    }

    private void testNotReifying(Model model, String string) {
        try {
            model.createResource(string).as(class$com$hp$hpl$jena$rdf$model$ReifiedStatement == null ? (class$com$hp$hpl$jena$rdf$model$ReifiedStatement = TestReifiedStatements.class$("com.hp.hpl.jena.rdf.model.ReifiedStatement")) : class$com$hp$hpl$jena$rdf$model$ReifiedStatement);
            Assert.fail((String)("there should be no reifiedStatement for " + string));
        }
        catch (DoesNotReifyException doesNotReifyException) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Context {
        Model model = ModelFactory.createDefaultModel();
        Resource S;
        Property P;
        RDFNode O;
        Statement SPO;

        Context(String string) {
            String string2 = "spoo:" + string + "/";
            this.S = this.model.createResource(string2 + "subject");
            this.P = this.model.createProperty(string2 + "predicate");
            this.O = this.model.createLiteral(string2 + "object");
            this.SPO = this.model.createStatement(this.S, this.P, this.O);
        }
    }
}

