/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelI;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceI;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;

public class StatementImpl
implements Statement {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;
    private final Model model;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Bag;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Alt;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Seq;

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode) {
        this.model = null;
        this.subject = resource;
        this.predicate = property;
        this.object = rDFNode;
    }

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode, Model model) throws RDFException {
        this.model = model;
        this.subject = ((ModelI)((Object)model)).convert(resource);
        this.predicate = ((ModelI)((Object)model)).convert(property);
        this.object = ((ModelI)((Object)model)).convert(rDFNode);
    }

    public Resource getSubject() {
        return this.subject;
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public Statement getStatementProperty(Property property) throws RDFException {
        return this.asResource().getProperty(property);
    }

    public Resource getResource() throws RDFException {
        if (this.object instanceof Resource) {
            return (Resource)this.object;
        }
        throw new RDFException(4);
    }

    public Statement getProperty(Property property) throws RDFException {
        return this.getResource().getProperty(property);
    }

    public Literal getLiteral() throws RDFException {
        if (this.object instanceof Literal) {
            return (Literal)this.object;
        }
        throw new RDFException(5);
    }

    public boolean getBoolean() throws RDFException {
        return this.getLiteral().getBoolean();
    }

    public byte getByte() throws RDFException {
        return this.getLiteral().getByte();
    }

    public short getShort() throws RDFException {
        return this.getLiteral().getShort();
    }

    public int getInt() throws RDFException {
        return this.getLiteral().getInt();
    }

    public long getLong() throws RDFException {
        return this.getLiteral().getLong();
    }

    public char getChar() throws RDFException {
        return this.getLiteral().getChar();
    }

    public float getFloat() throws RDFException {
        return this.getLiteral().getFloat();
    }

    public double getDouble() throws RDFException {
        return this.getLiteral().getDouble();
    }

    public String getString() throws RDFException {
        return this.getLiteral().toString();
    }

    public Resource getResource(ResourceF resourceF) throws RDFException {
        if (this.object instanceof Resource) {
            try {
                return resourceF.createResource(((ResourceI)((Object)this.object)).getEmbeddedResource());
            }
            catch (Exception exception) {
                throw new RDFException(exception);
            }
        }
        throw new RDFException(4);
    }

    public Object getObject(ObjectF objectF) throws RDFException {
        try {
            return objectF.createObject(((Literal)this.object).toString());
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    private EnhNode get(Class clazz) {
        return (EnhNode)((Object)this.object.as(clazz));
    }

    public Bag getBag() throws RDFException {
        return (Bag)((Object)this.get(class$com$hp$hpl$jena$rdf$model$Bag == null ? (class$com$hp$hpl$jena$rdf$model$Bag = StatementImpl.class$("com.hp.hpl.jena.rdf.model.Bag")) : class$com$hp$hpl$jena$rdf$model$Bag));
    }

    public Alt getAlt() throws RDFException {
        return (Alt)((Object)this.get(class$com$hp$hpl$jena$rdf$model$Alt == null ? (class$com$hp$hpl$jena$rdf$model$Alt = StatementImpl.class$("com.hp.hpl.jena.rdf.model.Alt")) : class$com$hp$hpl$jena$rdf$model$Alt));
    }

    public Seq getSeq() throws RDFException {
        return (Seq)((Object)this.get(class$com$hp$hpl$jena$rdf$model$Seq == null ? (class$com$hp$hpl$jena$rdf$model$Seq = StatementImpl.class$("com.hp.hpl.jena.rdf.model.Seq")) : class$com$hp$hpl$jena$rdf$model$Seq));
    }

    public String getLanguage() throws RDFException {
        return this.getLiteral().getLanguage();
    }

    public boolean getWellFormed() throws RDFException {
        return this.getLiteral().getWellFormed();
    }

    public Statement set(boolean bl) throws RDFException {
        return this.stringReplace(String.valueOf(bl));
    }

    public Statement set(long l) throws RDFException {
        return this.stringReplace(String.valueOf(l));
    }

    public Statement set(char c) throws RDFException {
        return this.stringReplace(String.valueOf(c));
    }

    public Statement set(float f) throws RDFException {
        return this.stringReplace(String.valueOf(f));
    }

    public Statement set(double d) throws RDFException {
        return this.stringReplace(String.valueOf(d));
    }

    public Statement set(String string) throws RDFException {
        return this.stringReplace(String.valueOf(string));
    }

    public Statement set(String string, boolean bl) throws RDFException {
        return this.stringReplace(String.valueOf(string), "", bl);
    }

    public Statement set(String string, String string2) throws RDFException {
        return this.stringReplace(String.valueOf(string), string2, false);
    }

    public Statement set(String string, String string2, boolean bl) throws RDFException {
        return this.stringReplace(String.valueOf(string), string2, bl);
    }

    public Statement set(RDFNode rDFNode) throws RDFException {
        return this.replace(rDFNode);
    }

    public Statement set(Object object) throws RDFException {
        return object instanceof RDFNode ? this.replace((RDFNode)object) : this.stringReplace(object.toString());
    }

    protected Model mustHaveModel() {
        if (this.model == null) {
            throw new RDFException(1);
        }
        return this.model;
    }

    protected StatementImpl stringReplace(String string) {
        return this.stringReplace(string, "", false);
    }

    protected StatementImpl stringReplace(String string, String string2, boolean bl) {
        return this.replace(new LiteralImpl(Node.createLiteral(string, string2, bl), this.model));
    }

    protected StatementImpl replace(RDFNode rDFNode) throws RDFException {
        this.mustHaveModel().remove(this).add(this.subject, this.predicate, rDFNode);
        this.object = rDFNode;
        return this;
    }

    public String toString() {
        String string = "[" + this.subject.toString() + ", " + this.predicate.toString() + ", ";
        string = this.object instanceof Resource ? string + "Resource<" + ((Resource)this.object).toString() + ">" : string + "Literal<" + ((Literal)this.object).toString() + ">";
        return string + "]";
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Statement && this.subject.equals(((Statement)object).getSubject()) && this.predicate.equals(((Statement)object).getPredicate()) && this.object.equals(((Statement)object).getObject());
    }

    public int hashCode() {
        return this.asTriple().hashCode();
    }

    public Statement remove() throws RDFException {
        this.mustHaveModel().remove(this);
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    public Resource asResource() {
        return this.mustHaveModel().getAnyReifiedStatement(this);
    }

    public void removeReification() {
        this.mustHaveModel().removeAllReifications(this);
    }

    public Triple asTriple() {
        return new Triple(this.subject.asNode(), this.predicate.asNode(), this.object.asNode());
    }

    public boolean isReified() throws RDFException {
        return this.mustHaveModel().isReified(this);
    }

    public ReifiedStatement createReifiedStatement() {
        return ReifiedStatementImpl.create(this);
    }

    public ReifiedStatement createReifiedStatement(String string) {
        return ReifiedStatementImpl.create(this.getModel(), string, (Statement)this);
    }

    public RSIterator listReifiedStatements() {
        return this.mustHaveModel().listReifiedStatements(this);
    }

    public static Statement toStatement(Triple triple, EnhGraph enhGraph) {
        ResourceImpl resourceImpl = new ResourceImpl(triple.getSubject(), enhGraph);
        PropertyImpl propertyImpl = new PropertyImpl(triple.getPredicate(), enhGraph);
        RDFNode rDFNode = StatementImpl.createObject(triple.getObject(), enhGraph);
        return new StatementImpl(resourceImpl, propertyImpl, rDFNode, (Model)((Object)enhGraph));
    }

    public static RDFNode createObject(Node node, EnhGraph enhGraph) {
        return node.isLiteral() ? new LiteralImpl(node, enhGraph) : new ResourceImpl(node, enhGraph);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

