/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ContainerImpl;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelI;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.SeqNodeIteratorFactoryImpl;
import com.hp.hpl.jena.vocabulary.RDF;

public class SeqImpl
extends ContainerImpl
implements Seq {
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new SeqImpl(node, enhGraph);
        }
    };
    static NodeIteratorFactory iteratorFactory = new SeqNodeIteratorFactoryImpl();

    private SeqImpl(Resource resource) {
        super(resource);
    }

    public SeqImpl(Model model) throws RDFException {
        super(model);
    }

    public SeqImpl(String string, Model model) throws RDFException {
        super(string, model);
    }

    public SeqImpl(Resource resource, Model model) throws RDFException {
        super(resource, model);
    }

    public SeqImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public Resource getResource(int n) throws RDFException {
        return this.getProperty(RDF.li(n)).getResource();
    }

    public Literal getLiteral(int n) throws RDFException {
        return this.getProperty(RDF.li(n)).getLiteral();
    }

    public RDFNode getObject(int n) throws RDFException {
        return this.getProperty(RDF.li(n)).getObject();
    }

    public boolean getBoolean(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getBoolean();
    }

    public byte getByte(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getByte();
    }

    public short getShort(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getShort();
    }

    public int getInt(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getInt();
    }

    public long getLong(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getLong();
    }

    public char getChar(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getChar();
    }

    public float getFloat(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getFloat();
    }

    public double getDouble(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getDouble();
    }

    public String getString(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getString();
    }

    public String getLanguage(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getLanguage();
    }

    public Object getObject(int n, ObjectF objectF) throws RDFException {
        return this.getProperty(RDF.li(n)).getObject(objectF);
    }

    public Resource getResource(int n, ResourceF resourceF) throws RDFException {
        return this.getProperty(RDF.li(n)).getResource(resourceF);
    }

    public Bag getBag(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getBag();
    }

    public Alt getAlt(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getAlt();
    }

    public Seq getSeq(int n) throws RDFException {
        this.checkIndex(n);
        return this.getProperty(RDF.li(n)).getSeq();
    }

    public Seq set(int n, RDFNode rDFNode) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(rDFNode);
        return this;
    }

    public Seq set(int n, boolean bl) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(bl);
        return this;
    }

    public Seq set(int n, long l) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(l);
        return this;
    }

    public Seq set(int n, float f) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(f);
        return this;
    }

    public Seq set(int n, double d) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(d);
        return this;
    }

    public Seq set(int n, char c) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(c);
        return this;
    }

    public Seq set(int n, String string) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(string);
        return this;
    }

    public Seq set(int n, String string, String string2) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(string, string2);
        return this;
    }

    public Seq set(int n, Object object) throws RDFException {
        this.checkIndex(n);
        this.getProperty(RDF.li(n)).set(object);
        return this;
    }

    public Seq add(int n, boolean bl) throws RDFException {
        return this.add(n, String.valueOf(bl));
    }

    public Seq add(int n, long l) throws RDFException {
        return this.add(n, String.valueOf(l));
    }

    public Seq add(int n, char c) throws RDFException {
        return this.add(n, String.valueOf(c));
    }

    public Seq add(int n, float f) throws RDFException {
        return this.add(n, String.valueOf(f));
    }

    public Seq add(int n, double d) throws RDFException {
        return this.add(n, String.valueOf(d));
    }

    public Seq add(int n, Object object) throws RDFException {
        return this.add(n, String.valueOf(object));
    }

    public Seq add(int n, String string) throws RDFException {
        return this.add(n, string, "");
    }

    public Seq add(int n, String string, String string2) throws RDFException {
        return this.add(n, this.literal(string, string2));
    }

    public Seq add(int n, RDFNode rDFNode) throws RDFException {
        int n2 = this.size();
        this.checkIndex(n, n2 + 1);
        this.shiftUp(n, n2);
        this.addProperty(RDF.li(n), rDFNode);
        return this;
    }

    public NodeIterator iterator() throws RDFException {
        return ((ModelI)((Object)this.getModel())).listContainerMembers(this, iteratorFactory);
    }

    public Container remove(Statement statement) throws RDFException {
        this.getModel().remove(statement);
        this.shiftDown(statement.getPredicate().getOrdinal() + 1, this.size() + 1);
        return this;
    }

    public Seq remove(int n) throws RDFException {
        this.getProperty(RDF.li(n)).remove();
        this.shiftDown(n + 1, this.size() + 1);
        return this;
    }

    public Container remove(int n, RDFNode rDFNode) throws RDFException {
        return this.remove(this.getModel().createStatement((Resource)this, RDF.li(n), rDFNode).remove());
    }

    public int indexOf(RDFNode rDFNode) throws RDFException {
        return ((ModelI)((Object)this.getModel())).containerIndexOf(this, rDFNode);
    }

    public int indexOf(boolean bl) throws RDFException {
        return this.indexOf(String.valueOf(bl));
    }

    public int indexOf(long l) throws RDFException {
        return this.indexOf(String.valueOf(l));
    }

    public int indexOf(char c) throws RDFException {
        return this.indexOf(String.valueOf(c));
    }

    public int indexOf(float f) throws RDFException {
        return this.indexOf(String.valueOf(f));
    }

    public int indexOf(double d) throws RDFException {
        return this.indexOf(String.valueOf(d));
    }

    public int indexOf(Object object) throws RDFException {
        return this.indexOf(String.valueOf(object));
    }

    public int indexOf(String string) throws RDFException {
        return this.indexOf(string, "");
    }

    public int indexOf(String string, String string2) throws RDFException {
        return this.indexOf(this.literal(string, string2));
    }

    private Literal literal(String string, String string2) {
        return new LiteralImpl(Node.createLiteral(string, string2, false), this.getModel());
    }

    protected void shiftUp(int n, int n2) throws RDFException {
        Statement statement = null;
        int n4 = n2;
        while (n4 >= n) {
            statement = this.getProperty(RDF.li(n4));
            this.getModel().remove(statement);
            this.addProperty(RDF.li(n4 + 1), statement.getObject());
            --n4;
        }
    }

    protected void shiftDown(int n, int n2) throws RDFException {
        Statement statement = null;
        int n4 = n;
        while (n4 <= n2) {
            statement = this.getProperty(RDF.li(n4));
            this.addProperty(RDF.li(n4 - 1), statement.getObject());
            statement.remove();
            ++n4;
        }
    }

    protected void checkIndex(int n) throws RDFException {
        int n2 = this.size();
        if (1 > n || n > n2) {
            throw new RDFException(18);
        }
    }

    protected void checkIndex(int n, int n2) throws RDFException {
        if (1 > n || n > n2) {
            throw new RDFException(18);
        }
    }
}

