/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceI;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.rdf.model.impl.Util;

public class ResourceImpl
extends EnhNode
implements Resource,
ResourceI {
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new ResourceImpl(node, enhGraph);
        }
    };
    private int splitHere = 0;

    private ResourceImpl(Resource resource) {
        this(resource.asNode(), resource.getModel());
    }

    private ResourceImpl(Node node, int n, Model model) {
        super(node, (ModelCom)model);
        this.splitHere = n;
    }

    public ResourceImpl() {
        this((Model)null);
    }

    public ResourceImpl(Model model) {
        this(ResourceImpl.fresh(null), 0, model);
    }

    public ResourceImpl(Node node, Model model) {
        this(node, node.isURI() ? ResourceImpl.whereToSplit(node.toString()) : 0, model);
    }

    public ResourceImpl(Node node, EnhGraph enhGraph) {
        this(node, (Model)((Object)enhGraph));
    }

    public ResourceImpl(String string) {
        this(ResourceImpl.fresh(string), ResourceImpl.whereToSplit(string), null);
    }

    public ResourceImpl(String string, String string2) {
        this(Node.createURI(string + string2), string.length(), null);
    }

    public ResourceImpl(AnonId anonId) {
        this(anonId, (Model)null);
    }

    public ResourceImpl(AnonId anonId, Model model) {
        this(Node.createAnon(anonId), 0, model);
    }

    public ResourceImpl(String string, Model model) {
        this(ResourceImpl.fresh(string), ResourceImpl.whereToSplit(string), model);
    }

    public ResourceImpl(Resource resource, Model model) {
        this(resource.getNode(), model);
    }

    public ResourceImpl(String string, String string2, Model model) {
        this(Node.createURI(string + string2), string.length(), model);
    }

    public boolean isResource() {
        return true;
    }

    private static int whereToSplit(String string) {
        if (string == null) {
            return 0;
        }
        int n = Util.splitNamespace(string);
        return n == 0 ? string.length() : n;
    }

    private static Node fresh(String string) {
        return string == null ? Node.createAnon(new AnonId()) : Node.createURI(string);
    }

    public Node getNode() {
        return this.asNode();
    }

    public AnonId getId() {
        return this.asNode().getBlankNodeId();
    }

    public String getURI() {
        return this.isAnon() ? null : this.asNode().toString();
    }

    public String getNameSpace() {
        return this.isAnon() ? null : this.getURI().substring(0, this.splitHere);
    }

    public String getLocalName() {
        return this.isAnon() ? null : this.getURI().substring(this.splitHere);
    }

    public String toString() {
        return this.asNode().toString();
    }

    public boolean isAnon() {
        return this.asNode().isBlank();
    }

    protected ModelCom mustHaveModel() {
        ModelCom modelCom = (ModelCom)this.getGraph();
        if (modelCom == null) {
            throw new RDFException(1);
        }
        return modelCom;
    }

    public Statement getProperty(Property property) throws RDFException {
        return this.mustHaveModel().getProperty(this, property);
    }

    public StmtIterator listProperties(Property property) throws RDFException {
        return this.mustHaveModel().listStatements(new SimpleSelector((Resource)this, property, (RDFNode)null));
    }

    public StmtIterator listProperties() throws RDFException {
        return this.mustHaveModel().listStatements(new SimpleSelector((Resource)this, null, (RDFNode)null));
    }

    public Resource addProperty(Property property, boolean bl) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, bl);
        return this;
    }

    public Resource addProperty(Property property, long l) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, l);
        return this;
    }

    public Resource addProperty(Property property, char c) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, c);
        return this;
    }

    public Resource addProperty(Property property, float f) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, f);
        return this;
    }

    public Resource addProperty(Property property, double d) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, d);
        return this;
    }

    public Resource addProperty(Property property, String string) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, string);
        return this;
    }

    public Resource addProperty(Property property, String string, String string2) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, string, string2);
        return this;
    }

    public Resource addProperty(Property property, Object object) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, object);
        return this;
    }

    public Resource addProperty(Property property, RDFNode rDFNode) throws RDFException {
        this.mustHaveModel().add((Resource)this, property, rDFNode);
        return this;
    }

    public boolean hasProperty(Property property) throws RDFException {
        return this.mustHaveModel().contains(this, property);
    }

    public boolean hasProperty(Property property, boolean bl) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, bl);
    }

    public boolean hasProperty(Property property, long l) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, l);
    }

    public boolean hasProperty(Property property, char c) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, c);
    }

    public boolean hasProperty(Property property, float f) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, f);
    }

    public boolean hasProperty(Property property, double d) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, d);
    }

    public boolean hasProperty(Property property, String string) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, string);
    }

    public boolean hasProperty(Property property, String string, String string2) throws RDFException {
        return this.mustHaveModel().contains(this, property, string, string2);
    }

    public boolean hasProperty(Property property, Object object) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, object);
    }

    public boolean hasProperty(Property property, RDFNode rDFNode) throws RDFException {
        return this.mustHaveModel().contains((Resource)this, property, rDFNode);
    }

    public Resource removeProperties() throws RDFException {
        StmtIterator stmtIterator = this.mustHaveModel().listStatements(new SimpleSelector((Resource)this, null, (RDFNode)null));
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            stmtIterator.remove();
        }
        return this;
    }

    public Resource begin() throws RDFException {
        this.mustHaveModel().begin();
        return this;
    }

    public Resource abort() throws RDFException {
        this.mustHaveModel().abort();
        return this;
    }

    public Resource commit() throws RDFException {
        this.mustHaveModel().commit();
        return this;
    }

    public Resource port(Model model) throws RDFException {
        if (this.getGraph() == model) {
            return this;
        }
        if (model instanceof ModelCom) {
            return IteratorFactory.asResource(this.asNode(), (ModelCom)model);
        }
        if (this.isAnon()) {
            return model.createResource();
        }
        return model.createResource(this.getURI());
    }

    public Model getModel() {
        return (ModelCom)this.getGraph();
    }

    public Resource getEmbeddedResource() {
        return this;
    }
}

