/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ErrorHelper;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.vocabulary.RDF;

public class PropertyImpl
extends ResourceImpl
implements Property {
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new PropertyImpl(node, enhGraph);
        }
    };
    protected int ordinal = 0;

    private PropertyImpl(Resource resource) {
        this(resource.getURI(), resource.getModel());
    }

    public PropertyImpl(String string) throws RDFException {
        super(string);
        this.checkLocalName();
        this.checkOrdinal();
    }

    private void checkLocalName() {
        String string = this.getLocalName();
        if (string == null || string.equals("")) {
            throw new RDFException(2);
        }
    }

    public PropertyImpl(String string, String string2) throws RDFException {
        super(string, string2);
        this.checkLocalName();
        this.checkOrdinal();
    }

    public PropertyImpl(String string, Model model) throws RDFException {
        super(string, model);
        this.checkOrdinal();
    }

    public PropertyImpl(String string, String string2, Model model) throws RDFException {
        super(string, string2, model);
        this.checkOrdinal();
    }

    public PropertyImpl(Node node, EnhGraph enhGraph) throws RDFException {
        super(node, enhGraph);
        this.checkOrdinal();
    }

    public PropertyImpl(String string, String string2, int n, Model model) throws RDFException {
        super(string, string2, model);
        this.checkLocalName();
        this.ordinal = n;
    }

    public boolean isProperty() {
        return true;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    protected void checkOrdinal() {
        block4: {
            String string = this.getNameSpace();
            String string2 = this.getLocalName();
            if (string2.length() <= 0 || string2.charAt(0) != '_' || !string.equals(RDF.getURI()) || !string.equals(RDF.getURI()) || string2.length() <= 1) break block4;
            int n = 1;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (c < '0' || c > '9') {
                    return;
                }
                ++n;
            }
            try {
                this.ordinal = Integer.parseInt(string2.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorHelper.logInternalError(this.getClass().getName(), 1);
            }
        }
    }
}

