/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class NTripleWriter
implements RDFWriter {
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private static boolean[] okURIChars = new boolean[128];

    public void write(Model model, OutputStream outputStream, String string) throws RDFException {
        try {
            Writer writer;
            try {
                writer = new OutputStreamWriter(outputStream, "ascii");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.warning("ASCII is not supported!", "NTripleWriter", "write", unsupportedEncodingException);
                writer = FileUtils.asUTF8(outputStream);
            }
            this.write(model, writer, string);
            writer.flush();
        }
        catch (Exception exception) {
            this.errorHandler.error(exception);
        }
    }

    public void write(Model model, Writer writer, String string) throws RDFException {
        try {
            Model model2 = ModelCom.withHiddenStatements(model);
            PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            StmtIterator stmtIterator = model2.listStatements();
            Statement statement = null;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.nextStatement();
                NTripleWriter.writeResource(statement.getSubject(), printWriter);
                printWriter.print(" ");
                NTripleWriter.writeResource(statement.getPredicate(), printWriter);
                printWriter.print(" ");
                NTripleWriter.writeNode(statement.getObject(), printWriter);
                printWriter.println(" .");
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            this.errorHandler.error(exception);
        }
    }

    public Object setProperty(String string, Object object) throws RDFException {
        throw new RDFException(22);
    }

    public void setNsPrefix(String string, String string2) {
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public static void write(Model model, PrintWriter printWriter) throws IOException, RDFException {
        StmtIterator stmtIterator = model.listStatements();
        Statement statement = null;
        while (stmtIterator.hasNext()) {
            statement = stmtIterator.nextStatement();
            NTripleWriter.writeResource(statement.getSubject(), printWriter);
            printWriter.print(" ");
            NTripleWriter.writeResource(statement.getPredicate(), printWriter);
            printWriter.print(" ");
            NTripleWriter.writeNode(statement.getObject(), printWriter);
            printWriter.println(" .");
        }
    }

    protected static void writeResource(Resource resource, PrintWriter printWriter) throws RDFException {
        if (resource.isAnon()) {
            printWriter.print(NTripleWriter.anonName(resource.getId()));
        } else {
            printWriter.print("<");
            NTripleWriter.writeURIString(resource.getURI(), printWriter);
            printWriter.print(">");
        }
    }

    private static void writeURIString(String string, PrintWriter printWriter) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < okURIChars.length && okURIChars[c]) {
                printWriter.print(c);
            } else {
                String string2 = Integer.toHexString(c).toUpperCase();
                int n2 = 4 - string2.length();
                printWriter.print("\\u");
                while (n2 > 0) {
                    printWriter.print("0");
                    --n2;
                }
                printWriter.print(string2);
            }
            ++n;
        }
    }

    private static void writeString(String string, PrintWriter printWriter) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\' || c == '\"') {
                printWriter.print('\\');
                printWriter.print(c);
            } else if (c == '\n') {
                printWriter.print("\\n");
            } else if (c == '\r') {
                printWriter.print("\\r");
            } else if (c == '\t') {
                printWriter.print("\\t");
            } else if (c >= ' ' && c < '\u007f') {
                printWriter.print(c);
            } else {
                String string2 = Integer.toHexString(c).toUpperCase();
                int n2 = 4 - string2.length();
                printWriter.print("\\u");
                while (n2 > 0) {
                    printWriter.print("0");
                    --n2;
                }
                printWriter.print(string2);
            }
            ++n;
        }
    }

    protected static void writeLiteral(Literal literal, PrintWriter printWriter) {
        String string;
        String string2 = literal.getString();
        printWriter.print('\"');
        NTripleWriter.writeString(string2, printWriter);
        printWriter.print('\"');
        String string3 = literal.getLanguage();
        if (string3 != null && !string3.equals("")) {
            printWriter.print("@" + string3);
        }
        if ((string = literal.getDatatypeURI()) != null && !string.equals("")) {
            printWriter.print("^^<" + string + ">");
        }
    }

    protected static void writeNode(RDFNode rDFNode, PrintWriter printWriter) throws RDFException {
        if (rDFNode instanceof Literal) {
            NTripleWriter.writeLiteral((Literal)rDFNode, printWriter);
        } else {
            NTripleWriter.writeResource((Resource)rDFNode, printWriter);
        }
    }

    protected static String anonName(AnonId anonId) {
        String string = "_:A";
        String string2 = anonId.toString();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            string = c == 'X' ? string + "XX" : (Character.isLetterOrDigit(c) ? string + c : string + "X" + Integer.toHexString(c) + "X");
            ++n;
        }
        return string;
    }

    static {
        int n = 32;
        while (n < 127) {
            NTripleWriter.okURIChars[n] = true;
            ++n;
        }
        NTripleWriter.okURIChars[60] = false;
        NTripleWriter.okURIChars[62] = false;
        NTripleWriter.okURIChars[92] = false;
    }
}

