/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.IStream;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class NTripleReader
implements RDFReader {
    static final Logger log = Logger.getLogger((Class)(class$com$hp$hpl$jena$rdf$model$impl$NTripleReader == null ? (class$com$hp$hpl$jena$rdf$model$impl$NTripleReader = NTripleReader.class$("com.hp.hpl.jena.rdf.model.impl.NTripleReader")) : class$com$hp$hpl$jena$rdf$model$impl$NTripleReader));
    private Model model = null;
    private Hashtable anons = new Hashtable();
    private IStream in = null;
    private boolean inErr = false;
    private int errCount = 0;
    private static final int sbLength = 200;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private String base;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$impl$NTripleReader;

    NTripleReader() {
    }

    public void read(Model model, InputStream inputStream, String string) throws RDFException {
        this.read(model, FileUtils.asUTF8(inputStream), string);
    }

    public void read(Model model, Reader reader, String string) throws RDFException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.model = model;
        this.base = string == null ? "" : string + ": ";
        this.in = new IStream(reader);
        this.readRDF();
        if (this.errCount != 0) {
            throw new RDFException(24);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(Model model, String string) throws RDFException {
        try {
            try {
                this.read(model, new InputStreamReader(new URL(string).openStream()), string);
            }
            catch (Exception exception) {
                throw new RDFException(exception);
            }
            Object var5_3 = null;
            if (this.errCount == 0) return;
            throw new RDFException(24);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.errCount == 0) throw throwable;
            throw new RDFException(24);
        }
    }

    public Object setProperty(String string, Object object) throws RDFException {
        this.errorHandler.error(new RDFException(22));
        return null;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    /*
     * Unable to fully structure code
     */
    protected void readRDF() throws RDFException {
        var2_1 = null;
        ** GOTO lbl33
        {
            this.inErr = false;
            this.skipWhiteSpace();
            if (this.in.eof()) {
                return;
            }
            var1_2 = this.readResource();
            if (this.inErr) ** GOTO lbl29
            this.skipWhiteSpace();
            try {
                var2_1 = this.model.createProperty(this.readResource().getURI());
            }
            catch (Exception var4_5) {
                this.errorHandler.fatalError(var4_5);
            }
            if (this.inErr) ** GOTO lbl29
            this.skipWhiteSpace();
            var3_3 = this.readNode();
            if (this.inErr) ** GOTO lbl29
            this.skipWhiteSpace();
            if (this.badEOF() || !this.expect(".")) ** GOTO lbl29
            try {
                this.model.add(var1_2, var2_1, var3_3);
            }
            catch (Exception var4_6) {
                this.errorHandler.fatalError(var4_6);
            }
            do {
                if (!this.in.eof()) continue block4;
lbl29:
                // 5 sources

                if (!this.inErr) continue;
                ++this.errCount;
                while (!this.in.eof() && this.in.readChar() != '\n') {
                }
lbl33:
                // 3 sources

            } while (!this.in.eof());
        }
    }

    public Resource readResource() throws RDFException {
        char c = this.in.readChar();
        if (this.badEOF()) {
            return null;
        }
        if (c == '_') {
            if (!this.expect(":")) {
                return null;
            }
            String string = this.readName();
            if (string == null) {
                this.syntaxError("expected bNode label");
                return null;
            }
            return this.lookupResource(string);
        }
        if (c == '<') {
            String string = this.readURI();
            if (string == null) {
                this.inErr = true;
                return null;
            }
            c = this.in.readChar();
            if (c != '>') {
                this.syntaxError("expected '>'");
                return null;
            }
            return this.model.createResource(string);
        }
        this.syntaxError("unexpected input");
        return null;
    }

    public RDFNode readNode() throws RDFException {
        this.skipWhiteSpace();
        switch (this.in.nextChar()) {
            case '\"': {
                return this.readLiteral(false);
            }
            case 'x': {
                return this.readLiteral(true);
            }
            case '<': 
            case '_': {
                return this.readResource();
            }
        }
        this.syntaxError("unexpected input");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Literal readLiteral(boolean bl) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (bl) {
            this.deprecated("Use ^^rdf:XMLLiteral not xml\"literals\", .");
            if (!this.expect("xml")) {
                return null;
            }
        }
        if (!this.expect("\"")) {
            return null;
        }
        while (true) {
            int n;
            block21: {
                block22: {
                    char c;
                    block24: {
                        block23: {
                            n = this.in.readChar();
                            if (this.badEOF()) {
                                return null;
                            }
                            if (n != 92) break block22;
                            c = this.in.readChar();
                            if (this.in.eof()) {
                                this.inErr = true;
                                return null;
                            }
                            if (c != 'n') break block23;
                            n = 10;
                            break block21;
                        }
                        if (c != 'r') break block24;
                        n = 13;
                        break block21;
                    }
                    if (c == 't') {
                        n = 9;
                        break block21;
                    } else if (c == '\\' || c == '\"') {
                        n = c;
                        break block21;
                    } else {
                        if (c != 'u') {
                            this.syntaxError("illegal escape sequence '" + c + "'");
                            return null;
                        }
                        n = this.readUnicode4Escape();
                        if (this.inErr) {
                            return null;
                        }
                    }
                    break block21;
                }
                if (n == 34) {
                    String string;
                    if ('@' == this.in.nextChar()) {
                        this.expect("@");
                        string = this.readLang();
                    } else if ('-' == this.in.nextChar()) {
                        this.expect("-");
                        this.deprecated("Language tags should be introduced with @ not -.");
                        string = this.readLang();
                    } else {
                        string = "";
                    }
                    if (bl) {
                        return this.model.createLiteral(stringBuffer.toString(), string, bl);
                    }
                    if ('^' != this.in.nextChar()) {
                        return this.model.createLiteral(stringBuffer.toString(), string);
                    }
                    String string2 = null;
                    if (!this.expect("^^<")) {
                        this.syntaxError("ill-formed datatype");
                        return null;
                    }
                    string2 = this.readURI();
                    if (string2 != null && this.expect(">")) {
                        return this.model.createTypedLiteral(stringBuffer.toString(), string, string2);
                    }
                    return null;
                }
            }
            stringBuffer = stringBuffer.append((char)n);
        }
    }

    private char readUnicode4Escape() {
        char[] cArray = new char[]{this.in.readChar(), this.in.readChar(), this.in.readChar(), this.in.readChar()};
        if (this.badEOF()) {
            return '\u0000';
        }
        try {
            return (char)Integer.parseInt(new String(cArray), 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.syntaxError("bad unicode escape sequence");
            return '\u0000';
        }
    }

    private void deprecated(String string) {
        this.errorHandler.warning(new RDFException(24, this.syntaxErrorMessage("Deprecation warning", string, this.in.getLinepos(), this.in.getCharpos())));
    }

    private void syntaxError(String string) {
        this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("Syntax error", string, this.in.getLinepos(), this.in.getCharpos())));
        this.inErr = true;
    }

    private String readLang() {
        StringBuffer stringBuffer = new StringBuffer(15);
        char c;
        while (!Character.isWhitespace(c = this.in.nextChar()) && c != '.' && c != '^') {
            stringBuffer = stringBuffer.append(this.in.readChar());
        }
        return stringBuffer.toString();
    }

    private boolean badEOF() {
        if (this.in.eof()) {
            this.syntaxError("premature end of file");
        }
        return this.inErr;
    }

    protected String readURI() {
        StringBuffer stringBuffer = new StringBuffer(200);
        while (this.in.nextChar() != '>') {
            char c = this.in.readChar();
            if (c == '\\') {
                this.expect("u");
                c = this.readUnicode4Escape();
            }
            if (this.badEOF()) {
                return null;
            }
            stringBuffer = stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected String readName() {
        StringBuffer stringBuffer = new StringBuffer(200);
        while (!Character.isWhitespace(this.in.nextChar())) {
            stringBuffer = stringBuffer.append(this.in.readChar());
            if (!this.badEOF()) continue;
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean expect(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (this.badEOF()) {
                return false;
            }
            char c2 = this.in.readChar();
            if (c2 != c) {
                this.syntaxError("expected \"" + string + "\"");
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.in.nextChar()) || this.in.nextChar() == '#') {
            char c = this.in.readChar();
            if (this.in.eof()) {
                return;
            }
            if (c != '#') continue;
            while (c != '\n') {
                c = this.in.readChar();
                if (!this.in.eof()) continue;
                return;
            }
        }
    }

    protected Resource lookupResource(String string) throws RDFException {
        Resource resource = (Resource)this.anons.get(string);
        if (resource == null) {
            resource = this.model.createResource();
            this.anons.put(string, resource);
        }
        return resource;
    }

    protected String syntaxErrorMessage(String string, String string2, int n, int n2) {
        return this.base + string + " at line " + n + " position " + n2 + ": " + string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

