/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ModelMatcher {
    private static Random random = new Random(0L);
    private static final boolean TRACE = false;
    private Model m;
    private ModelMatcher other;
    private int myHashLevel = 0;
    private static final int MAX_HASH_DEPTH = 3;
    private Map table;
    private int state;
    private static final int REHASHING = 1;
    private static final int HASH_OK = 2;
    private static final int HASH_BAD = 4;
    private Set unboundAnonResources = new HashSet();
    private Set boundAnonResources = new HashSet();
    private boolean refinableHash;
    private static final int NOVARS = 0;
    private static final int SX = 1;
    private static final int PX = 4;
    private static final int OX = 16;
    private static final int SD = 2;
    private static final int PD = 8;
    private static final int OD = 32;
    private static final int SXPY = 5;
    private static final int SXOY = 17;
    private static final int PXOY = 20;
    private static final int SXPYOZ = 21;
    private static final int SXPX = 10;
    private static final int SXOX = 34;
    private static final int PXOX = 40;
    private static final int SXPXOY = 26;
    private static final int SXPYOX = 38;
    private static final int SXPYOY = 41;
    private static final int SXPXOX = 42;
    private static final int S = 3;
    private static final int P = 12;
    private static final int O = 48;
    private Map anonLookup = new HashMap();
    private static int col = 0;
    private static boolean lastDir = false;

    public static boolean equals(Model model, Model model2) throws RDFException {
        if (model == model2) {
            return true;
        }
        return ModelMatcher.match(model, model2) != null;
    }

    public static Resource[][] match(Model model, Model model2) throws RDFException {
        try {
            return new ModelMatcher(model).match(new ModelMatcher(model2));
        }
        catch (RDFException rDFException) {
            throw rDFException;
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException.getMessage());
            runtimeException.printStackTrace(System.out);
            throw runtimeException;
        }
    }

    private ModelMatcher(Model model) {
        this.m = model;
    }

    private Resource[][] match(ModelMatcher modelMatcher) throws RDFException {
        this.other = modelMatcher;
        modelMatcher.other = this;
        this.in(4);
        if (this.m.size() != this.other.m.size()) {
            return null;
        }
        int n = this.prepare(this.other.m);
        if (n == -1 || n != this.other.prepare(this.m)) {
            return null;
        }
        if (this.bind()) {
            if (!this.unboundAnonResources.isEmpty()) {
                ModelMatcher.impossible();
            }
            Resource[][] resourceArray = new Resource[this.boundAnonResources.size()][];
            int n2 = 0;
            Iterator iterator = this.boundAnonResources.iterator();
            while (iterator.hasNext()) {
                AnonResource anonResource = (AnonResource)iterator.next();
                resourceArray[n2++] = new Resource[]{anonResource.r, anonResource.bound.r};
            }
            return resourceArray;
        }
        return null;
    }

    private boolean bind() throws RDFException {
        Set set = this.obligBindings();
        if (set == null) {
            return false;
        }
        this.check(2);
        Bucket bucket = this.smallestBucket();
        if (bucket == null) {
            return true;
        }
        Bucket bucket2 = this.other.matchBucket(bucket);
        if (bucket2 != null) {
            AnonResource anonResource = bucket.aMember();
            Iterator iterator = bucket2.members();
            while (iterator.hasNext()) {
                this.check(6);
                AnonResource anonResource2 = (AnonResource)iterator.next();
                ModelMatcher.trace(true, "Guess: ");
                if (!bucket.bind(anonResource, bucket2, anonResource2)) continue;
                if (this.bind()) {
                    return true;
                }
                anonResource.unbind();
            }
        }
        this.unbindAll(set);
        return false;
    }

    private Set obligBindings() throws RDFException {
        boolean bl;
        int n = 0;
        HashSet<AnonResource> hashSet = new HashSet<AnonResource>();
        this.check(6);
        do {
            if (this.rehash(n) != this.other.rehash(n)) {
                this.unbindAll(hashSet);
                return null;
            }
            this.refinableHash = false;
            bl = false;
            Iterator iterator = this.scanBuckets();
            while (iterator.hasNext()) {
                bl = true;
                Bucket bucket = (Bucket)iterator.next();
                Bucket bucket2 = this.other.matchBucket(bucket);
                if (bucket2 == null) {
                    this.unbindAll(hashSet);
                    return null;
                }
                AnonResource anonResource = bucket.aMember();
                if (!bucket.bind(bucket2)) {
                    this.unbindAll(hashSet);
                    return null;
                }
                hashSet.add(anonResource);
            }
            if (bl) {
                n = 0;
                continue;
            }
            ++n;
        } while (n < 3 && (this.refinableHash || bl));
        return hashSet;
    }

    private Iterator scanBuckets() {
        this.check(2);
        return new FilterIterator(new Filter(){

            public boolean accept(Object object) {
                Bucket bucket = (Bucket)object;
                if (bucket.size() == 1) {
                    return true;
                }
                if (!ModelMatcher.this.refinableHash) {
                    Iterator iterator = bucket.members();
                    while (iterator.hasNext()) {
                        if (((AnonResource)iterator.next()).friends.isEmpty()) continue;
                        ModelMatcher.this.refinableHash = true;
                        break;
                    }
                }
                return false;
            }
        }, this.table.values().iterator());
    }

    private void unbindAll(Set set) throws RDFException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((AnonResource)iterator.next()).unbind();
        }
        this.in(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int prepare(Model var1_1) throws RDFException {
        block3: {
            var2_2 = this.m.listStatements();
            this.myHashLevel = 0;
            var3_3 = 0;
            try lbl-1000:
            // 3 sources

            {
                block5: {
                    block4: {
                        if (var2_2.hasNext()) break block4;
                    }
                    var4_4 = var2_2.nextStatement();
                    var5_6 = new AnonStatement(var4_4);
                    if (var5_6.pattern != 0) break block5;
                    if (var1_1.contains(var4_4)) ** GOTO lbl-1000
                    var6_7 = -1;
                    var9_9 = null;
                    var2_2.close();
                    return var6_7;
                }
                var3_3 += var5_6.myHashCode(var5_6.vars[0]);
                var6_7 = 0;
                break block3;
                var4_5 = var3_3 == -1 ? 1 : var3_3;
                var9_10 = null;
            }
            catch (Throwable var8_12) {
                var9_11 = null;
                var2_2.close();
                throw var8_12;
            }
            var2_2.close();
            return var4_5;
lbl30:
            // 1 sources

            var5_6.vars[var6_7].occursIn.add(var5_6);
            var7_8 = var6_7 + 1;
            while (var7_8 < var5_6.vars.length) {
                var5_6.vars[var6_7].friends.add(var5_6.vars[var7_8]);
                var5_6.vars[var7_8].friends.add(var5_6.vars[var6_7]);
                ++var7_8;
            }
            ++var6_7;
        }
        if (var6_7 < var5_6.vars.length) ** GOTO lbl30
    }

    private Bucket smallestBucket() {
        this.check(2);
        Iterator iterator = this.table.values().iterator();
        Bucket bucket = null;
        int n = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            Bucket bucket2 = (Bucket)iterator.next();
            int n2 = bucket2.size();
            if (n2 >= n) continue;
            bucket = bucket2;
            n = n2;
        }
        return bucket;
    }

    private Bucket matchBucket(Bucket bucket) {
        this.check(2);
        Integer n = new Integer(bucket.aMember().myHash);
        Bucket bucket2 = (Bucket)this.table.get(n);
        if (bucket2 != null && bucket.size() != bucket2.size()) {
            return null;
        }
        return bucket2;
    }

    private int rehash(int n) {
        return this.rehash0(n);
    }

    private int rehash0(int n) {
        Object object;
        Object object2;
        this.in(1);
        this.table = new HashMap();
        this.myHashLevel = n;
        Iterator iterator = this.unboundAnonResources.iterator();
        while (iterator.hasNext()) {
            AnonResource anonResource = (AnonResource)iterator.next();
            object2 = new Integer(anonResource.myHashCode());
            object = (Bucket)this.table.get(object2);
            if (object == null) {
                object = new Bucket();
                this.table.put(object2, object);
            }
            ((Bucket)object).add(anonResource);
        }
        int n2 = 0;
        object2 = this.table.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            int n4 = (Integer)object.getKey();
            Bucket bucket = (Bucket)object.getValue();
            int n5 = bucket.size();
            n2 += n5 * 65537 ^ n4;
        }
        this.in(2);
        return n2;
    }

    private static boolean legalPattern(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    private static int varPosInPattern(int n, int n2) {
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if (n != 0) break;
                return 1;
            }
            case 16: {
                if (n != 0) break;
                return 16;
            }
            case 4: {
                if (n != 0) break;
                return 4;
            }
            case 5: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                }
                break;
            }
            case 17: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 20: {
                switch (n) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 21: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 16;
                    }
                }
                break;
            }
            case 10: {
                if (n != 0) break;
                return 10;
            }
            case 34: {
                if (n != 0) break;
                return 34;
            }
            case 40: {
                if (n != 0) break;
                return 40;
            }
            case 26: {
                switch (n) {
                    case 0: {
                        return 10;
                    }
                    case 1: {
                        return 16;
                    }
                }
                break;
            }
            case 38: {
                switch (n) {
                    case 0: {
                        return 34;
                    }
                    case 1: {
                        return 4;
                    }
                }
                break;
            }
            case 41: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 40;
                    }
                }
                break;
            }
            case 42: {
                if (n != 0) break;
                return 42;
            }
        }
        System.out.println("Bad: " + n + " " + n2);
        ModelMatcher.impossible();
        return 0;
    }

    static void count(Map map, SomeResource someResource, int n) {
        if (someResource instanceof AnonResource) {
            int[] nArray = (int[])map.get(someResource);
            if (nArray == null) {
                nArray = new int[]{-1, -1, -1};
                map.put(someResource, nArray);
            }
            int n2 = 0;
            while (n2 < 3) {
                if (nArray[n2] == -1) {
                    nArray[n2] = n;
                    return;
                }
                ++n2;
            }
        }
    }

    private SomeResource convert(RDFNode rDFNode) {
        if (rDFNode instanceof Resource && ((Resource)rDFNode).isAnon()) {
            SomeResource someResource = (SomeResource)this.anonLookup.get(rDFNode);
            if (someResource == null) {
                someResource = new AnonResource((Resource)rDFNode);
                this.anonLookup.put(rDFNode, someResource);
            }
            return someResource;
        }
        return new FixedResource(rDFNode);
    }

    private void check(int n) {
        if ((this.state & n) == 0) {
            ModelMatcher.impossible();
        }
    }

    private void in(int n) {
        this.state = n;
        this.other.state = n;
    }

    private static void impossible() {
        throw new RuntimeException("Cannot happen!");
    }

    private static void trace(boolean bl, String string) {
    }

    private static void traceNL() {
    }

    private class AnonResource
    implements SomeResource {
        AnonResource bound;
        Resource r;
        Set occursIn = new HashSet();
        int[] hash = new int[3];
        int boundHash;
        Set friends = new HashSet();
        int myHash;

        public String toString() {
            String string = this.r.toString();
            if (this.bound != null) {
                string = string + "[" + this.bound.r.toString() + "]";
            }
            return string;
        }

        AnonResource(Resource resource) {
            ModelMatcher.this.unboundAnonResources.add(this);
            this.r = resource;
        }

        public int myHashCodeFromStatement() {
            if (this.bound != null) {
                return this.boundHash;
            }
            if (ModelMatcher.this.myHashLevel == 0) {
                return -889275714;
            }
            ModelMatcher.this.check(3);
            return this.hash[ModelMatcher.this.myHashLevel - 1];
        }

        int myHashCode() {
            ModelMatcher.this.check(1);
            if (this.bound != null) {
                ModelMatcher.impossible();
            }
            this.myHash = 0;
            Iterator iterator = this.occursIn.iterator();
            while (iterator.hasNext()) {
                AnonStatement anonStatement = (AnonStatement)iterator.next();
                this.myHash += anonStatement.myHashCode(this);
            }
            this.hash[((ModelMatcher)ModelMatcher.this).myHashLevel] = this.myHash;
            return this.myHash;
        }

        void bind(AnonResource anonResource) throws RDFException {
            this.bound = anonResource;
            if (!ModelMatcher.this.unboundAnonResources.remove(this)) {
                ModelMatcher.impossible();
            }
            ModelMatcher.this.boundAnonResources.add(this);
            if (anonResource.bound == null) {
                ModelMatcher.trace(true, this.r.getId() + "=" + anonResource.r.getId() + ", ");
                anonResource.bind(this);
                this.bound.boundHash = this.boundHash = random.nextInt();
            }
            if (this.bound.bound != this) {
                ModelMatcher.impossible();
            }
        }

        void unbind() throws RDFException {
            AnonResource anonResource = this.bound;
            this.bound = null;
            if (!ModelMatcher.this.boundAnonResources.remove(this)) {
                ModelMatcher.impossible();
            }
            ModelMatcher.this.unboundAnonResources.add(this);
            if (anonResource.bound != null) {
                ModelMatcher.trace(false, this.r.getId() + "!=" + anonResource.r.getId() + ", ");
                if (anonResource.bound != this) {
                    ModelMatcher.impossible();
                }
                anonResource.unbind();
            }
            ModelMatcher.this.in(4);
        }

        boolean checkBinding(AnonResource anonResource) {
            Set set;
            if (this.occursIn.size() != anonResource.occursIn.size()) {
                return false;
            }
            Set set2 = this.wrapStatements();
            return set2.removeAll(set = anonResource.wrapStatements()) && set2.isEmpty();
        }

        private Set wrapStatements() {
            if (ModelMatcher.this.state == 4) {
                ModelMatcher.this.myHashLevel = 0;
            }
            HashSet<StatementWrapper> hashSet = new HashSet<StatementWrapper>();
            Iterator iterator = this.occursIn.iterator();
            while (iterator.hasNext()) {
                hashSet.add(this.wrapStatement((AnonStatement)iterator.next()));
            }
            return hashSet;
        }

        public boolean mightBeEqual(SomeResource someResource) {
            if (someResource != null && someResource instanceof AnonResource) {
                AnonResource anonResource = (AnonResource)someResource;
                return anonResource == this || this.bound == anonResource || this.bound == null && anonResource.bound == null;
            }
            return false;
        }

        StatementWrapper wrapStatement(AnonStatement anonStatement) {
            return new StatementWrapper(anonStatement);
        }

        private class StatementWrapper {
            int hash;
            AnonStatement statement;

            public boolean equals(Object object) {
                if (object == null || !(object instanceof StatementWrapper)) {
                    return false;
                }
                StatementWrapper statementWrapper = (StatementWrapper)object;
                return this.hash == statementWrapper.hash && this.statement.contextualEquals(AnonResource.this, statementWrapper.statement, statementWrapper.asAnonR());
            }

            public int hashCode() {
                return this.hash;
            }

            StatementWrapper(AnonStatement anonStatement) {
                this.hash = anonStatement.myHashCode(AnonResource.this);
                this.statement = anonStatement;
            }

            AnonResource asAnonR() {
                return AnonResource.this;
            }
        }
    }

    private class Bucket {
        Set anonRes = new HashSet();
        int[] hash = new int[3];

        private Bucket() {
        }

        boolean bind(Bucket bucket) throws RDFException {
            return this.bind(this.aMember(), bucket, bucket.aMember());
        }

        boolean bind(AnonResource anonResource, Bucket bucket, AnonResource anonResource2) throws RDFException {
            if (anonResource.checkBinding(anonResource2)) {
                anonResource.bind(anonResource2);
                return true;
            }
            return false;
        }

        void add(AnonResource anonResource) {
            this.anonRes.add(anonResource);
        }

        AnonResource aMember() {
            return (AnonResource)this.anonRes.iterator().next();
        }

        Iterator members() {
            return this.anonRes.iterator();
        }

        int size() {
            return this.anonRes.size();
        }
    }

    private class AnonStatement {
        int varCount;
        AnonResource[] vars;
        SomeResource subj;
        SomeResource pred;
        SomeResource obj;
        int pattern;

        AnonStatement(Statement statement) {
            HashMap hashMap = new HashMap();
            this.pattern = 0;
            this.subj = ModelMatcher.this.convert(statement.getSubject());
            this.pred = ModelMatcher.this.convert(statement.getPredicate());
            this.obj = ModelMatcher.this.convert(statement.getObject());
            ModelMatcher.count(hashMap, this.subj, 0);
            ModelMatcher.count(hashMap, this.pred, 2);
            ModelMatcher.count(hashMap, this.obj, 4);
            this.varCount = hashMap.size();
            this.vars = new AnonResource[this.varCount];
            this.add(this.subj);
            this.add(this.pred);
            this.add(this.obj);
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                int[] nArray = (int[])iterator.next();
                int n = 2;
                while (nArray[n] == -1) {
                    --n;
                }
                int n2 = n == 0 ? 1 : 2;
                int n4 = 0;
                while (n4 <= n) {
                    this.pattern |= n2 << nArray[n4];
                    ++n4;
                }
            }
            if (!ModelMatcher.legalPattern(this.pattern)) {
                System.out.println("s: " + this.subj + " p: " + this.pred + " o: " + this.obj + " pattern: " + this.pattern);
                ModelMatcher.impossible();
            }
        }

        private void add(SomeResource someResource) {
            if (someResource instanceof AnonResource) {
                int n = 0;
                while (n < this.vars.length) {
                    if (this.vars[n] == null || this.vars[n] == someResource) {
                        this.vars[n] = (AnonResource)someResource;
                        return;
                    }
                    ++n;
                }
                ModelMatcher.impossible();
            }
        }

        int varPos(AnonResource anonResource) {
            int n = 0;
            while (n < this.vars.length) {
                if (this.vars[n] == anonResource) {
                    return ModelMatcher.varPosInPattern(n, this.pattern);
                }
                ++n;
            }
            ModelMatcher.impossible();
            return 0;
        }

        int myHashCode(AnonResource anonResource) {
            int n;
            int n2 = n = this.varPos(anonResource);
            if ((n & 3) == 0) {
                n2 ^= this.subj.myHashCodeFromStatement() * 257;
            }
            if ((n & 0xC) == 0) {
                n2 ^= this.pred.myHashCodeFromStatement() * 63;
            }
            if ((n & 0x30) == 0) {
                n2 ^= this.obj.myHashCodeFromStatement() * 65;
            }
            return n2;
        }

        boolean contextualEquals(AnonResource anonResource, AnonStatement anonStatement, AnonResource anonResource2) {
            int n = this.varPos(anonResource);
            if (n != anonStatement.varPos(anonResource2)) {
                return false;
            }
            return !((n & 3) == 0 && !this.subj.mightBeEqual(anonStatement.subj) || (n & 0xC) == 0 && !this.pred.mightBeEqual(anonStatement.pred) || (n & 0x30) == 0 && !this.obj.mightBeEqual(anonStatement.obj));
        }
    }

    private static class FixedResource
    implements SomeResource {
        int hash;
        RDFNode node;

        public String toString() {
            return "f" + this.hash;
        }

        public int myHashCodeFromStatement() {
            return this.hash;
        }

        FixedResource(RDFNode rDFNode) {
            this.hash = rDFNode.hashCode();
            this.node = rDFNode;
        }

        public boolean mightBeEqual(SomeResource someResource) {
            if (someResource != null && someResource instanceof FixedResource) {
                FixedResource fixedResource = (FixedResource)someResource;
                return this.hash == fixedResource.hash && this.node.equals(fixedResource.node);
            }
            return false;
        }
    }

    private static interface SomeResource {
        public int myHashCodeFromStatement();

        public boolean mightBeEqual(SomeResource var1);
    }
}

