/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.LiteralLabel;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.StandardTripleMatch;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.IteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelI;
import com.hp.hpl.jena.rdf.model.impl.ModelReifier;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.NsIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceI;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ModelCom
extends EnhGraph
implements Model,
ModelI {
    private RDFReaderF readerFactory = new RDFReaderFImpl();
    private RDFWriterF writerFactory = new RDFWriterFImpl();
    protected ModelReifier modelReifier = new ModelReifier(this);
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Seq;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Bag;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Alt;

    public ModelCom(Graph graph) {
        this(graph, BuiltinPersonalities.model);
    }

    public boolean isModel() {
        return true;
    }

    public QueryHandler queryHandler() {
        return this.getGraph().queryHandler();
    }

    public ModelCom(Graph graph, Personality personality) {
        super(graph, personality);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Resource getResource(String string, ResourceF resourceF) throws RDFException {
        try {
            return resourceF.createResource(this.getResource(string));
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public Model add(Resource resource, Property property, boolean bl) throws RDFException {
        return this.add(resource, property, String.valueOf(bl));
    }

    public Model add(Resource resource, Property property, long l) throws RDFException {
        return this.add(resource, property, String.valueOf(l));
    }

    public Model add(Resource resource, Property property, char c) throws RDFException {
        return this.add(resource, property, String.valueOf(c));
    }

    public Model add(Resource resource, Property property, float f) throws RDFException {
        return this.add(resource, property, String.valueOf(f));
    }

    public Model add(Resource resource, Property property, double d) throws RDFException {
        return this.add(resource, property, String.valueOf(d));
    }

    public Model add(Resource resource, Property property, String string) throws RDFException {
        return this.add(resource, property, string, "", false);
    }

    public Model add(Resource resource, Property property, String string, boolean bl) throws RDFException {
        return this.add(resource, property, string, "", bl);
    }

    public Model add(Resource resource, Property property, String string, String string2, boolean bl) throws RDFException {
        this.add(resource, property, this.literal(string, string2, bl));
        return this;
    }

    private Literal literal(String string, String string2, boolean bl) {
        return new LiteralImpl(Node.createLiteral(string, string2, bl), this);
    }

    public Model add(Resource resource, Property property, String string, String string2) throws RDFException {
        return this.add(resource, property, string, string2, false);
    }

    private RDFNode ensureRDFNode(Object object) {
        return object instanceof RDFNode ? (RDFNode)object : this.literal(object.toString(), null, false);
    }

    public Model add(Resource resource, Property property, Object object) throws RDFException {
        return this.add(resource, property, this.ensureRDFNode(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model add(StmtIterator stmtIterator) throws RDFException {
        ModelCom modelCom;
        try {
            while (stmtIterator.hasNext()) {
                this.add(stmtIterator.nextStatement());
            }
            modelCom = this;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return modelCom;
    }

    public Model add(Model model) throws RDFException {
        return this.add(model.listStatements());
    }

    public RDFReader getReader() throws RDFException {
        return this.readerFactory.getReader();
    }

    public RDFReader getReader(String string) throws RDFException {
        return this.readerFactory.getReader(string);
    }

    public String setReaderClassName(String string, String string2) {
        return this.readerFactory.setReaderClassName(string, string2);
    }

    public Model read(String string) throws RDFException {
        this.readerFactory.getReader().read(this, string);
        return this;
    }

    public Model read(Reader reader, String string) throws RDFException {
        this.readerFactory.getReader().read((Model)this, reader, string);
        return this;
    }

    public Model read(InputStream inputStream, String string) throws RDFException {
        this.readerFactory.getReader().read((Model)this, inputStream, string);
        return this;
    }

    public Model read(String string, String string2) throws RDFException {
        this.readerFactory.getReader(string2).read(this, string);
        return this;
    }

    public Model read(Reader reader, String string, String string2) throws RDFException {
        this.readerFactory.getReader(string2).read((Model)this, reader, string);
        return this;
    }

    public Model read(InputStream inputStream, String string, String string2) throws RDFException {
        this.readerFactory.getReader(string2).read((Model)this, inputStream, string);
        return this;
    }

    public RDFWriter getWriter() throws RDFException {
        return this.writerFactory.getWriter();
    }

    public RDFWriter getWriter(String string) throws RDFException {
        return this.writerFactory.getWriter(string);
    }

    public String setWriterClassName(String string, String string2) {
        return this.writerFactory.setWriterClassName(string, string2);
    }

    public Model write(Writer writer) {
        this.writerFactory.getWriter().write((Model)this, writer, "");
        return this;
    }

    public Model write(Writer writer, String string) {
        this.writerFactory.getWriter(string).write((Model)this, writer, "");
        return this;
    }

    public Model write(Writer writer, String string, String string2) {
        this.writerFactory.getWriter(string).write((Model)this, writer, string2);
        return this;
    }

    public Model write(OutputStream outputStream) {
        this.writerFactory.getWriter().write((Model)this, outputStream, "");
        return this;
    }

    public Model write(OutputStream outputStream, String string) {
        this.writerFactory.getWriter(string).write((Model)this, outputStream, "");
        return this;
    }

    public Model write(OutputStream outputStream, String string, String string2) {
        this.writerFactory.getWriter(string).write((Model)this, outputStream, string2);
        return this;
    }

    public static Model withHiddenStatements(Model model) {
        return ModelReifier.withHiddenStatements(model);
    }

    public Model remove(Statement statement) throws RDFException {
        this.graph.delete(statement.asTriple());
        return this;
    }

    public Model remove(StmtIterator stmtIterator) throws RDFException {
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            this.remove(statement);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model remove(Model model) throws RDFException {
        StmtIterator stmtIterator = model.listStatements();
        if (model.getGraph().mightContain(this.getGraph())) {
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            while (stmtIterator.hasNext()) {
                arrayList.add(stmtIterator.nextStatement());
            }
            int n = 0;
            while (n < arrayList.size()) {
                this.remove((Statement)arrayList.get(n));
                ++n;
            }
        } else {
            try {
                this.remove(stmtIterator);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                stmtIterator.close();
                throw throwable;
            }
            stmtIterator.close();
            {
            }
        }
        return this;
    }

    public boolean contains(Resource resource, Property property, boolean bl) throws RDFException {
        return this.contains(resource, property, String.valueOf(bl));
    }

    public boolean contains(Resource resource, Property property, long l) throws RDFException {
        return this.contains(resource, property, String.valueOf(l));
    }

    public boolean contains(Resource resource, Property property, char c) throws RDFException {
        return this.contains(resource, property, String.valueOf(c));
    }

    public boolean contains(Resource resource, Property property, float f) throws RDFException {
        return this.contains(resource, property, String.valueOf(f));
    }

    public boolean contains(Resource resource, Property property, double d) throws RDFException {
        return this.contains(resource, property, String.valueOf(d));
    }

    public boolean contains(Resource resource, Property property, String string) throws RDFException {
        return this.contains(resource, property, string, "");
    }

    public boolean contains(Resource resource, Property property, String string, String string2) throws RDFException {
        return this.contains(resource, property, this.literal(string, string2, false));
    }

    public boolean contains(Resource resource, Property property, Object object) throws RDFException {
        return this.contains(resource, property, this.ensureRDFNode(object));
    }

    public boolean containsAny(StmtIterator stmtIterator) throws RDFException {
        while (stmtIterator.hasNext()) {
            if (!this.contains(stmtIterator.nextStatement())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(StmtIterator stmtIterator) throws RDFException {
        while (stmtIterator.hasNext()) {
            if (this.contains(stmtIterator.nextStatement())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAny(Model model) throws RDFException {
        boolean bl;
        StmtIterator stmtIterator = model.listStatements();
        try {
            bl = this.containsAny(stmtIterator);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Model model) throws RDFException {
        boolean bl;
        StmtIterator stmtIterator = model.listStatements();
        try {
            bl = this.containsAll(stmtIterator);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return bl;
    }

    public StmtIterator listStatements(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, rDFNode));
    }

    public StmtIterator listStatements(Resource resource, Property property, boolean bl) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, bl));
    }

    public StmtIterator listStatements(Resource resource, Property property, long l) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, l));
    }

    public StmtIterator listStatements(Resource resource, Property property, char c) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, c));
    }

    public StmtIterator listStatements(Resource resource, Property property, float f) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, f));
    }

    public StmtIterator listStatements(Resource resource, Property property, double d) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, d));
    }

    public StmtIterator listStatements(Resource resource, Property property, String string) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, string));
    }

    public StmtIterator listStatements(Resource resource, Property property, String string, String string2) throws RDFException {
        return this.listStatements(new SimpleSelector(resource, property, string, string2));
    }

    public ResIterator listSubjectsWithProperty(Property property, boolean bl) throws RDFException {
        return this.listSubjectsWithProperty(property, String.valueOf(bl));
    }

    public ResIterator listSubjectsWithProperty(Property property, long l) throws RDFException {
        return this.listSubjectsWithProperty(property, String.valueOf(l));
    }

    public ResIterator listSubjectsWithProperty(Property property, char c) throws RDFException {
        return this.listSubjectsWithProperty(property, String.valueOf(c));
    }

    public ResIterator listSubjectsWithProperty(Property property, float f) throws RDFException {
        return this.listSubjectsWithProperty(property, String.valueOf(f));
    }

    public ResIterator listSubjectsWithProperty(Property property, double d) throws RDFException {
        return this.listSubjectsWithProperty(property, String.valueOf(d));
    }

    public ResIterator listSubjectsWithProperty(Property property, String string) throws RDFException {
        return this.listSubjectsWithProperty(property, string, "");
    }

    public ResIterator listSubjectsWithProperty(Property property, String string, String string2) throws RDFException {
        return this.listSubjectsWithProperty(property, this.literal(string, string2, false));
    }

    public ResIterator listSubjectsWithProperty(Property property, Object object) throws RDFException {
        return this.listSubjectsWithProperty(property, this.ensureRDFNode(object));
    }

    public Resource createResource(Resource resource) throws RDFException {
        return this.createResource().addProperty(RDF.type, resource);
    }

    public Resource createResource(String string, Resource resource) throws RDFException {
        return this.getResource(string).addProperty(RDF.type, resource);
    }

    public Resource createResource(ResourceF resourceF) throws RDFException {
        return this.createResource(null, resourceF);
    }

    public Resource createResource(String string, ResourceF resourceF) throws RDFException {
        try {
            return resourceF.createResource(this.createResource(string));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new RDFException(10, exception);
        }
    }

    public Literal createTypedLiteral(boolean bl) throws RDFException {
        return this.createTypedLiteral(new Boolean(bl));
    }

    public Literal createTypedLiteral(int n) throws RDFException {
        return this.createTypedLiteral(new Integer(n));
    }

    public Literal createTypedLiteral(long l) throws RDFException {
        return this.createTypedLiteral(new Long(l));
    }

    public Literal createTypedLiteral(char c) throws RDFException {
        return this.createTypedLiteral(new Character(c));
    }

    public Literal createTypedLiteral(float f) throws RDFException {
        return this.createTypedLiteral(new Float(f));
    }

    public Literal createTypedLiteral(double d) throws RDFException {
        return this.createTypedLiteral(new Double(d));
    }

    public Literal createTypedLiteral(String string) throws RDFException {
        LiteralLabel literalLabel = new LiteralLabel(string);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(String string, String string2, RDFDatatype rDFDatatype) throws DatatypeFormatException {
        LiteralLabel literalLabel = new LiteralLabel(string, string2, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(Object object, String string, RDFDatatype rDFDatatype) {
        LiteralLabel literalLabel = new LiteralLabel(object, string, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(String string, String string2, String string3) throws RDFException {
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string3);
        LiteralLabel literalLabel = new LiteralLabel(string, string2, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(Object object, String string, String string2) {
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string2);
        LiteralLabel literalLabel = new LiteralLabel(object, string, rDFDatatype);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createTypedLiteral(Object object) {
        LiteralLabel literalLabel = new LiteralLabel(object);
        return new LiteralImpl(Node.createLiteral(literalLabel), this);
    }

    public Literal createLiteral(boolean bl) throws RDFException {
        return this.createLiteral(String.valueOf(bl), "");
    }

    public Literal createLiteral(int n) throws RDFException {
        return this.createLiteral(String.valueOf(n), "");
    }

    public Literal createLiteral(long l) throws RDFException {
        return this.createLiteral(String.valueOf(l), "");
    }

    public Literal createLiteral(char c) throws RDFException {
        return this.createLiteral(String.valueOf(c), "");
    }

    public Literal createLiteral(float f) throws RDFException {
        return this.createLiteral(String.valueOf(f), "");
    }

    public Literal createLiteral(double d) throws RDFException {
        return this.createLiteral(String.valueOf(d), "");
    }

    public Literal createLiteral(String string) throws RDFException {
        return this.createLiteral(string, "");
    }

    public Literal createLiteral(String string, String string2) throws RDFException {
        return this.createLiteral(string, string2, false);
    }

    public Literal createLiteral(String string, String string2, boolean bl) {
        return this.literal(string, string2, bl);
    }

    public Literal createLiteral(Object object) throws RDFException {
        return this.createLiteral(object.toString(), "");
    }

    public Statement createStatement(Resource resource, Property property, boolean bl) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(bl));
    }

    public Statement createStatement(Resource resource, Property property, long l) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(l));
    }

    public Statement createStatement(Resource resource, Property property, char c) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(c));
    }

    public Statement createStatement(Resource resource, Property property, float f) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(f));
    }

    public Statement createStatement(Resource resource, Property property, double d) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(d));
    }

    public Statement createStatement(Resource resource, Property property, String string) throws RDFException {
        return this.createStatement(resource, property, this.createLiteral(string));
    }

    public Statement createStatement(Resource resource, Property property, Object object) throws RDFException {
        return this.createStatement(resource, property, this.ensureRDFNode(object));
    }

    public Statement createStatement(Resource resource, Property property, String string, boolean bl) throws RDFException {
        return this.createStatement(resource, property, string, "", bl);
    }

    public Statement createStatement(Resource resource, Property property, String string, String string2) throws RDFException {
        return this.createStatement(resource, property, string, string2, false);
    }

    public Statement createStatement(Resource resource, Property property, String string, String string2, boolean bl) throws RDFException {
        return this.createStatement(resource, property, this.literal(string, string2, bl));
    }

    public Bag createBag() throws RDFException {
        return this.createBag(null);
    }

    public Alt createAlt() throws RDFException {
        return this.createAlt(null);
    }

    public Seq createSeq() throws RDFException {
        return this.createSeq(null);
    }

    public Resource getResource(String string) throws RDFException {
        return IteratorFactory.asResource(ModelCom.makeURI(string), this);
    }

    public Property getProperty(String string) throws RDFException {
        if (string == null) {
            throw new RDFException(2);
        }
        return IteratorFactory.asProperty(ModelCom.makeURI(string), this);
    }

    public Property getProperty(String string, String string2) throws RDFException {
        return this.getProperty(string + string2);
    }

    public Seq getSeq(String string) throws RDFException {
        return (Seq)IteratorFactory.asResource(ModelCom.makeURI(string), class$com$hp$hpl$jena$rdf$model$Seq == null ? (class$com$hp$hpl$jena$rdf$model$Seq = ModelCom.class$("com.hp.hpl.jena.rdf.model.Seq")) : class$com$hp$hpl$jena$rdf$model$Seq, this);
    }

    public Seq getSeq(Resource resource) throws RDFException {
        return (Seq)resource.as(class$com$hp$hpl$jena$rdf$model$Seq == null ? (class$com$hp$hpl$jena$rdf$model$Seq = ModelCom.class$("com.hp.hpl.jena.rdf.model.Seq")) : class$com$hp$hpl$jena$rdf$model$Seq);
    }

    public Bag getBag(String string) throws RDFException {
        return (Bag)IteratorFactory.asResource(ModelCom.makeURI(string), class$com$hp$hpl$jena$rdf$model$Bag == null ? (class$com$hp$hpl$jena$rdf$model$Bag = ModelCom.class$("com.hp.hpl.jena.rdf.model.Bag")) : class$com$hp$hpl$jena$rdf$model$Bag, this);
    }

    public Bag getBag(Resource resource) throws RDFException {
        return (Bag)resource.as(class$com$hp$hpl$jena$rdf$model$Bag == null ? (class$com$hp$hpl$jena$rdf$model$Bag = ModelCom.class$("com.hp.hpl.jena.rdf.model.Bag")) : class$com$hp$hpl$jena$rdf$model$Bag);
    }

    private static Node makeURI(String string) {
        if (string == null) {
            return Node.createAnon(new AnonId());
        }
        return Node.createURI(string);
    }

    public Alt getAlt(String string) throws RDFException {
        return (Alt)IteratorFactory.asResource(ModelCom.makeURI(string), class$com$hp$hpl$jena$rdf$model$Alt == null ? (class$com$hp$hpl$jena$rdf$model$Alt = ModelCom.class$("com.hp.hpl.jena.rdf.model.Alt")) : class$com$hp$hpl$jena$rdf$model$Alt, this);
    }

    public Alt getAlt(Resource resource) throws RDFException {
        return (Alt)resource.as(class$com$hp$hpl$jena$rdf$model$Alt == null ? (class$com$hp$hpl$jena$rdf$model$Alt = ModelCom.class$("com.hp.hpl.jena.rdf.model.Alt")) : class$com$hp$hpl$jena$rdf$model$Alt);
    }

    public long size() throws RDFException {
        return this.graph.size();
    }

    private void updateNamespace(HashSet hashSet, Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.isURI()) continue;
            String string = IteratorFactory.asResource(node, this).getNameSpace();
            if (string == null) {
                System.err.println("updateNamespace: null ns for " + node);
                continue;
            }
            hashSet.add(string);
        }
    }

    private Iterator listPredicates() {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(null, null, null);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getPredicate());
        }
        return hashSet.iterator();
    }

    private Iterator listTypes() {
        HashSet<Node> hashSet = new HashSet<Node>();
        ExtendedIterator extendedIterator = this.graph.find(null, RDF.type.asNode(), null);
        while (extendedIterator.hasNext()) {
            hashSet.add(((Triple)extendedIterator.next()).getObject());
        }
        return hashSet.iterator();
    }

    public NsIterator listNameSpaces() throws RDFException {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        this.updateNamespace(hashSet2, this.listPredicates());
        this.updateNamespace(hashSet2, this.listTypes());
        return new NsIteratorImpl(hashSet2.iterator(), hashSet2);
    }

    public StmtIterator listStatements() throws RDFException {
        return IteratorFactory.asStmtIterator(this.graph.find(null, null, null), this);
    }

    public Model add(Statement statement) throws RDFException {
        return this.add(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    public Model add(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        this.modelReifier.noteIfReified(resource, property, rDFNode);
        this.graph.add(new Triple(resource.asNode(), property.asNode(), rDFNode.asNode()));
        return this;
    }

    public RSIterator listReifiedStatements() {
        return this.modelReifier.listReifiedStatements();
    }

    public RSIterator listReifiedStatements(Statement statement) {
        return this.modelReifier.listReifiedStatements(statement);
    }

    public boolean isReified(Statement statement) {
        return this.modelReifier.isReified(statement);
    }

    public Resource getAnyReifiedStatement(Statement statement) {
        return this.modelReifier.getAnyReifiedStatement(statement);
    }

    public void removeAllReifications(Statement statement) {
        this.modelReifier.removeAllReifications(statement);
    }

    public void removeReification(ReifiedStatement reifiedStatement) {
        this.modelReifier.removeReification(reifiedStatement);
    }

    public ReifiedStatement createReifiedStatement(Statement statement) {
        return this.modelReifier.createReifiedStatement(statement);
    }

    public ReifiedStatement createReifiedStatement(String string, Statement statement) {
        return this.modelReifier.createReifiedStatement(string, statement);
    }

    public boolean contains(Statement statement) throws RDFException {
        return this.graph.contains(statement.asTriple());
    }

    public boolean contains(Resource resource, Property property) throws RDFException {
        ExtendedIterator extendedIterator = this.graph.find(resource.asNode(), property.asNode(), null);
        boolean bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    public boolean contains(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return this.graph.contains(resource.asNode(), property.asNode(), rDFNode.asNode());
    }

    public Statement getProperty(Resource resource, Property property) throws RDFException {
        block3: {
            Statement statement;
            StmtIterator stmtIterator = null;
            try {
                stmtIterator = this.listStatements(new SimpleSelector(resource, property, (RDFNode)null));
                if (!stmtIterator.hasNext()) break block3;
                statement = stmtIterator.nextStatement();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                stmtIterator.close();
                throw throwable;
            }
            stmtIterator.close();
            return statement;
        }
        throw new RDFException(6);
    }

    public Node asNode(RDFNode rDFNode) {
        return rDFNode == null ? null : rDFNode.asNode();
    }

    private NodeIterator listObjectsFor(RDFNode rDFNode, RDFNode rDFNode2) {
        ExtendedIterator extendedIterator = this.graph.queryHandler().objectsFor(this.asNode(rDFNode), this.asNode(rDFNode2));
        return IteratorFactory.asRDFNodeIterator(extendedIterator, this);
    }

    private ResIterator listSubjectsFor(RDFNode rDFNode, RDFNode rDFNode2) {
        ExtendedIterator extendedIterator = this.graph.queryHandler().subjectsFor(this.asNode(rDFNode), this.asNode(rDFNode2));
        return IteratorFactory.asResIterator(extendedIterator, this);
    }

    public ResIterator listSubjects() throws RDFException {
        return this.listSubjectsFor(null, null);
    }

    public ResIterator listSubjectsWithProperty(Property property) throws RDFException {
        return this.listSubjectsFor(property, null);
    }

    public ResIterator listSubjectsWithProperty(Property property, RDFNode rDFNode) throws RDFException {
        return this.listSubjectsFor(property, rDFNode);
    }

    public NodeIterator listObjects() throws RDFException {
        return this.listObjectsFor(null, null);
    }

    public NodeIterator listObjectsOfProperty(Property property) throws RDFException {
        return this.listObjectsFor(null, property);
    }

    public NodeIterator listObjectsOfProperty(Resource resource, Property property) throws RDFException {
        return this.listObjectsFor(resource, property);
    }

    public StmtIterator listStatements(final Selector selector) throws RDFException {
        ExtendedIterator extendedIterator;
        if (selector instanceof SimpleSelector) {
            SimpleSelector simpleSelector = (SimpleSelector)selector;
            extendedIterator = this.graph.find(simpleSelector.asTripleMatch(this));
        } else {
            extendedIterator = this.graph.find(new StandardTripleMatch(null, null, null){

                public boolean triple(Triple triple) {
                    return selector.test(IteratorFactory.asStatement(triple, ModelCom.this));
                }
            });
        }
        return IteratorFactory.asStmtIterator(extendedIterator, this);
    }

    public Model begin() throws RDFException {
        throw new RDFException(3);
    }

    public Model abort() throws RDFException {
        throw new RDFException(3);
    }

    public Model commit() throws RDFException {
        throw new RDFException(3);
    }

    public boolean independent() {
        return true;
    }

    public Resource createResource() throws RDFException {
        return IteratorFactory.asResource(Node.createAnon(new AnonId()), this);
    }

    public Resource createResource(String string) throws RDFException {
        return this.getResource(string);
    }

    public Property createProperty(String string) throws RDFException {
        return this.getProperty(string);
    }

    public Property createProperty(String string, String string2) throws RDFException {
        return this.getProperty(string, string2);
    }

    public Statement createStatement(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        return IteratorFactory.asStatement(new Triple(resource.asNode(), property.asNode(), rDFNode.asNode()), this);
    }

    public Bag createBag(String string) throws RDFException {
        return (Bag)this.getBag(string).addProperty(RDF.type, RDF.Bag);
    }

    public Alt createAlt(String string) throws RDFException {
        return (Alt)this.getAlt(string).addProperty(RDF.type, RDF.Alt);
    }

    public Seq createSeq(String string) throws RDFException {
        return (Seq)this.getSeq(string).addProperty(RDF.type, RDF.Seq);
    }

    public NodeIterator listContainerMembers(Container container, NodeIteratorFactory nodeIteratorFactory) throws RDFException {
        Iterator iterator = this.listBySubject(container);
        String string = RDF.getURI();
        Vector<Statement> vector = new Vector<Statement>();
        int n = 0;
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            int n2 = statement.getPredicate().getOrdinal();
            if (!statement.getSubject().equals(container) || n2 == 0) continue;
            if (n2 > n) {
                n = n2;
                vector.setSize(n2);
            }
            vector.setElementAt(statement, n2 - 1);
        }
        WrappedIterator.close(iterator);
        try {
            return nodeIteratorFactory.createIterator(vector.iterator(), vector, container);
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public int containerSize(Container container) throws RDFException {
        int n = 0;
        Iterator iterator = this.listBySubject(container);
        String string = RDF.getURI();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            Property property = statement.getPredicate();
            if (!statement.getSubject().equals(container) || property.getOrdinal() == 0) continue;
            ++n;
        }
        WrappedIterator.close(iterator);
        return n;
    }

    private Iterator asStatements(final Iterator iterator) {
        final ModelCom modelCom = this;
        return new Iterator(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                return IteratorFactory.asStatement((Triple)iterator.next(), modelCom);
            }

            public void remove() {
                iterator.remove();
            }
        };
    }

    private Iterator listBySubject(Container container) {
        return this.asStatements(this.graph.find(container.asNode(), null, null));
    }

    public int containerIndexOf(Container container, RDFNode rDFNode) throws RDFException {
        int n = 0;
        Iterator iterator = this.listBySubject(container);
        String string = RDF.getURI();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            Property property = statement.getPredicate();
            if (!statement.getSubject().equals(container) || property.getOrdinal() == 0 || !rDFNode.equals(statement.getObject())) continue;
            n = property.getOrdinal();
            break;
        }
        WrappedIterator.close(iterator);
        return n;
    }

    public boolean containerContains(Container container, RDFNode rDFNode) throws RDFException {
        return this.containerIndexOf(container, rDFNode) != 0;
    }

    public Resource convert(Resource resource) throws RDFException {
        return ((ResourceI)((Object)resource)).port(this);
    }

    public Property convert(Property property) throws RDFException {
        return (Property)((ResourceI)((Object)property)).port(this);
    }

    public RDFNode convert(RDFNode rDFNode) throws RDFException {
        if (rDFNode instanceof Property) {
            return this.convert((Property)rDFNode);
        }
        if (rDFNode instanceof Resource) {
            return this.convert((Resource)rDFNode);
        }
        return rDFNode;
    }

    public void close() {
        this.graph.close();
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsSetOperations() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model query(Selector selector) throws RDFException {
        ModelMem modelMem;
        block3: {
            ModelMem modelMem2 = new ModelMem();
            StmtIterator stmtIterator = null;
            try {
                stmtIterator = this.listStatements(selector);
                while (stmtIterator.hasNext()) {
                    modelMem2.add(stmtIterator.nextStatement());
                }
                modelMem = modelMem2;
                Object var6_5 = null;
                if (stmtIterator == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (stmtIterator == null) break block4;
                    stmtIterator.close();
                }
                throw throwable;
            }
            stmtIterator.close();
        }
        return modelMem;
    }

    public Model union(Model model) throws RDFException {
        return new ModelMem().add(this).add(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model intersection(Model model) throws RDFException {
        ModelMem modelMem;
        Model model2 = this;
        Model model3 = model;
        ModelMem modelMem2 = new ModelMem();
        StmtIterator stmtIterator = null;
        if (model.size() > this.size()) {
            model2 = model;
            model3 = this;
        }
        try {
            stmtIterator = model3.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (!model2.contains(statement)) continue;
                modelMem2.add(statement);
            }
            modelMem = modelMem2;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return modelMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model difference(Model model) throws RDFException {
        ModelMem modelMem;
        ModelMem modelMem2 = new ModelMem();
        StmtIterator stmtIterator = null;
        try {
            stmtIterator = this.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (model.contains(statement)) continue;
                modelMem2.add(statement);
            }
            modelMem = modelMem2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        return modelMem;
    }

    public String toString() {
        return "<ModelCom  " + this.getGraph() + ">";
    }

    public Model getHiddenStatements() {
        return this.modelReifier.getHiddenStatements();
    }

    public boolean isIsomorphicWith(Model model) {
        ModelCom modelCom = (ModelCom)ModelCom.withHiddenStatements(this);
        EnhGraph enhGraph = (EnhGraph)((Object)ModelCom.withHiddenStatements(model));
        return modelCom.isIsomorphicWith(enhGraph);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

