/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;

public class LiteralImpl
extends EnhNode
implements Literal {
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new LiteralImpl(node, enhGraph);
        }
    };

    private LiteralImpl(Resource resource) {
        this(resource.asNode(), resource.getModel());
    }

    public LiteralImpl(Node node, Model model) {
        super(node, (ModelCom)model);
    }

    public LiteralImpl(Node node, EnhGraph enhGraph) {
        this(node, (Model)((Object)enhGraph));
    }

    public LiteralImpl(boolean bl) {
        this(String.valueOf(bl));
    }

    public LiteralImpl(long l) {
        this(String.valueOf(l));
    }

    public LiteralImpl(char c) {
        this(String.valueOf(c));
    }

    public LiteralImpl(float f) {
        this(String.valueOf(f));
    }

    public LiteralImpl(double d) {
        this(String.valueOf(d));
    }

    public LiteralImpl(String string) {
        this(string, "");
    }

    public LiteralImpl(String string, String string2) {
        this(string, string2, false);
    }

    public LiteralImpl(String string, boolean bl) {
        this(string, "", bl);
    }

    public LiteralImpl(String string, String string2, boolean bl) {
        this(string, string2, bl, null);
    }

    public LiteralImpl(String string, String string2, boolean bl, Model model) {
        this(Node.createLiteral(string, string2, bl), model);
    }

    public LiteralImpl(Object object) {
        this(object.toString());
    }

    public boolean isLiteral() {
        return true;
    }

    public String toString() {
        return this.asNode().toString();
    }

    public Object getValue() {
        return this.asNode().getLiteral().getValue();
    }

    public RDFDatatype getDatatype() {
        return this.asNode().getLiteral().getDatatype();
    }

    public String getDatatypeURI() {
        return this.asNode().getLiteral().getDatatypeURI();
    }

    public boolean isPlainLiteral() {
        return this.asNode().getLiteral().getDatatype() == null;
    }

    public String getLexicalForm() {
        return this.asNode().getLiteral().toString();
    }

    public boolean getBoolean() throws RDFException {
        Object object = this.asNode().getLiteral().getValue();
        if (this.isPlainLiteral()) {
            if (object.equals("true")) {
                return true;
            }
            if (object.equals("false")) {
                return false;
            }
            throw new RDFException(11);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new DatatypeFormatException(this.toString() + " is not a Boolean");
    }

    public byte getByte() throws RDFException {
        if (this.isPlainLiteral()) {
            return Byte.parseByte(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).byteValue();
    }

    public short getShort() throws RDFException {
        if (this.isPlainLiteral()) {
            return Short.parseShort(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).shortValue();
    }

    public int getInt() throws RDFException {
        if (this.isPlainLiteral()) {
            return Integer.parseInt(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).intValue();
    }

    public long getLong() throws RDFException {
        if (this.isPlainLiteral()) {
            return Long.parseLong(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).longValue();
    }

    public char getChar() throws RDFException {
        if (this.isPlainLiteral()) {
            if (this.getString().length() == 1) {
                return this.getString().charAt(0);
            }
            throw new RDFException(12);
        }
        Object object = this.getValue();
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        throw new DatatypeFormatException(object.toString() + " is not a Character");
    }

    public float getFloat() throws RDFException {
        if (this.isPlainLiteral()) {
            return Float.parseFloat(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).floatValue();
    }

    public double getDouble() throws RDFException {
        if (this.isPlainLiteral()) {
            return Double.parseDouble(this.getLexicalForm());
        }
        return this.asNumber(this.getValue()).doubleValue();
    }

    public String getString() throws RDFException {
        return this.asNode().getLiteral().toString();
    }

    public Object getObject(ObjectF objectF) throws RDFException {
        if (this.isPlainLiteral()) {
            try {
                return objectF.createObject(this.getString());
            }
            catch (Exception exception) {
                throw new RDFException(exception);
            }
        }
        return this.getValue();
    }

    public String getLanguage() {
        return this.asNode().getLiteral().language();
    }

    public boolean getWellFormed() {
        return this.asNode().getLiteral().isXML();
    }

    public boolean sameValueAs(Literal literal) {
        return this.asNode().sameValueAs(literal.asNode());
    }

    private Number asNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new DatatypeFormatException(object.toString() + " is not a Number");
    }
}

