/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ContNodeIteratorFactoryImpl;
import com.hp.hpl.jena.rdf.model.impl.ContainerI;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelI;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorFactory;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.vocabulary.RDF;

public class ContainerImpl
extends ResourceImpl
implements Container,
ContainerI {
    static NodeIteratorFactory iteratorFactory = new ContNodeIteratorFactoryImpl();

    public ContainerImpl(Model model) {
        super(model);
    }

    public ContainerImpl(String string, Model model) {
        super(string, model);
    }

    public ContainerImpl(Resource resource, Model model) {
        super(resource.asNode(), model);
    }

    public ContainerImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    protected ContainerImpl(Resource resource) {
        this(resource, resource.getModel());
    }

    private boolean is(Resource resource) {
        return this.hasProperty(RDF.type, resource);
    }

    public boolean isAlt() {
        return this.is(RDF.Alt);
    }

    public boolean isBag() {
        return this.is(RDF.Bag);
    }

    public boolean isSeq() {
        return this.is(RDF.Seq);
    }

    public Container add(RDFNode rDFNode) throws RDFException {
        int n = this.size();
        this.addProperty(RDF.li(n + 1), rDFNode);
        return this;
    }

    public Container add(boolean bl) throws RDFException {
        return this.add(String.valueOf(bl));
    }

    public Container add(long l) throws RDFException {
        return this.add(String.valueOf(l));
    }

    public Container add(char c) throws RDFException {
        return this.add(String.valueOf(c));
    }

    public Container add(float f) throws RDFException {
        return this.add(String.valueOf(f));
    }

    public Container add(double d) throws RDFException {
        return this.add(String.valueOf(d));
    }

    public Container add(Object object) throws RDFException {
        return this.add(String.valueOf(object));
    }

    public Container add(String string) throws RDFException {
        return this.add(string, "");
    }

    public Container add(String string, String string2) throws RDFException {
        return this.add(this.literal(string, string2));
    }

    public boolean contains(RDFNode rDFNode) throws RDFException {
        return ((ModelI)((Object)this.getModel())).containerContains(this, rDFNode);
    }

    public boolean contains(boolean bl) throws RDFException {
        return this.contains(String.valueOf(bl));
    }

    public boolean contains(long l) throws RDFException {
        return this.contains(String.valueOf(l));
    }

    public boolean contains(char c) throws RDFException {
        return this.contains(String.valueOf(c));
    }

    public boolean contains(float f) throws RDFException {
        return this.contains(String.valueOf(f));
    }

    public boolean contains(double d) throws RDFException {
        return this.contains(String.valueOf(d));
    }

    public boolean contains(Object object) throws RDFException {
        return this.contains(String.valueOf(object));
    }

    public boolean contains(String string) throws RDFException {
        return this.contains(string, "");
    }

    public boolean contains(String string, String string2) throws RDFException {
        return this.contains(this.literal(string, string2));
    }

    private Literal literal(String string, String string2) {
        return new LiteralImpl(Node.createLiteral(string, string2, false), this.getModel());
    }

    public NodeIterator iterator() throws RDFException {
        return ((ModelI)((Object)this.getModel())).listContainerMembers(this, iteratorFactory);
    }

    public int size() throws RDFException {
        return ((ModelI)((Object)this.getModel())).containerSize(this);
    }

    public Container remove(Statement statement) throws RDFException {
        int n = this.size();
        Statement statement2 = null;
        if (statement.getPredicate().getOrdinal() == n) {
            this.getModel().remove(statement);
        } else {
            statement2 = this.getModel().getProperty(this, RDF.li(n));
            statement.set(statement2.getObject());
            this.getModel().remove(statement2);
        }
        if (this.size() != n - 1) {
            throw new RDFException(17);
        }
        return this;
    }

    public Container remove(int n, RDFNode rDFNode) throws RDFException {
        this.remove(this.getModel().createStatement((Resource)this, RDF.li(n), rDFNode));
        return this;
    }
}

