/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ObjectF;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceF;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ContainerImpl;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.vocabulary.RDF;

public class AltImpl
extends ContainerImpl
implements Alt {
    public static final Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            return new AltImpl(node, enhGraph);
        }
    };

    private AltImpl(Resource resource) {
        super(resource);
    }

    public AltImpl(Model model) throws RDFException {
        super(model);
    }

    public AltImpl(String string, Model model) throws RDFException {
        super(string, model);
    }

    public AltImpl(Resource resource, Model model) throws RDFException {
        super(resource, model);
    }

    public AltImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    private Statement needDefaultStatement() throws RDFException {
        Statement statement = this.getDefaultStatement();
        if (statement == null) {
            throw new RDFException(13);
        }
        return statement;
    }

    public RDFNode getDefault() throws RDFException {
        return this.needDefaultStatement().getObject();
    }

    public Resource getDefaultResource() throws RDFException {
        return this.needDefaultStatement().getResource();
    }

    public Literal getDefaultLiteral() throws RDFException {
        return this.needDefaultStatement().getLiteral();
    }

    public boolean getDefaultBoolean() throws RDFException {
        return this.needDefaultStatement().getBoolean();
    }

    public byte getDefaultByte() throws RDFException {
        return this.needDefaultStatement().getByte();
    }

    public short getDefaultShort() throws RDFException {
        return this.needDefaultStatement().getShort();
    }

    public int getDefaultInt() throws RDFException {
        return this.needDefaultStatement().getInt();
    }

    public long getDefaultLong() throws RDFException {
        return this.needDefaultStatement().getLong();
    }

    public char getDefaultChar() throws RDFException {
        return this.needDefaultStatement().getChar();
    }

    public float getDefaultFloat() throws RDFException {
        return this.needDefaultStatement().getFloat();
    }

    public double getDefaultDouble() throws RDFException {
        return this.needDefaultStatement().getDouble();
    }

    public String getDefaultString() throws RDFException {
        return this.needDefaultStatement().getString();
    }

    public String getDefaultLanguage() throws RDFException {
        return this.needDefaultStatement().getLanguage();
    }

    public Resource getDefaultResource(ResourceF resourceF) throws RDFException {
        return this.needDefaultStatement().getResource();
    }

    public Object getDefaultObject(ObjectF objectF) throws RDFException {
        return this.needDefaultStatement().getObject(objectF);
    }

    public Alt getDefaultAlt() throws RDFException {
        return this.needDefaultStatement().getAlt();
    }

    public Bag getDefaultBag() throws RDFException {
        return this.needDefaultStatement().getBag();
    }

    public Seq getDefaultSeq() throws RDFException {
        return this.needDefaultStatement().getSeq();
    }

    public Alt setDefault(RDFNode rDFNode) throws RDFException {
        Statement statement = this.getDefaultStatement();
        if (statement != null) {
            this.getModel().remove(statement);
        }
        this.getModel().add((Resource)this, RDF.li(1), rDFNode);
        return this;
    }

    public Alt setDefault(boolean bl) throws RDFException {
        return this.setDefault(String.valueOf(bl));
    }

    public Alt setDefault(long l) throws RDFException {
        return this.setDefault(String.valueOf(l));
    }

    public Alt setDefault(char c) throws RDFException {
        return this.setDefault(String.valueOf(c));
    }

    public Alt setDefault(float f) throws RDFException {
        return this.setDefault(String.valueOf(f));
    }

    public Alt setDefault(double d) throws RDFException {
        return this.setDefault(String.valueOf(d));
    }

    public Alt setDefault(Object object) throws RDFException {
        return this.setDefault(String.valueOf(object));
    }

    public Alt setDefault(String string) throws RDFException {
        return this.setDefault(string, "");
    }

    public Alt setDefault(String string, String string2) throws RDFException {
        return this.setDefault(new LiteralImpl(Node.createLiteral(string, string2, false), this.getModel()));
    }

    protected Statement getDefaultStatement() throws RDFException {
        StmtIterator stmtIterator = this.getModel().listStatements(new SimpleSelector((Resource)this, RDF.li(1), (RDFNode)null));
        if (!stmtIterator.hasNext()) {
            return null;
        }
        return stmtIterator.nextStatement();
    }
}

