/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphBase;
import com.hp.hpl.jena.graph.GraphFactory;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.impl.OntModelImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;

public class ModelFactory {
    public static Model createDefaultModel() {
        return new ModelCom(GraphBase.withReification(new GraphMem()), BuiltinPersonalities.model);
    }

    public static Model createNonreifyingModel() {
        return new ModelCom(new GraphMem(), BuiltinPersonalities.model);
    }

    public static Model createModelForGraph(Graph graph) {
        return new ModelCom(graph);
    }

    public static Model createRDFSModel(Model model) {
        ReasonerFactory reasonerFactory = RDFSReasonerFactory.theInstance();
        Reasoner reasoner = reasonerFactory.create(null);
        InfGraph infGraph = reasoner.bind(model.getGraph());
        return ModelFactory.createModelForGraph(infGraph);
    }

    public static Model createRDFSModel(Model model, Model model2) {
        ReasonerFactory reasonerFactory = RDFSReasonerFactory.theInstance();
        Reasoner reasoner = reasonerFactory.create(null);
        InfGraph infGraph = reasoner.bindSchema(model.getGraph()).bind(model2.getGraph());
        return ModelFactory.createModelForGraph(infGraph);
    }

    public static OntModel createOntologyModel(String string) {
        return ModelFactory.createOntologyModel(string, null, null, null);
    }

    public static OntModel createOntologyModel(String string, Model model) {
        return ModelFactory.createOntologyModel(string, model, null, null);
    }

    public static OntModel createOntologyModel(String string, Model model, OntDocumentManager ontDocumentManager) {
        return ModelFactory.createOntologyModel(string, model, ontDocumentManager, null);
    }

    public static OntModel createOntologyModel(String string, Model model, OntDocumentManager ontDocumentManager, GraphFactory graphFactory) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create an ontology model with a null languageURI");
        }
        OntDocumentManager ontDocumentManager2 = ontDocumentManager == null ? OntDocumentManager.getInstance() : ontDocumentManager;
        GraphFactory graphFactory2 = graphFactory == null ? ontDocumentManager2.getDefaultGraphFactory() : graphFactory;
        Model model2 = model == null ? ModelFactory.createModelForGraph(graphFactory2.getGraph()) : model;
        return new OntModelImpl(string, model2, ontDocumentManager2, graphFactory2);
    }
}

