/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelCon;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.NsIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFReaderF;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public interface Model
extends ModelCon,
RDFReaderF,
RDFWriterF {
    public boolean isModel();

    public Graph getGraph();

    public QueryHandler queryHandler();

    public long size() throws RDFException;

    public ResIterator listSubjects() throws RDFException;

    public NsIterator listNameSpaces() throws RDFException;

    public StmtIterator listStatements() throws RDFException;

    public Resource getResource(String var1) throws RDFException;

    public Property getProperty(String var1, String var2) throws RDFException;

    public Resource createResource() throws RDFException;

    public Resource createResource(String var1) throws RDFException;

    public Property createProperty(String var1, String var2) throws RDFException;

    public Literal createLiteral(String var1, String var2) throws RDFException;

    public Literal createLiteral(String var1, String var2, boolean var3) throws RDFException;

    public Literal createTypedLiteral(String var1, String var2, RDFDatatype var3) throws RDFException;

    public Literal createTypedLiteral(Object var1, String var2, RDFDatatype var3);

    public Literal createTypedLiteral(Object var1);

    public Statement createStatement(Resource var1, Property var2, RDFNode var3) throws RDFException;

    public Model add(Statement var1) throws RDFException;

    public Model add(StmtIterator var1) throws RDFException;

    public Model add(Model var1) throws RDFException;

    public Model read(String var1) throws RDFException;

    public Model read(InputStream var1, String var2) throws RDFException;

    public Model read(InputStream var1, String var2, String var3) throws RDFException;

    public Model read(Reader var1, String var2) throws RDFException;

    public Model read(String var1, String var2) throws RDFException;

    public Model read(Reader var1, String var2, String var3) throws RDFException;

    public Model write(Writer var1) throws RDFException;

    public Model write(Writer var1, String var2) throws RDFException;

    public Model write(Writer var1, String var2, String var3) throws RDFException;

    public Model write(OutputStream var1) throws RDFException;

    public Model write(OutputStream var1, String var2) throws RDFException;

    public Model write(OutputStream var1, String var2, String var3) throws RDFException;

    public Model remove(Statement var1) throws RDFException;

    public Statement getProperty(Resource var1, Property var2) throws RDFException;

    public ResIterator listSubjectsWithProperty(Property var1) throws RDFException;

    public ResIterator listSubjectsWithProperty(Property var1, RDFNode var2) throws RDFException;

    public NodeIterator listObjects() throws RDFException;

    public NodeIterator listObjectsOfProperty(Property var1) throws RDFException;

    public NodeIterator listObjectsOfProperty(Resource var1, Property var2) throws RDFException;

    public boolean contains(Resource var1, Property var2) throws RDFException;

    public boolean contains(Resource var1, Property var2, RDFNode var3) throws RDFException;

    public boolean contains(Statement var1) throws RDFException;

    public boolean containsAny(StmtIterator var1) throws RDFException;

    public boolean containsAll(StmtIterator var1) throws RDFException;

    public boolean containsAny(Model var1) throws RDFException;

    public boolean containsAll(Model var1) throws RDFException;

    public boolean isReified(Statement var1);

    public Resource getAnyReifiedStatement(Statement var1);

    public void removeAllReifications(Statement var1);

    public void removeReification(ReifiedStatement var1);

    public StmtIterator listStatements(Selector var1) throws RDFException;

    public ReifiedStatement createReifiedStatement(Statement var1);

    public ReifiedStatement createReifiedStatement(String var1, Statement var2);

    public RSIterator listReifiedStatements();

    public RSIterator listReifiedStatements(Statement var1);

    public Model query(Selector var1) throws RDFException;

    public Model union(Model var1) throws RDFException;

    public Model intersection(Model var1) throws RDFException;

    public Model difference(Model var1) throws RDFException;

    public boolean equals(Object var1);

    public Model begin() throws RDFException;

    public Model abort() throws RDFException;

    public Model commit() throws RDFException;

    public boolean independent();

    public boolean supportsTransactions();

    public boolean supportsSetOperations();

    public boolean isIsomorphicWith(Model var1);

    public void close();
}

