/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MoreTests
extends TestCase
implements RDFErrorHandler,
ARPErrorNumbers {
    private int[] expected;

    public static Test suite() {
        TestSuite testSuite = new TestSuite("ARP Plus");
        testSuite.addTest((Test)new MoreTests("testEncodingMismatch1"));
        testSuite.addTest((Test)new MoreTests("testEncodingMismatch2"));
        return testSuite;
    }

    MoreTests(String string) {
        super(string);
    }

    public void testEncodingMismatch1() throws IOException {
        ModelMem modelMem = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileReader fileReader = new FileReader("testing/wg/rdfms-syntax-incomplete/test001.rdf");
        if (fileReader.getEncoding().startsWith("UTF")) {
            System.err.println("WARNING: Encoding mismatch tests not executed on platform with default UTF encoding.");
            return;
        }
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{129};
        rDFReader.read((Model)modelMem, fileReader, "http://example.org/");
        this.checkExpected();
    }

    public void testEncodingMismatch2() throws IOException {
        ModelMem modelMem = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileReader fileReader = new FileReader("testing/wg/rdf-charmod-literals/test001.rdf");
        if (fileReader.getEncoding().startsWith("UTF")) {
            return;
        }
        rDFReader.setErrorHandler(this);
        this.expected = new int[]{129, 210};
        rDFReader.read((Model)modelMem, fileReader, "http://example.org/");
        this.checkExpected();
    }

    private void checkExpected() {
        int n = 0;
        while (n < this.expected.length) {
            if (this.expected[n] != 0) {
                Assert.fail((String)("Expected error: " + JenaReader.errorCodeName(this.expected[n]) + " but it did not occur."));
            }
            ++n;
        }
    }

    public void warning(Exception exception) {
        this.error(0, exception);
    }

    public void error(Exception exception) {
        this.error(1, exception);
    }

    public void fatalError(Exception exception) {
        this.error(2, exception);
    }

    private void error(int n, Exception exception) {
        if (exception instanceof ParseException) {
            int n2 = ((ParseException)exception).getErrorNumber();
            this.onError(n, n2);
        } else {
            Assert.fail((String)("Not expecting an Exception: " + exception.getMessage()));
        }
    }

    private void println(String string) {
        System.err.println(string);
    }

    void onError(int n, int n2) {
        int n4 = 0;
        while (n4 < this.expected.length) {
            if (this.expected[n4] == n2) {
                this.expected[n4] = 0;
                return;
            }
            ++n4;
        }
        String string = "Parser reports unexpected " + WGTestSuite.errorLevelName[n] + ": " + JenaReader.errorCodeName(n2);
        this.println(string);
        Assert.fail((String)string);
    }
}

