/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.CharacterModel;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class URI
implements Serializable {
    static Logger logger = Logger.getLogger((Class)(class$com$hp$hpl$jena$rdf$arp$URI == null ? (class$com$hp$hpl$jena$rdf$arp$URI = URI.class$("com.hp.hpl.jena.rdf.arp.URI")) : class$com$hp$hpl$jena$rdf$arp$URI));
    private static final String RESERVED_CHARACTERS = ";/?:@&=+$,[]";
    private static final String MARK_CHARACTERS = "-_.!~*'() ";
    private static final String SCHEME_CHARACTERS = "+-.";
    private static final String USERINFO_CHARACTERS = ";:&=+$,";
    private String m_scheme = null;
    private String m_userinfo = null;
    private String m_host = null;
    private String m_port = null;
    private int n_port = -1;
    private String m_path = null;
    private String[] m_subPaths = null;
    private String m_queryString = null;
    private String m_fragment = null;
    private static boolean DEBUG = false;
    private boolean haveCheckedNFC = false;
    private boolean isNFC;
    public static final int SAMEDOCUMENT = 1;
    public static final int NETWORK = 2;
    public static final int ABSOLUTE = 4;
    public static final int RELATIVE = 8;
    public static final int PARENT = 16;
    public static final int GRANDPARENT = 32;
    private static int[][] prefs = new int[][]{{8, 56}, {16, 48}, {32, 32}};
    static String[] exact = new String[]{".", "..", "../.."};
    static String[] sub = new String[]{"", "../", "../../"};
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$URI;

    public URI() {
    }

    public URI(URI uRI) {
        this.initialize(uRI);
    }

    public URI(String string) throws MalformedURIException {
        this((URI)null, string);
    }

    public URI(URI uRI, String string) throws MalformedURIException {
        this.initialize(uRI, string);
    }

    public URI(String string, String string2) throws MalformedURIException {
        if (string == null || string.length() == 0) {
            throw new MalformedURIException("Cannot construct URI with null/empty scheme!");
        }
        if (string2 == null || string2.length() == 0) {
            throw new MalformedURIException("Cannot construct URI with null/empty scheme-specific part!");
        }
        this.setScheme(string);
        this.setPath(string2);
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws MalformedURIException {
        this(string, null, string2, -1, string3, string4, string5);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws MalformedURIException {
        if (string == null || string.length() == 0) {
            throw new MalformedURIException("Scheme is required!");
        }
        if (string3 == null) {
            if (string2 != null) {
                throw new MalformedURIException("Userinfo may not be specified if host is not specified!");
            }
            if (n != -1) {
                throw new MalformedURIException("Port may not be specified if host is not specified!");
            }
        }
        if (string4 != null) {
            if (string4.indexOf(63) != -1 && string5 != null) {
                throw new MalformedURIException("Query string cannot be specified in path and query string!");
            }
            if (string4.indexOf(35) != -1 && string6 != null) {
                throw new MalformedURIException("Fragment cannot be specified in both the path and fragment!");
            }
        }
        this.setScheme(string);
        this.setHost(string3);
        this.setPort(n);
        this.m_port = "" + n;
        this.setUserinfo(string2);
        this.setPath(string4);
        this.setQueryString(string5);
        this.setFragment(string6);
    }

    private void initialize(URI uRI) {
        this.m_scheme = uRI.getScheme();
        this.m_userinfo = uRI.getUserinfo();
        this.m_host = uRI.getHost();
        this.m_port = uRI.m_port;
        this.n_port = uRI.n_port;
        this.m_path = uRI.getPath();
        this.m_queryString = uRI.getQueryString();
        this.m_fragment = uRI.getFragment();
    }

    private void initialize(URI uRI, String string) throws MalformedURIException {
        if (uRI == null && (string == null || string.length() == 0)) {
            throw new MalformedURIException("Cannot initialize URI with empty parameters.");
        }
        if (string == null || string.length() == 0) {
            this.initialize(uRI);
            return;
        }
        String string2 = string;
        int n = string2.length();
        int n2 = 0;
        int n4 = string2.indexOf(58);
        int n5 = string2.indexOf(47);
        int n6 = string2.indexOf(63);
        int n7 = string2.indexOf(35);
        if (n4 < 2 || n4 > n5 && n5 != -1 || n4 > n6 && n6 != -1 || n4 > n7 && n7 != -1) {
            if (uRI == null) {
                throw new MalformedURIException("No scheme found in URI.");
            }
            if (!uRI.isGenericURI() && n7 != 0) {
                throw new MalformedURIException("Cannot apply relative URI to an opaque URI");
            }
        } else {
            this.initializeScheme(string2);
            n2 = this.m_scheme.length() + 1;
        }
        if (n2 + 1 < n && string2.substring(n2).startsWith("//")) {
            int n8 = n2 += 2;
            char c = '\u0000';
            while (n2 < n) {
                c = string2.charAt(n2);
                if (c == '/' || c == '?' || c == '#') break;
                ++n2;
            }
            if (n2 > n8) {
                this.initializeAuthority(string2.substring(n8, n2));
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(string2.substring(n2));
        if (uRI != null) {
            int n9;
            if (this.m_path.length() == 0 && this.m_scheme == null && this.m_host == null) {
                this.m_scheme = uRI.getScheme();
                this.m_userinfo = uRI.getUserinfo();
                this.m_host = uRI.getHost();
                this.m_port = uRI.m_port;
                this.n_port = uRI.getPort();
                this.m_path = uRI.getPath();
                if (this.m_queryString == null) {
                    this.m_queryString = uRI.getQueryString();
                }
                return;
            }
            if (this.m_scheme != null) {
                return;
            }
            this.m_scheme = uRI.getScheme();
            if (this.m_host != null) {
                return;
            }
            this.m_userinfo = uRI.getUserinfo();
            this.m_host = uRI.getHost();
            this.m_port = uRI.m_port;
            this.n_port = uRI.getPort();
            if (this.m_path.length() > 0 && this.m_path.startsWith("/")) {
                return;
            }
            String string3 = "/";
            String string4 = uRI.getPath();
            if (string4 != null && (n9 = string4.lastIndexOf(47)) != -1) {
                string3 = string4.substring(0, n9 + 1);
            }
            string3 = string3.concat(this.m_path);
            n2 = -1;
            while ((n2 = string3.indexOf("/./")) != -1) {
                string3 = string3.substring(0, n2 + 1).concat(string3.substring(n2 + 3));
            }
            if (string3.endsWith("/.")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            n2 = 1;
            n9 = -1;
            while ((n2 = string3.indexOf("/../", n2)) > 0) {
                n9 = string3.lastIndexOf(47, n2 - 1);
                if (n9 != -1 && !string3.substring(n9 + 1, n2).equals("..")) {
                    string3 = string3.substring(0, n9).concat(string3.substring(n2 + 3));
                    n2 = n9;
                    continue;
                }
                n2 += 4;
            }
            if (string3.endsWith("/..") && (n9 = string3.lastIndexOf(47, (n2 = string3.length() - 3) - 1)) != -1 && !string3.substring(n9 + 1, n2).equals("..")) {
                string3 = string3.substring(0, n9 + 1);
            }
            this.m_path = string3;
        }
    }

    private void initializeScheme(String string) throws MalformedURIException {
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 < 1) {
            throw new MalformedURIException("No scheme found in URI.");
        }
        if (n2 == n - 1) {
            throw new MalformedURIException("A bare scheme name is not a URI.");
        }
        this.setScheme(string.substring(0, n2));
    }

    private void initializeAuthority(String string) throws MalformedURIException {
        int n = 0;
        int n2 = 0;
        int n4 = string.length();
        char c = '\u0000';
        String string2 = null;
        if (string.indexOf(64, n2) != -1) {
            while (n < n4) {
                c = string.charAt(n);
                if (c == '@') break;
                ++n;
            }
            string2 = string.substring(n2, n);
            ++n;
        }
        String string3 = null;
        n2 = n;
        while (n < n4) {
            c = string.charAt(n);
            if (c == ':') break;
            ++n;
        }
        string3 = string.substring(n2, n);
        int n5 = -1;
        if (string3.length() > 0 && c == ':') {
            n2 = ++n;
            while (n < n4) {
                ++n;
            }
            String string4 = string.substring(n2, n);
            if (string4.length() > 0) {
                int n6 = 0;
                while (n6 < string4.length()) {
                    if (!URI.isDigit(string4.charAt(n6))) {
                        throw new MalformedURIException(string4 + " is invalid. Port should only contain digits!");
                    }
                    ++n6;
                }
                try {
                    n5 = Integer.parseInt(string4);
                    this.m_port = string4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.setHost(string3);
        this.setPort(n5);
        this.setUserinfo(string2);
    }

    private void initializePath(String string) throws MalformedURIException {
        if (string == null) {
            throw new MalformedURIException("Cannot initialize path from null string!");
        }
        int n = 0;
        int n2 = 0;
        int n4 = string.length();
        char c = '\u0000';
        while (n < n4) {
            c = string.charAt(n);
            if (c == '?' || c == '#') break;
            if (c == '%') {
                if (n + 2 >= n4 || !URI.isHex(string.charAt(n + 1)) || !URI.isHex(string.charAt(n + 2))) {
                    throw new MalformedURIException("Path contains invalid escape sequence!");
                }
            } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                throw new MalformedURIException("Path contains invalid character: " + c);
            }
            ++n;
        }
        this.m_path = string.substring(n2, n);
        if (c == '?') {
            n2 = ++n;
            while (n < n4) {
                c = string.charAt(n);
                if (c == '#') break;
                if (c == '%') {
                    if (n + 2 >= n4 || !URI.isHex(string.charAt(n + 1)) || !URI.isHex(string.charAt(n + 2))) {
                        throw new MalformedURIException("Query string contains invalid escape sequence!");
                    }
                } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                    throw new MalformedURIException("Query string contains invalid character:" + c);
                }
                ++n;
            }
            this.m_queryString = string.substring(n2, n);
        }
        if (c == '#') {
            n2 = ++n;
            while (n < n4) {
                c = string.charAt(n);
                if (c == '%') {
                    if (n + 2 >= n4 || !URI.isHex(string.charAt(n + 1)) || !URI.isHex(string.charAt(n + 2))) {
                        throw new MalformedURIException("Fragment contains invalid escape sequence!");
                    }
                } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                    throw new MalformedURIException("Fragment contains invalid character:" + c);
                }
                ++n;
            }
            this.m_fragment = string.substring(n2, n);
        }
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_userinfo != null || this.m_host != null || this.m_port != null) {
            stringBuffer.append("//");
        }
        if (this.m_userinfo != null) {
            stringBuffer.append(this.m_userinfo);
            stringBuffer.append('@');
        }
        if (this.m_host != null) {
            stringBuffer.append(this.m_host);
        }
        if (this.m_port != null) {
            stringBuffer.append(':');
            stringBuffer.append(this.m_port);
        }
        if (this.m_path != null) {
            stringBuffer.append(this.m_path);
        }
        if (this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.n_port;
    }

    public String getPath(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(this.m_path);
        if (bl && this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (bl2 && this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getPath() {
        return this.m_path;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    private void setScheme(String string) throws MalformedURIException {
        if (string == null) {
            throw new MalformedURIException("Cannot set scheme from null string!");
        }
        if (!URI.isConformantSchemeName(string)) {
            throw new MalformedURIException("The scheme is not conformant.");
        }
        this.m_scheme = string;
    }

    private void setUserinfo(String string) throws MalformedURIException {
        if (string == null) {
            this.m_userinfo = null;
        } else {
            if (this.m_host == null) {
                throw new MalformedURIException("Userinfo cannot be set when host is null!");
            }
            int n = 0;
            int n2 = string.length();
            char c = '\u0000';
            while (n < n2) {
                c = string.charAt(n);
                if (c == '%') {
                    if (n + 2 >= n2 || !URI.isHex(string.charAt(n + 1)) || !URI.isHex(string.charAt(n + 2))) {
                        throw new MalformedURIException("Userinfo contains invalid escape sequence!");
                    }
                } else if (!URI.isUnreservedCharacter(c) && USERINFO_CHARACTERS.indexOf(c) == -1) {
                    throw new MalformedURIException("Userinfo contains invalid character:" + c);
                }
                ++n;
            }
        }
        this.m_userinfo = string;
    }

    private void setHost(String string) throws MalformedURIException {
        if (string == null || string.length() == 0) {
            this.m_host = string;
            this.m_userinfo = null;
            this.m_port = null;
            this.n_port = -1;
        } else if (!URI.isWellFormedAddress(string)) {
            throw new MalformedURIException("Host is not a well formed address!");
        }
        this.m_host = string;
    }

    private void setPort(int n) throws MalformedURIException {
        if (n >= 0 && n <= 65535) {
            if (this.m_host == null) {
                throw new MalformedURIException("Port cannot be set when host is null!");
            }
        } else if (n != -1) {
            throw new MalformedURIException("Invalid port number!");
        }
        this.n_port = n;
    }

    private void setPath(String string) throws MalformedURIException {
        if (string == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(string);
        }
    }

    private void appendPath(String string) throws MalformedURIException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (!URI.isURIString(string)) {
            throw new MalformedURIException("Path contains invalid character!");
        }
        this.m_path = this.m_path == null || this.m_path.length() == 0 ? (string.startsWith("/") ? string : "/" + string) : (this.m_path.endsWith("/") ? (string.startsWith("/") ? this.m_path.concat(string.substring(1)) : this.m_path.concat(string)) : (string.startsWith("/") ? this.m_path.concat(string) : this.m_path.concat("/" + string)));
    }

    private void setQueryString(String string) throws MalformedURIException {
        if (string == null) {
            this.m_queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Query string can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Query string cannot be set when path is null!");
            }
            if (!URI.isURIString(string)) {
                throw new MalformedURIException("Query string contains invalid character!");
            }
            this.m_queryString = string;
        }
    }

    public void setFragment(String string) throws MalformedURIException {
        if (string == null) {
            this.m_fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Fragment can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Fragment cannot be set when path is null!");
            }
            if (!URI.isURIString(string)) {
                throw new MalformedURIException("Fragment contains invalid character!");
            }
            this.m_fragment = string;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            URI uRI = (URI)object;
            if ((this.m_scheme == null && uRI.m_scheme == null || this.m_scheme != null && uRI.m_scheme != null && this.m_scheme.equals(uRI.m_scheme)) && (this.m_userinfo == null && uRI.m_userinfo == null || this.m_userinfo != null && uRI.m_userinfo != null && this.m_userinfo.equals(uRI.m_userinfo)) && (this.m_host == null && uRI.m_host == null || this.m_host != null && uRI.m_host != null && this.m_host.equals(uRI.m_host)) && (this.m_port == null && uRI.m_port == null || this.m_port != null && uRI.m_port != null && this.m_port.equals(uRI.m_port)) && (this.m_path == null && uRI.m_path == null || this.m_path != null && uRI.m_path != null && this.m_path.equals(uRI.m_path)) && (this.m_queryString == null && uRI.m_queryString == null || this.m_queryString != null && uRI.m_queryString != null && this.m_queryString.equals(uRI.m_queryString)) && (this.m_fragment == null && uRI.m_fragment == null || this.m_fragment != null && uRI.m_fragment != null && this.m_fragment.equals(uRI.m_fragment))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_scheme != null) {
            stringBuffer.append(this.m_scheme);
            stringBuffer.append(':');
        }
        stringBuffer.append(this.getSchemeSpecificPart());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isGenericURI() {
        return this.m_host != null;
    }

    public static boolean isConformantSchemeName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!URI.isAlpha(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!URI.isAlphanum(c) && SCHEME_CHARACTERS.indexOf(c) == -1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isWellFormedAddress(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string;
        int n = string2.length();
        if (n == 0 || n > 255) {
            return false;
        }
        if (string2.startsWith(".") || string2.startsWith("-")) {
            return false;
        }
        int n2 = string2.lastIndexOf(46);
        if (string2.endsWith(".")) {
            n2 = string2.substring(0, n2).lastIndexOf(46);
        }
        if (n2 + 1 < n && URI.isDigit(string.charAt(n2 + 1))) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                char c = string2.charAt(n5);
                if (c == '.') {
                    if (!URI.isDigit(string2.charAt(n5 - 1)) || n5 + 1 < n && !URI.isDigit(string2.charAt(n5 + 1))) {
                        return false;
                    }
                    ++n4;
                } else if (!URI.isDigit(c)) {
                    return false;
                }
                ++n5;
            }
            if (n4 != 3) {
                return false;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                char c = string2.charAt(n6);
                if (c == '.') {
                    if (!URI.isAlphanum(string2.charAt(n6 - 1))) {
                        return false;
                    }
                    if (n6 + 1 < n && !URI.isAlphanum(string2.charAt(n6 + 1))) {
                        return false;
                    }
                } else if (!URI.isAlphanum(c) && c != '-') {
                    return false;
                }
                ++n6;
            }
        }
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHex(char c) {
        return URI.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphanum(char c) {
        return URI.isAlpha(c) || URI.isDigit(c);
    }

    private static boolean isReservedCharacter(char c) {
        return RESERVED_CHARACTERS.indexOf(c) != -1;
    }

    private static boolean isUnreservedCharacter(char c) {
        return !URI.isReservedCharacter(c) && "#%[]".indexOf(c) == -1;
    }

    public boolean isNormalFormC() {
        if (!this.haveCheckedNFC) {
            this.isNFC = CharacterModel.isNormalFormC(this.toString());
            this.haveCheckedNFC = true;
        }
        return this.isNFC;
    }

    private static boolean isURIString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '%') {
                if (n2 + 2 >= n || !URI.isHex(string.charAt(n2 + 1)) || !URI.isHex(string.charAt(n2 + 2))) {
                    return false;
                }
                n2 += 2;
            } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public String relativize(String string, int n) throws MalformedURIException {
        URI uRI = new URI(string);
        if (uRI.isGenericURI()) {
            String string2;
            boolean bl = this.equal(uRI.m_scheme, this.m_scheme);
            boolean bl2 = bl && this.equal(uRI.m_host, this.m_host) && this.equal(this.m_userinfo, uRI.m_userinfo) && this.equal(this.m_port, uRI.m_port);
            boolean bl3 = bl2 && this.equal(this.m_path, uRI.m_path) && this.equal(this.m_queryString, uRI.m_queryString);
            String string3 = string2 = uRI.m_fragment == null ? "" : "#" + uRI.m_fragment;
            if (bl3 && (n & 1) != 0) {
                return string2;
            }
            if (uRI.m_queryString != null) {
                string2 = "?" + uRI.m_queryString + string2;
            }
            if (bl2) {
                if (this.m_subPaths == null) {
                    this.m_subPaths = new String[]{this.m_path == null ? null : this.m_path + "a", null, null, null};
                }
                if (this.m_subPaths[0] != null) {
                    int n2 = 0;
                    while (n2 < 3) {
                        if ((n & prefs[n2][1]) == 0) break;
                        if (this.m_subPaths[n2 + 1] == null) {
                            this.m_subPaths[n2 + 1] = URI.getLastSlash(this.m_subPaths[n2]);
                        }
                        if (this.m_subPaths[n2 + 1].length() == 0) break;
                        if ((n & prefs[n2][0]) != 0 && uRI.m_path.startsWith(this.m_subPaths[n2 + 1])) {
                            int n4 = this.m_subPaths[n2 + 1].length();
                            if (n4 == uRI.m_path.length()) {
                                return exact[n2] + string2;
                            }
                            string2 = sub[n2] + uRI.m_path.substring(n4) + string2;
                            return string2;
                        }
                        ++n2;
                    }
                }
            }
            string2 = uRI.m_path + string2;
            if (bl2 && (n & 4) != 0) {
                return string2;
            }
            if (bl && (n & 2) != 0) {
                return "//" + (uRI.m_userinfo == null ? "" : uRI.m_userinfo + "@") + uRI.m_host + (uRI.m_port == null ? "" : ":" + uRI.m_port) + string2;
            }
        }
        return string;
    }

    private static String getLastSlash(String string) {
        int n = string.lastIndexOf(47, string.length() - 2);
        return string.substring(0, n + 1);
    }

    public static String flags2str(int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if ((n & 1) != 0) {
            stringBuffer.append("same-document, ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("network, ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("absolute, ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("relative, ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("parent, ");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append("grandparent, ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    public static int str2flags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("same-document")) {
                n |= 1;
                continue;
            }
            if (string2.equals("network")) {
                n |= 2;
                continue;
            }
            if (string2.equals("absolute")) {
                n |= 4;
                continue;
            }
            if (string2.equals("relative")) {
                n |= 8;
                continue;
            }
            if (string2.equals("parent")) {
                n |= 0x10;
                continue;
            }
            if (string2.equals("grandparent")) {
                n |= 0x20;
                continue;
            }
            logger.warn((Object)("Incorrect property value for relativeURIs: " + string2));
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

