/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPFilter;
import com.hp.hpl.jena.rdf.arp.ARPResource;
import com.hp.hpl.jena.rdf.arp.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.URI;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JenaReader
implements RDFReader,
ARPErrorNumbers {
    private static final String saxFeaturesURL = "http://xml.org/sax/features/";
    private static final String saxPropertiesURL = "http://xml.org/sax/properties/";
    private static final String apacheFeaturesURL = "http://apache.org/xml/features/";
    private static final String apachePropertiesURL = "http://apache.org/xml/properties/";
    private static final String arpPropertiesURL = "http://jena.hpl.hp.com/arp/properties/";
    private static final int arpPropertiesURLLength = "http://jena.hpl.hp.com/arp/properties/".length();
    private ARPFilter arpf;
    private Model model;
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$JenaReader;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers;

    public static void useMe(Model model) {
        model.setReaderClassName("RDF/XML", (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = JenaReader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
        model.setReaderClassName("RDF/XML-ABBREV", (class$com$hp$hpl$jena$rdf$arp$JenaReader == null ? (class$com$hp$hpl$jena$rdf$arp$JenaReader = JenaReader.class$("com.hp.hpl.jena.rdf.arp.JenaReader")) : class$com$hp$hpl$jena$rdf$arp$JenaReader).getName());
    }

    public JenaReader() {
        this.arpf = ARPFilter.create();
    }

    public void read(Model model, String string) throws RDFException {
        try {
            URLConnection uRLConnection = new URL(string).openConnection();
            String string2 = uRLConnection.getContentEncoding();
            if (string2 == null) {
                this.read(model, uRLConnection.getInputStream(), string);
            } else {
                this.read(model, new InputStreamReader(uRLConnection.getInputStream(), string2), string);
            }
        }
        catch (RDFException rDFException) {
            throw rDFException;
        }
        catch (IOException iOException) {
            throw new RDFException(iOException);
        }
    }

    public static Literal translate(ALiteral aLiteral) {
        return new LiteralImpl(aLiteral.toString(), aLiteral.getLang(), aLiteral.isWellFormedXML(), null);
    }

    Literal convert(ALiteral aLiteral) throws RDFException {
        String string = aLiteral.getDatatypeURI();
        if (string == null) {
            return this.model.createLiteral(aLiteral.toString(), aLiteral.getLang());
        }
        return this.model.createTypedLiteral(aLiteral.toString(), aLiteral.getLang(), string);
    }

    public static Resource translate(AResource aResource) {
        if (aResource.isAnonymous()) {
            String string = aResource.getAnonymousID();
            Resource resource = (Resource)aResource.getUserData();
            if (resource == null) {
                resource = new ResourceImpl();
                aResource.setUserData(resource);
            }
            return resource;
        }
        return new ResourceImpl(aResource.getURI());
    }

    Resource convert(AResource aResource) throws RDFException {
        if (aResource.isAnonymous()) {
            String string = aResource.getAnonymousID();
            Resource resource = (Resource)aResource.getUserData();
            if (resource == null) {
                resource = this.model.createResource();
                aResource.setUserData(resource);
            }
            return resource;
        }
        return this.model.createResource(aResource.getURI());
    }

    public static Property translatePred(AResource aResource) throws RDFException {
        return new PropertyImpl(aResource.getURI());
    }

    Property convertPred(AResource aResource) throws RDFException {
        return this.model.createProperty(aResource.getURI());
    }

    private synchronized void read(Model model, InputSource inputSource, String string) throws RDFException {
        try {
            this.model = model;
            if (string == null) {
                string = ARPResource.dummy;
                this.errorHandler.error(new NullPointerException("A document base URI must be specified."));
            }
            if (!string.equals("")) {
                try {
                    URI uRI = new URI(string);
                }
                catch (MalformedURIException malformedURIException) {
                    this.errorHandler.error(malformedURIException);
                }
            } else {
                string = ARPResource.dummy;
            }
            inputSource.setSystemId(string);
            this.arpf.setStatementHandler(new StatementHandler(){

                public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
                    try {
                        JenaReader.this.model.add(JenaReader.this.convert(aResource), JenaReader.this.convertPred(aResource2), JenaReader.this.convert(aResource3));
                    }
                    catch (RDFException rDFException) {
                        JenaReader.this.errorHandler.error(rDFException);
                    }
                }

                public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
                    try {
                        JenaReader.this.model.add(JenaReader.this.convert(aResource), JenaReader.this.convertPred(aResource2), JenaReader.this.convert(aLiteral));
                    }
                    catch (RDFException rDFException) {
                        JenaReader.this.errorHandler.error(rDFException);
                    }
                }
            });
            this.arpf.setErrorHandler(new ARPSaxErrorHandler(this.errorHandler));
            this.arpf.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new RDFException(iOException);
        }
        catch (SAXException sAXException) {
            throw new RDFException(sAXException);
        }
    }

    public void read(Model model, Reader reader, String string) throws RDFException {
        this.read(model, new InputSource(reader), string);
    }

    public void read(Model model, InputStream inputStream, String string) throws RDFException {
        this.read(model, new InputSource(inputStream), string);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public Object setProperty(String string, Object object) throws RDFException {
        Object object2 = object;
        if (string.startsWith("http:")) {
            if (string.startsWith(arpPropertiesURL)) {
                return this.setArpProperty(string.substring(arpPropertiesURLLength), object2);
            }
            if (string.startsWith(saxPropertiesURL) || string.startsWith(apachePropertiesURL)) {
                Object object3;
                try {
                    object3 = this.arpf.getProperty(string);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    object3 = null;
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                try {
                    this.arpf.setProperty(string, object2);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.errorHandler.error(new RDFException(sAXNotSupportedException));
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                return object3;
            }
            if (string.startsWith(saxFeaturesURL) || string.startsWith(apacheFeaturesURL)) {
                Boolean bl;
                try {
                    bl = new Boolean(this.arpf.getFeature(string));
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    bl = null;
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                try {
                    this.arpf.setFeature(string, (Boolean)object2);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.errorHandler.error(new RDFException(sAXNotSupportedException));
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.errorHandler.error(new RDFException(22));
                    return null;
                }
                catch (ClassCastException classCastException) {
                    this.errorHandler.error(new RDFException(new SAXNotSupportedException("Feature: '" + string + "' can only have a boolean value.")));
                }
                return bl;
            }
        }
        return this.setArpProperty(string, object2);
    }

    public static int errorCode(String string) {
        Class clazz = class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers == null ? (class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers = JenaReader.class$("com.hp.hpl.jena.rdf.arp.ARPErrorNumbers")) : class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers;
        try {
            Field field = clazz.getField(string);
            return field.getInt(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String errorCodeName(int n) {
        Class clazz = class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers == null ? (class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers = JenaReader.class$("com.hp.hpl.jena.rdf.arp.ARPErrorNumbers")) : class$com$hp$hpl$jena$rdf$arp$ARPErrorNumbers;
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            try {
                if (fieldArray[n2].getInt(null) == n) {
                    return fieldArray[n2].getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    private Object setArpProperty(String string, Object object) {
        int n;
        string = string.toUpperCase();
        if (object == null) {
            object = "";
        }
        if (object instanceof String) {
            object = ((String)object).toUpperCase();
        }
        if (string.equals("ERROR-MODE")) {
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.equals("LAX")) {
                    this.arpf.setLaxErrorMode();
                    return null;
                }
                if (string2.equals("DEFAULT")) {
                    this.arpf.setDefaultErrorMode();
                    return null;
                }
                if (string2.equals("STRICT")) {
                    this.arpf.setStrictErrorMode();
                    return null;
                }
                if (string2.equals("STRICT-WARNING")) {
                    this.arpf.setStrictErrorMode(1);
                    return null;
                }
                if (string2.equals("STRICT-FATAL")) {
                    this.arpf.setStrictErrorMode(3);
                    return null;
                }
                if (string2.equals("STRICT-IGNORE")) {
                    this.arpf.setStrictErrorMode(0);
                    return null;
                }
                if (string2.equals("STRICT-ERROR")) {
                    this.arpf.setStrictErrorMode(2);
                    return null;
                }
            }
            this.errorHandler.error(new IllegalArgumentException("Property \"ERROR-MODE\" takes the following values: \"default\", \"lax\", \"strict\", \"strict-ignore\", \"strict-warning\", \"strict-error\", \"strict-fatal\"."));
            return null;
        }
        if (string.equals("EMBEDDING")) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            if (!(object instanceof Boolean)) {
                this.errorHandler.error(new IllegalArgumentException("Property \"EMBEDDING\" requires a boolean value."));
                boolean bl = this.arpf.setEmbedding(false);
                this.arpf.setEmbedding(bl);
                return new Boolean(bl);
            }
            return new Boolean(this.arpf.setEmbedding((Boolean)object));
        }
        if ((string.startsWith("ERR_") || string.startsWith("IGN_") || string.startsWith("WARN_")) && (n = JenaReader.errorCode(string)) != -1) {
            int n2;
            if (object instanceof String) {
                if (((String)object).startsWith("EM_") && (n2 = JenaReader.errorCode((String)object)) != -1) {
                    int n4 = this.arpf.setErrorMode(n, n2);
                    return new Integer(n4);
                }
            } else if (object instanceof Integer) {
                n2 = (Integer)object;
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        int n5 = this.arpf.setErrorMode(n, n2);
                        return new Integer(n5);
                    }
                }
            }
            this.errorHandler.error(new IllegalArgumentException("Property \"" + string + "\" cannot have value: " + object.toString()));
            n2 = this.arpf.setErrorMode(n, 2);
            this.arpf.setErrorMode(n, n2);
            return new Integer(n2);
        }
        this.errorHandler.error(new RDFException(22));
        return null;
    }

    public static Model memModel() {
        ModelMem modelMem = new ModelMem();
        JenaReader.useMe(modelMem);
        return modelMem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

