/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.path.impl.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.path.Path;
import com.hp.hpl.jena.ontology.path.PathException;
import com.hp.hpl.jena.ontology.path.PathExpr;
import com.hp.hpl.jena.ontology.path.PathFactory;
import com.hp.hpl.jena.ontology.path.PathIterator;
import com.hp.hpl.jena.ontology.path.PathSet;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestPath
extends TestCase {
    protected static final String NS = "http://test/path#";
    protected static Object[][] s_stmts = new Object[][]{{"a", "p", "b"}, {"a", "q", "c"}, {"b", "q", "d0"}, {"b", "p", "d1"}, {"b", "p", "d2"}, {"d1", "q", "e1"}, {"d1", "q", "e2"}, {"e", "q", "e"}, {"e", "p", "e"}, {"f0", "q", "f1"}, {"f0", "q", "f2"}, {"f1", "q", "f4"}, {"f2", "q", "f4"}, {"f2", "q", "f3"}};
    protected OntModel m_model = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
    protected Property m_p;
    protected Property m_q;
    protected Resource m_a;
    protected Resource m_b;
    protected Resource m_c;
    protected Resource m_e;

    public TestPath(String string) {
        super(string);
    }

    public void setUp() {
        int n = 0;
        while (n < s_stmts.length) {
            Resource resource = this.m_model.getResource(NS + (String)s_stmts[n][0]);
            Property property = this.m_model.getProperty(NS + (String)s_stmts[n][1]);
            Resource resource2 = this.m_model.getResource(NS + (String)s_stmts[n][2]);
            this.m_model.add(resource, property, resource2);
            ++n;
        }
        this.m_p = this.m_model.getProperty("http://test/path#p");
        this.m_q = this.m_model.getProperty("http://test/path#q");
        this.m_a = this.m_model.getResource("http://test/path#a");
        this.m_b = this.m_model.getResource("http://test/path#b");
        this.m_c = this.m_model.getResource("http://test/path#c");
        this.m_e = this.m_model.getResource("http://test/path#e");
    }

    public void tearDown() {
    }

    public void testNamedUnitPath() {
        PathExpr pathExpr = PathFactory.unit(this.m_p);
        PathSet pathSet = pathExpr.asPathSet(this.m_a);
        Assert.assertEquals((String)"Unit path set over p from a should have size 1", (int)1, (int)pathSet.size());
        Assert.assertTrue((String)"Path set should not be empty", (!pathSet.isEmpty() ? 1 : 0) != 0);
        PathIterator pathIterator = pathSet.paths();
        Assert.assertTrue((String)"Should be at least one path over p from a", (boolean)pathIterator.hasNext());
        pathIterator.next();
        Assert.assertTrue((String)"Should be only one path over p from a", (!pathIterator.hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Value should be b", (Object)this.m_b, (Object)pathSet.getValue());
        Assert.assertTrue((String)"should have value b", (boolean)pathSet.hasValue(this.m_b));
        Path path = pathSet.paths().nextPath();
        Assert.assertEquals((String)"unit path should have length 1", (int)1, (int)path.length());
        Assert.assertTrue((String)"should contain 'a p b' ", (boolean)this.m_model.contains(this.m_a, this.m_p, this.m_b));
        pathSet.removeAll();
        Assert.assertTrue((String)"should not contain 'a p b' ", (!this.m_model.contains(this.m_a, this.m_p, this.m_b) ? 1 : 0) != 0);
        pathSet = pathExpr.asPathSet(this.m_a);
        Assert.assertTrue((String)"Path set should now be empty", (boolean)pathSet.isEmpty());
        boolean bl = false;
        try {
            RDFNode rDFNode = pathSet.getValue();
        }
        catch (PathException pathException) {
            bl = true;
        }
        Assert.assertTrue((String)"Getting value from empty path should raise exception", (boolean)bl);
    }

    public void testAnyUnitPath() {
        PathExpr pathExpr = PathFactory.unit();
        PathSet pathSet = pathExpr.asPathSet(this.m_a);
        Assert.assertEquals((String)"Unit path set over p from a should have size 2", (int)2, (int)pathSet.size());
        Assert.assertTrue((String)"Path set should not be empty", (!pathSet.isEmpty() ? 1 : 0) != 0);
        PathIterator pathIterator = pathSet.paths();
        Assert.assertTrue((String)"Should be at least one path over p from a", (boolean)pathIterator.hasNext());
        pathIterator.next();
        Assert.assertTrue((String)"Should be at least two paths over p from a", (boolean)pathIterator.hasNext());
        pathIterator.next();
        Assert.assertTrue((String)"Should be only two paths over p from a", (!pathIterator.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((String)"should have value b", (boolean)pathSet.hasValue(this.m_b));
        Assert.assertTrue((String)"should have value c", (boolean)pathSet.hasValue(this.m_c));
        Path path = pathSet.paths().nextPath();
        Assert.assertEquals((String)"unit path should have length 1", (int)1, (int)path.length());
        Assert.assertTrue((String)"should contain 'a p b' ", (boolean)this.m_model.contains(this.m_a, this.m_p, this.m_b));
        Assert.assertTrue((String)"should contain 'a p b' ", (boolean)this.m_model.contains(this.m_a, this.m_q, this.m_c));
        pathSet.removeAll();
        Assert.assertTrue((String)"should not contain 'a p b' ", (!this.m_model.contains(this.m_a, this.m_p, this.m_b) ? 1 : 0) != 0);
        Assert.assertTrue((String)"should not contain 'a p b' ", (!this.m_model.contains(this.m_a, this.m_q, this.m_c) ? 1 : 0) != 0);
        pathSet = pathExpr.asPathSet(this.m_a);
        Assert.assertTrue((String)"Path set should now be empty", (boolean)pathSet.isEmpty());
    }

    public void testComposeUnitPath() {
        PathExpr pathExpr = PathFactory.compose(this.m_p, this.m_q);
        PathSet pathSet = pathExpr.asPathSet(this.m_a);
        Assert.assertTrue((String)"p o q from node a should not be empty", (!pathSet.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"p o q from node a should have size 1", (int)1, (int)pathSet.size());
        PathSet pathSet2 = pathExpr.asPathSet(this.m_b);
        Assert.assertTrue((String)"p o q from node b should not be empty", (!pathSet2.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"p o q from node b should have size 2", (int)2, (int)pathSet2.size());
        Resource resource = this.m_model.getResource("http://test/path#e2");
        Assert.assertTrue((String)"p o q from node b should have e2 as a value", (boolean)pathSet2.hasValue(resource));
        PathSet pathSet3 = pathExpr.asPathSet(this.m_e);
        Assert.assertTrue((String)"p o q from node e should not be empty", (!pathSet3.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"p o q from node e should have size 1", (int)1, (int)pathSet3.size());
    }

    public void testComposeComplexPath() {
        PathExpr pathExpr = PathFactory.compose(this.m_p, this.m_p);
        PathExpr pathExpr2 = PathFactory.compose(pathExpr, this.m_q);
        Assert.assertEquals((String)"ppq size should be 2", (int)2, (int)pathExpr2.asPathSet(this.m_a).size());
        Resource resource = this.m_model.getResource("http://test/path#e2");
        Assert.assertTrue((String)"p o p o q should have e2 as value", (boolean)pathExpr2.asPathSet(this.m_a).hasValue(resource));
    }

    public void testClosurePath() {
        PathExpr pathExpr = PathFactory.closure(this.m_q);
        Assert.assertEquals((String)"q* from a should have size 1", (int)1, (int)pathExpr.asPathSet(this.m_a).size());
        Resource resource = this.m_model.getResource("http://test/path#f0");
        Assert.assertEquals((String)"q* from f0 should have size 5", (int)5, (int)pathExpr.asPathSet(resource).size());
        Resource resource2 = this.m_model.getResource("http://test/path#e");
        Assert.assertEquals((String)"q* from e should be size 1", (int)1, (int)pathExpr.asPathSet(resource2).size());
        int n = 0;
        PathIterator pathIterator = PathFactory.closure(this.m_q, false).evaluate(resource2);
        n = 0;
        while (n < 100) {
            Assert.assertTrue((String)"Should be more on the path", (boolean)pathIterator.hasNext());
            Assert.assertEquals((String)"Path length not correct", (int)(n + 1), (int)pathIterator.nextPath().length());
            ++n;
        }
        Assert.assertEquals((String)"Did not complete iteration", (int)100, (int)n);
    }
}

