/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.path.impl;

import com.hp.hpl.jena.ontology.path.Path;
import com.hp.hpl.jena.ontology.path.PathException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PathImpl
implements Path {
    protected List m_statements = new ArrayList();
    protected Path m_prePath = null;

    public PathImpl() {
    }

    public PathImpl(List list) {
        this.m_statements.addAll(list);
    }

    public PathImpl(Iterator iterator) {
        while (iterator.hasNext()) {
            this.add((Statement)iterator.next());
        }
    }

    public PathImpl(Statement statement) {
        this.m_statements.add(statement);
    }

    public PathImpl(Path path, Statement statement) {
        this.m_prePath = path;
        this.m_statements.add(statement);
    }

    public PathImpl(Path path, Path path2) {
        this.m_prePath = path;
        this.m_statements.addAll(path2.asList());
    }

    public RDFNode getValue() {
        return this.getLastStatement().getObject();
    }

    public StmtIterator iterator() {
        return new PathStmtIterator();
    }

    public int length() {
        return (this.m_prePath == null ? 0 : this.m_prePath.length()) + this.m_statements.size();
    }

    public boolean isEmpty() {
        return this.m_prePath == null ? this.m_statements.isEmpty() : this.m_prePath.isEmpty() && this.m_statements.isEmpty();
    }

    public void add(Statement statement) {
        this.m_statements.add(statement);
    }

    protected Statement getLastStatement() {
        try {
            return (Statement)this.m_statements.get(this.m_statements.size() - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new PathException("Cannot get the last statement from an empty path");
        }
    }

    public List asList() {
        ArrayList arrayList = new ArrayList();
        PathStmtIterator pathStmtIterator = new PathStmtIterator();
        while (pathStmtIterator.hasNext()) {
            arrayList.add(pathStmtIterator.next());
        }
        return arrayList;
    }

    public boolean containsSubject(Resource resource) {
        Iterator iterator = this.m_statements.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (!statement.getSubject().equals(resource)) continue;
            return true;
        }
        return this.m_prePath == null ? false : this.m_prePath.containsSubject(resource);
    }

    public Statement getStatement(int n) {
        return (Statement)this.m_statements.get(n);
    }

    protected class PathStmtIterator
    implements StmtIterator {
        private int i = 0;
        private StmtIterator si;
        private Statement s;

        protected PathStmtIterator() {
            if (PathImpl.this.m_prePath != null) {
                this.si = PathImpl.this.m_prePath.iterator();
            }
        }

        public boolean hasNext() {
            return this.si != null && this.si.hasNext() || this.i < PathImpl.this.m_statements.size();
        }

        public Object next() {
            return this.si != null && this.si.hasNext() ? this.si.next() : PathImpl.this.m_statements.get(this.i++);
        }

        public Statement nextStatement() {
            return (Statement)this.next();
        }

        public void remove() {
            if (this.si != null && this.si.hasNext()) {
                this.si.remove();
            } else {
                ((Statement)PathImpl.this.m_statements.get(this.i - 1)).remove();
            }
        }

        public void close() {
        }
    }
}

