/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.path.impl;

import com.hp.hpl.jena.ontology.path.Path;
import com.hp.hpl.jena.ontology.path.PathIterator;
import com.hp.hpl.jena.ontology.path.impl.AbstractPathExpr;
import com.hp.hpl.jena.ontology.path.impl.PathImpl;
import com.hp.hpl.jena.ontology.path.impl.PathIteratorImpl;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.List;

public class ClosurePathExpr
extends AbstractPathExpr {
    protected Property m_pred;
    protected boolean m_occurs = true;

    public ClosurePathExpr(Property property, boolean bl) {
        this.m_pred = property;
        this.m_occurs = bl;
    }

    public PathIterator evaluate(Resource resource) {
        return new ComposePathIterator(resource);
    }

    protected class ComposePathIterator
    extends PathIteratorImpl {
        protected StmtIterator m_si;
        protected Path m_head = null;
        protected List m_queue = new ArrayList();
        protected Statement m_stmt = null;

        protected ComposePathIterator(Resource resource) {
            this.m_si = resource.listProperties(ClosurePathExpr.this.m_pred);
        }

        public boolean hasNext() {
            this.checkNext();
            return this.m_stmt != null;
        }

        public Object next() {
            PathImpl pathImpl;
            this.checkNext();
            PathImpl pathImpl2 = pathImpl = this.m_head == null ? new PathImpl(this.m_stmt) : new PathImpl(this.m_head, this.m_stmt);
            if (this.m_stmt.getObject() instanceof Resource) {
                this.m_queue.add(pathImpl);
            }
            this.m_stmt = null;
            return pathImpl;
        }

        protected void checkNext() {
            while (this.m_stmt == null && (this.m_si != null && this.m_si.hasNext() || !this.m_queue.isEmpty())) {
                if (this.m_si.hasNext()) {
                    this.m_stmt = this.m_si.nextStatement();
                    if (!this.occursCheck()) continue;
                    this.m_stmt = null;
                    continue;
                }
                if (this.m_queue.isEmpty()) continue;
                this.m_head = (Path)this.m_queue.remove(0);
                this.m_si = ((Resource)this.m_head.getValue()).listProperties(ClosurePathExpr.this.m_pred);
            }
        }

        protected boolean occursCheck() {
            if (ClosurePathExpr.this.m_occurs && this.m_stmt.getObject() instanceof Resource) {
                return this.m_head != null && this.m_head.containsSubject(this.m_stmt.getResource());
            }
            return false;
        }
    }
}

