/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.path;

import com.hp.hpl.jena.ontology.path.Path;
import com.hp.hpl.jena.ontology.path.PathException;
import com.hp.hpl.jena.ontology.path.PathExpr;
import com.hp.hpl.jena.ontology.path.PathIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.HashSet;

public class PathSet {
    protected PathExpr m_expr;
    protected Resource m_root;

    public PathSet(Resource resource, PathExpr pathExpr) {
        this.m_expr = pathExpr;
        this.m_root = resource;
    }

    public void add(RDFNode rDFNode) {
        this.m_expr.add(this.m_root, rDFNode);
    }

    public void removeAll() {
        StmtIterator stmtIterator;
        HashSet<Object> hashSet = new HashSet<Object>();
        PathIterator pathIterator = this.paths();
        while (pathIterator.hasNext()) {
            stmtIterator = pathIterator.nextPath().iterator();
            while (stmtIterator.hasNext()) {
                hashSet.add(stmtIterator.next());
            }
        }
        stmtIterator = hashSet.iterator();
        while (stmtIterator.hasNext()) {
            ((Statement)stmtIterator.next()).remove();
        }
    }

    public int size() {
        int n = 0;
        PathIterator pathIterator = this.paths();
        while (pathIterator.hasNext()) {
            ++n;
            pathIterator.next();
        }
        return n;
    }

    public ExtendedIterator iterator() {
        return this.paths().mapWith(new Map1(){

            public Object map1(Object object) {
                return ((Path)object).getValue();
            }
        });
    }

    public PathIterator paths() {
        return this.m_expr.evaluate(this.m_root);
    }

    public boolean hasValue(RDFNode rDFNode) {
        boolean bl = false;
        ExtendedIterator extendedIterator = this.iterator();
        while (!bl && extendedIterator.hasNext()) {
            bl = rDFNode.equals(extendedIterator.next());
        }
        extendedIterator.close();
        return bl;
    }

    public boolean isEmpty() {
        PathIterator pathIterator = this.paths();
        boolean bl = !pathIterator.hasNext();
        pathIterator.close();
        return bl;
    }

    public RDFNode getValue() {
        RDFNode rDFNode;
        PathIterator pathIterator = this.paths();
        try {
            rDFNode = pathIterator.nextPath().getValue();
            Object var4_4 = null;
        }
        catch (Exception exception) {
            try {
                throw new PathException("Tried to get the value from an empty path set");
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                pathIterator.close();
                throw throwable;
            }
        }
        pathIterator.close();
        return rDFNode;
    }

    public PathExpr getExpression() {
        return this.m_expr;
    }
}

