/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestOntDocumentManager
extends TestCase {
    private static Boolean F = Boolean.FALSE;
    private static Boolean T = Boolean.TRUE;
    public static Object[][] s_testData = new Object[][]{{"testing/ontology/testImport1", TestOntDocumentManager.cnt(1), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport2", TestOntDocumentManager.cnt(1), F, null}, {"testing/ontology/testImport3", TestOntDocumentManager.cnt(3), T, null}, {"testing/ontology/testImport4", TestOntDocumentManager.cnt(2), T, null}, {"testing/ontology/testImport5", TestOntDocumentManager.cnt(2), T, "file:testing/ontology/testImport5/ont-policy.rdf"}};

    public static final Integer cnt(int n) {
        return new Integer(n);
    }

    public TestOntDocumentManager(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestOntDocumentManager");
        testSuite.addTest((Test)new TestOntDocumentManager("testInitialisation"));
        testSuite.addTest((Test)new TestOntDocumentManager("testManualAssociation"));
        int n = 0;
        while (n < s_testData.length) {
            testSuite.addTest((Test)new DocManagerImportTest((String)s_testData[n][0], (Integer)s_testData[n][1], (Boolean)s_testData[n][2], (String)s_testData[n][3]));
            ++n;
        }
        return testSuite;
    }

    public void testInitialisation() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager();
        Assert.assertTrue((String)"Should be at least one specification loaded", (boolean)ontDocumentManager.listDocuments().hasNext());
        Assert.assertNotNull((String)"cache URL for owl should not be null", (Object)ontDocumentManager.getCacheURL("http://www.w3.org/2002/07/owl"));
        Assert.assertEquals((String)"cache URL for owl not correct", (Object)"file:vocabularies/owl.owl", (Object)ontDocumentManager.getCacheURL("http://www.w3.org/2002/07/owl"));
        Assert.assertEquals((String)"prefix for owl not correct", (Object)"owl", (Object)ontDocumentManager.getPrefixForURI("http://www.w3.org/2002/07/owl"));
        ontDocumentManager = new OntDocumentManager("");
        Assert.assertTrue((String)"Should be no specification loaded", (!ontDocumentManager.listDocuments().hasNext() ? 1 : 0) != 0);
        ontDocumentManager = new OntDocumentManager(null);
        Assert.assertTrue((String)"Should be no specification loaded", (!ontDocumentManager.listDocuments().hasNext() ? 1 : 0) != 0);
    }

    public void testManualAssociation() {
        OntDocumentManager ontDocumentManager = new OntDocumentManager(null);
        ontDocumentManager.addPrefixMapping("http://www.w3.org/2002/07/owl", "owl");
        Assert.assertEquals((String)"prefix for owl not correct", (Object)"owl", (Object)ontDocumentManager.getPrefixForURI("http://www.w3.org/2002/07/owl"));
        Assert.assertEquals((String)"URI for owl not correct", (Object)"http://www.w3.org/2002/07/owl", (Object)ontDocumentManager.getURIForPrefix("owl"));
        ontDocumentManager.addAltEntry("http://www.w3.org/2002/07/owl", "file:foo.bar");
        Assert.assertEquals((String)"Failed to retrieve cache location", (Object)"file:foo.bar", (Object)ontDocumentManager.getCacheURL("http://www.w3.org/2002/07/owl"));
        ontDocumentManager.addLanguageEntry("http://www.w3.org/2002/07/owl", "http://www.w3.org/2002/07/owl");
        Assert.assertEquals((String)"Failed to retrieve language", (Object)"http://www.w3.org/2002/07/owl", (Object)ontDocumentManager.getLanguage("http://www.w3.org/2002/07/owl"));
    }

    static class DocManagerImportTest
    extends TestCase {
        String m_dir;
        int m_count;
        String m_path;
        boolean m_processImports;

        DocManagerImportTest(String string, int n, boolean bl, String string2) {
            super(string);
            this.m_dir = string;
            this.m_count = n;
            this.m_path = string2;
            this.m_processImports = bl;
        }

        public void runTest() {
            OntDocumentManager ontDocumentManager = new OntDocumentManager();
            ontDocumentManager.setProcessImports(this.m_processImports);
            if (this.m_path != null) {
                ontDocumentManager.setMetadataSearchPath(this.m_path, true);
            }
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#", null, ontDocumentManager);
            Assert.assertNotNull((String)"Ontology model should not be null", (Object)ontModel);
            ontModel.read("file:" + this.m_dir + "/a.owl");
            Assert.assertEquals((String)"Marker count not correct", (int)this.m_count, (int)this.countMarkers(ontModel));
        }

        public int countMarkers(Model model) {
            int n = 0;
            Resource resource = model.getResource("http://jena.hpl.hp.com/2003/03/testont#Marker");
            StmtIterator stmtIterator = model.listStatements(null, RDF.type, resource);
            while (stmtIterator.hasNext()) {
                ++n;
                stmtIterator.next();
            }
            return n;
        }
    }
}

