/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.Axiom;
import com.hp.hpl.jena.ontology.ClassDescription;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestListSyntaxCategories
extends TestCase {
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";
    protected static DoListTest[] testCases = new DoListTest[]{new DoListTest("OWL list ontologies", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntologies();
        }

        public boolean test(Resource resource) {
            return resource instanceof Ontology;
        }
    }, new DoListTest("DAML list ontologies", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntologies();
        }

        public boolean test(Resource resource) {
            return resource instanceof Ontology;
        }
    }, new DoListTest("OWL list properties", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#p"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list object properties", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listObjectProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list datatype properties", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listDatatypeProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list properties", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#p", "http://jena.hpl.hp.com/testing/ontology#rdf-p"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list object properties", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listObjectProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list datatype properties", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listDatatypeProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list individuals", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 3, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0", "http://jena.hpl.hp.com/testing/ontology#A1", "http://jena.hpl.hp.com/testing/ontology#C0"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("DAML list individuals", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 3, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0", "http://jena.hpl.hp.com/testing/ontology#A1", "http://jena.hpl.hp.com/testing/ontology#C0"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("OWL list axioms", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAxioms();
        }

        public boolean test(Resource resource) {
            return resource instanceof Axiom;
        }
    }, new DoListTest("DAML list axioms", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 0, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAxioms();
        }

        public boolean test(Resource resource) {
            return resource instanceof Axiom;
        }
    }, new DoListTest("OWL list classes", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 11, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL list named classes", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 10, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listNamedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL list intersection classes", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIntersectionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL list union classes", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#B"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listUnionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL list complement classes", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#C"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listComplementClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL list enumerated classes", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listEnumeratedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL list restrictions", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listRestrictions();
        }

        public boolean test(Resource resource) {
            return resource instanceof Restriction;
        }
    }, new DoListTest("DAML list classes", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 11, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("DAML list named classes", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 10, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listNamedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("DAML list intersection classes", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIntersectionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("DAML list union classes", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#B"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listUnionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("DAML list complement classes", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#C"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listComplementClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("DAML list enumerated classes", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listEnumeratedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("DAML list restrictions", "file:testing/ontology/daml/list-syntax/test.rdf", "http://www.daml.org/2001/03/daml+oil#", 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listRestrictions();
        }

        public boolean test(Resource resource) {
            return resource instanceof Restriction;
        }
    }, new DoListTest("OWL list annotation properties", "file:testing/ontology/owl/list-syntax/test.rdf", "http://www.w3.org/2002/07/owl#", 6, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAnnotationProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof AnnotationProperty;
        }
    }, new DoListTest("OWL+import list ontologies", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 2, new String[]{"http://jena.hpl.hp.com/testing/ontology", "http://www.w3.org/2002/07/owl"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntologies();
        }

        public boolean test(Resource resource) {
            return resource instanceof Ontology;
        }
    }, new DoListTest("OWL+import list properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 41, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL+import list object properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listObjectProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL+import list datatype properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listDatatypeProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL+import list individuals", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 8, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("OWL+import list axioms", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAxioms();
        }

        public boolean test(Resource resource) {
            return resource instanceof Axiom;
        }
    }, new DoListTest("OWL+import list classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 14, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL+import list named classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 12, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z", OWL.Thing.getURI(), OWL.Nothing.getURI()}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listNamedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL+import list intersection classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIntersectionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL+import list union classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#B", OWL.Thing.getURI()}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listUnionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL+import list complement classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 3, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listComplementClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL+import list enumerated classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listEnumeratedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof ClassDescription;
        }
    }, new DoListTest("OWL+import list restrictions", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", "http://www.w3.org/2002/07/owl#", 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listRestrictions();
        }

        public boolean test(Resource resource) {
            return resource instanceof Restriction;
        }
    }};

    public TestListSyntaxCategories(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestListSyntaxCategories");
        int n = 0;
        while (n < testCases.length) {
            testSuite.addTest((Test)testCases[n]);
            ++n;
        }
        return testSuite;
    }

    protected static class DoListTest
    extends TestCase {
        protected String m_fileName;
        protected String m_lang;
        protected int m_count;
        protected String[] m_expected;

        protected DoListTest(String string, String string2, String string3, int n, String[] stringArray) {
            super(string);
            this.m_fileName = string2;
            this.m_lang = string3;
            this.m_count = n;
            this.m_expected = stringArray;
        }

        public void setUp() {
            OntDocumentManager.getInstance().clearCache();
            OntDocumentManager.getInstance().setProcessImports(true);
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel(this.m_lang);
            ontModel.read(this.m_fileName);
            Iterator iterator = this.doList(ontModel);
            List list = this.expected(ontModel);
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                Assert.assertTrue((String)("Should not fail node test on " + resource), (boolean)this.test(resource));
                ++n;
                if (list == null) continue;
                if (list.contains(resource)) {
                    list.remove(resource);
                    continue;
                }
                if (resource.isAnon()) continue;
                ++n2;
            }
            Assert.assertEquals((String)"Wrong number of results returned", (int)this.m_count, (int)n);
            if (list != null) {
                Assert.assertTrue((String)"Did not find all expected resources in iterator", (boolean)list.isEmpty());
                Assert.assertEquals((String)"Found extraneous results, not in expected list", (int)0, (int)n2);
            }
        }

        public Iterator doList(OntModel ontModel) {
            throw new RuntimeException("This method should be overridden");
        }

        public boolean test(Resource resource) {
            return true;
        }

        protected List expected(OntModel ontModel) {
            if (this.m_expected != null) {
                ArrayList<Resource> arrayList = new ArrayList<Resource>();
                int n = 0;
                while (n < this.m_expected.length) {
                    arrayList.add(ontModel.getResource(this.m_expected[n]));
                    ++n;
                }
                return arrayList;
            }
            return null;
        }
    }
}

