/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.ListIndexException;
import com.hp.hpl.jena.ontology.OntList;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.impl.OntListImpl;
import com.hp.hpl.jena.ontology.impl.test.TestList;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestList
extends TestCase {
    public static final String NS = "uri:urn:x-rdf:test#";
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntList;

    public TestList(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestList");
        int n = 0;
        while (n <= 5) {
            testSuite.addTest((Test)new CountTest(n));
            testSuite.addTest((Test)new TailTest(n));
            ++n;
        }
        testSuite.addTest((Test)new ValidityTest());
        testSuite.addTest((Test)new HeadTest());
        testSuite.addTest((Test)new SetHeadTest());
        testSuite.addTest((Test)new SetTailTest());
        testSuite.addTest((Test)new ConsTest());
        testSuite.addTest((Test)new AddTest());
        testSuite.addTest((Test)new TestListGet());
        testSuite.addTest((Test)new ReplaceTest());
        testSuite.addTest((Test)new IndexTest1());
        testSuite.addTest((Test)new IndexTest2());
        testSuite.addTest((Test)new AppendTest());
        testSuite.addTest((Test)new ConcatenateTest());
        testSuite.addTest((Test)new ConcatenateTest2());
        testSuite.addTest((Test)new ApplyTest());
        testSuite.addTest((Test)new ReduceTest());
        testSuite.addTest((Test)new RemoveTest());
        testSuite.addTest((Test)new ListEqualsTest());
        return testSuite;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ListEqualsTest
    extends ListTest {
        public ListEqualsTest() {
            super("ListEqualsTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            OntList ontList = (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource[] resourceArray = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            Resource[] resourceArray2 = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            Resource[] resourceArray3 = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#d")};
            Resource[] resourceArray4 = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            Resource[] resourceArray5 = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#D"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            Object[][] objectArrayArray = new Object[][]{{resourceArray, resourceArray2, Boolean.TRUE}, {resourceArray, resourceArray3, Boolean.FALSE}, {resourceArray, resourceArray4, Boolean.FALSE}, {resourceArray, resourceArray5, Boolean.FALSE}, {resourceArray2, resourceArray3, Boolean.FALSE}, {resourceArray2, resourceArray4, Boolean.FALSE}, {resourceArray2, resourceArray5, Boolean.FALSE}, {resourceArray3, resourceArray4, Boolean.FALSE}, {resourceArray3, resourceArray5, Boolean.FALSE}};
            int n = 0;
            while (n < objectArrayArray.length) {
                OntList ontList2 = ontList.concatenate(Arrays.asList((Object[])objectArrayArray[n][0]).iterator());
                OntList ontList3 = ontList.concatenate(Arrays.asList((Object[])objectArrayArray[n][1]).iterator());
                boolean bl = (Boolean)objectArrayArray[n][2];
                Assert.assertEquals((String)("sameListAs testSpec[" + n + "] incorrect"), (boolean)bl, (boolean)ontList2.sameListAs(ontList3));
                Assert.assertEquals((String)("sameListAs testSpec[" + n + "] (swapped) incorrect"), (boolean)bl, (boolean)ontList3.sameListAs(ontList2));
                ++n;
            }
        }
    }

    protected static class RemoveTest
    extends ListTest {
        public RemoveTest() {
            super("RemoveTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            OntList ontList = (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            OntList ontList2 = (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource resource2 = ontModel.createResource("uri:urn:x-rdf:test#x");
            Resource resource3 = ontModel.createResource("uri:urn:x-rdf:test#y");
            int n = 0;
            while (n < 10) {
                ontList = ontList.cons(resource2);
                ontList2 = ontList2.cons(resource3);
                ++n;
            }
            while (!ontList.isEmpty()) {
                ontList = ontList.removeHead();
                this.checkValid("removeTest0", ontList, true);
            }
            ontList2.removeAll();
            Assert.assertEquals((String)"Model should be empty after deleting two lists", (long)0L, (long)ontModel.size());
        }
    }

    protected static class ReduceTest
    extends ListTest {
        public ReduceTest() {
            super("ReduceTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            OntList ontList = this.getListRoot(ontModel);
            OntList.ReduceFn reduceFn = new OntList.ReduceFn(this){
                private final /* synthetic */ ReduceTest this$0;
                {
                    this.this$0 = reduceTest;
                }

                public Object reduce(RDFNode rDFNode, Object object) {
                    return (String)object + ((Resource)rDFNode).getLocalName();
                }
            };
            Assert.assertEquals((String)"Result of reduce should be concatentation of local names", (Object)"abcde", (Object)ontList.reduce(reduceFn, ""));
        }
    }

    protected static class ApplyTest
    extends ListTest {
        public ApplyTest() {
            super("ApplyTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            OntList ontList = this.getListRoot(ontModel);
            class MyApply
            implements OntList.ApplyFn {
                String collect;
                private final /* synthetic */ ApplyTest this$0;

                MyApply(ApplyTest applyTest) {
                    this.this$0 = applyTest;
                    this.collect = "";
                }

                public void apply(RDFNode rDFNode) {
                    this.collect = this.collect + ((Resource)rDFNode).getLocalName();
                }
            }
            MyApply myApply = new MyApply(this);
            ontList.apply(myApply);
            Assert.assertEquals((String)"Result of apply should be concatentation of local names", (Object)"abcde", (Object)myApply.collect);
        }
    }

    protected static class ConcatenateTest2
    extends ListTest {
        public ConcatenateTest2() {
            super("ConcatenateTest2");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            Resource resource = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            OntList ontList = (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource[] resourceArray = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            OntList ontList2 = ontList.concatenate(Arrays.asList(resourceArray).iterator());
            this.checkValid("concatTest3", ontList2, true);
            OntList ontList3 = this.getListRoot(ontModel);
            Assert.assertTrue((String)"Constructed and loaded lists should be the same", (boolean)ontList2.sameListAs(ontList3));
        }
    }

    protected static class ConcatenateTest
    extends ListTest {
        public ConcatenateTest() {
            super("ConcatenateTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            Resource resource = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            OntList ontList = (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource resource2 = ontModel.createResource("uri:urn:x-rdf:test#foo");
            int n = 0;
            while (n < 5) {
                ontList = ontList.cons(resource2);
                ++n;
            }
            int n2 = ontList.size();
            OntList ontList2 = this.getListRoot(ontModel);
            int n4 = ontList2.size();
            OntList ontList3 = ontList2.concatenate(ontList);
            this.checkValid("concatTest0", ontList, true);
            Assert.assertEquals((String)"Original list should be unchanged", (int)n2, (int)ontList.size());
            this.checkValid("concatTest1", ontList2, true);
            Assert.assertEquals((String)"Root list should be new length", (int)(n4 + n2), (int)ontList2.size());
            this.checkValid("appendTest2", ontList3, true);
            Assert.assertEquals((String)"Concatted list not correct length", (int)(n4 + n2), (int)ontList3.size());
            Assert.assertEquals((String)"Result list and subject list should be the same", (Object)ontList2, (Object)ontList3);
        }
    }

    protected static class AppendTest
    extends ListTest {
        public AppendTest() {
            super("AppendTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            Resource resource = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            OntList ontList = (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource resource2 = ontModel.createResource("uri:urn:x-rdf:test#foo");
            int n = 0;
            while (n < 5) {
                ontList = ontList.cons(resource2);
                ++n;
            }
            int n2 = ontList.size();
            OntList ontList2 = this.getListRoot(ontModel);
            int n4 = ontList2.size();
            OntList ontList3 = ontList2.append(ontList);
            this.checkValid("appendTest0", ontList2, true);
            Assert.assertEquals((String)"Original list should be unchanged", (int)n4, (int)ontList2.size());
            this.checkValid("appendTest1", ontList, true);
            Assert.assertEquals((String)"Original list should be unchanged", (int)n2, (int)ontList.size());
            this.checkValid("appendTest2", ontList3, true);
            Assert.assertEquals((String)"Appended list not correct length", (int)(n4 + n2), (int)ontList3.size());
        }
    }

    protected static class IndexTest2
    extends ListTest {
        public IndexTest2() {
            super("IndexTest2");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            OntList ontList = (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource resource2 = ontModel.createResource("uri:urn:x-rdf:test#a");
            int n = 0;
            while (n < 10) {
                ontList = ontList.cons(resource2);
                ++n;
            }
            int n2 = 0;
            while (n2 < 10) {
                Assert.assertEquals((String)"index of j'th item should be j", (int)n2, (int)ontList.indexOf(resource2, n2));
                ++n2;
            }
        }
    }

    protected static class IndexTest1
    extends ListTest {
        public IndexTest1() {
            super("IndexTest1");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            Resource[] resourceArray = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            OntList ontList = this.getListRoot(ontModel);
            int n = 0;
            while (n < resourceArray.length) {
                Assert.assertTrue((String)("list should contain element " + n), (boolean)ontList.contains(resourceArray[n]));
                Assert.assertEquals((String)("list element " + n + " is not correct"), (int)n, (int)ontList.indexOf(resourceArray[n]));
                ++n;
            }
        }
    }

    protected static class ReplaceTest
    extends ListTest {
        public ReplaceTest() {
            super("ReplaceTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            Literal[] literalArray = new Literal[]{ontModel.createLiteral("a"), ontModel.createLiteral("b"), ontModel.createLiteral("c"), ontModel.createLiteral("d"), ontModel.createLiteral("e")};
            OntList ontList = this.getListRoot(ontModel);
            int n = 0;
            while (n < literalArray.length) {
                ontList.replace(n, literalArray[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < literalArray.length) {
                Assert.assertEquals((String)("list element " + n2 + " is not correct"), (Object)literalArray[n2], (Object)ontList.get(n2));
                ++n2;
            }
            boolean bl = false;
            try {
                RDFNode rDFNode = ontList.replace(literalArray.length + 1, literalArray[0]);
            }
            catch (ListIndexException listIndexException) {
                bl = true;
            }
            Assert.assertTrue((String)"Should see exception raised by accessing beyond end of list", (boolean)bl);
        }
    }

    protected static class TestListGet
    extends ListTest {
        public TestListGet() {
            super("TestListGet");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            Resource[] resourceArray = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            OntList ontList = this.getListRoot(ontModel);
            int n = 0;
            while (n < resourceArray.length) {
                Assert.assertEquals((String)("list element " + n + " is not correct"), (Object)resourceArray[n], (Object)ontList.get(n));
                ++n;
            }
            boolean bl = false;
            try {
                RDFNode rDFNode = ontList.get(resourceArray.length + 1);
            }
            catch (ListIndexException listIndexException) {
                bl = true;
            }
            Assert.assertTrue((String)"Should see exception raised by accessing beyond end of list", (boolean)bl);
        }
    }

    protected static class AddTest
    extends ListTest {
        public AddTest() {
            super("AddTest");
        }

        public void runTest() {
            Object object;
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.createResource("uri:urn:x-rdf:test#root");
            Property property = ontModel.createProperty(TestList.NS, "p");
            Resource resource2 = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            Object object2 = (OntList)resource2.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource[] resourceArray = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#a"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#e")};
            int n = 0;
            while (n < resourceArray.length) {
                object = object2.add(resourceArray[n]);
                this.checkValid("addTest0", (OntList)object, true);
                Assert.assertTrue((String)"added'ed lists should be equal", (object2.equals(resource2) || object.equals(object2) ? 1 : 0) != 0);
                object2 = object;
                ++n;
            }
            ontModel.add(resource, property, (RDFNode)object2);
            object = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            object.read("file:testing/ontology/list5.rdf");
            Assert.assertTrue((String)"Add'ed and read models should be the same", (boolean)object.isIsomorphicWith(ontModel));
        }
    }

    protected static class ConsTest
    extends ListTest {
        public ConsTest() {
            super("ConsTest");
        }

        public void runTest() {
            Object object;
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.createResource("uri:urn:x-rdf:test#root");
            Property property = ontModel.createProperty(TestList.NS, "p");
            Resource resource2 = ontModel.getResource(OntListImpl.RDF_LIST_VOCAB.getNil().getURI());
            Object object2 = (OntList)resource2.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Resource[] resourceArray = new Resource[]{ontModel.createResource("uri:urn:x-rdf:test#e"), ontModel.createResource("uri:urn:x-rdf:test#d"), ontModel.createResource("uri:urn:x-rdf:test#c"), ontModel.createResource("uri:urn:x-rdf:test#b"), ontModel.createResource("uri:urn:x-rdf:test#a")};
            int n = 0;
            while (n < resourceArray.length) {
                object = object2.cons(resourceArray[n]);
                this.checkValid("constest1", (OntList)object, true);
                Assert.assertTrue((String)"cons'ed lists should not be equal", (!object.equals(object2) ? 1 : 0) != 0);
                object2 = object;
                ++n;
            }
            ontModel.add(resource, property, (RDFNode)object2);
            object = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            object.read("file:testing/ontology/list5.rdf");
            Assert.assertTrue((String)"Cons'ed and read models should be the same", (boolean)object.isIsomorphicWith(ontModel));
        }
    }

    protected static class SetTailTest
    extends ListTest {
        public SetTailTest() {
            super("SetTailTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.createResource("uri:urn:x-rdf:test#root");
            Property property = ontModel.createProperty(TestList.NS, "p");
            Resource resource2 = OntListImpl.RDF_LIST_VOCAB.getNil();
            ontModel.add(resource2, RDF.type, OntListImpl.RDF_LIST_VOCAB.getCellType());
            Resource resource3 = ontModel.createResource();
            ontModel.add(resource3, RDF.type, RDF.List);
            ontModel.add(resource3, RDF.first, "fred");
            ontModel.add(resource3, RDF.rest, resource2);
            ontModel.add(resource, property, resource3);
            OntList ontList = this.getListRoot(ontModel);
            this.checkValid("settail1", ontList, true);
            Resource resource4 = ontModel.createResource();
            ontModel.add(resource4, RDF.type, RDF.List);
            ontModel.add(resource4, RDF.first, "george");
            ontModel.add(resource4, RDF.rest, resource2);
            OntList ontList2 = (OntList)resource4.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Assert.assertNotNull((String)"as(OntList) should not return null for root", (Object)ontList2);
            this.checkValid("settail2", ontList2, true);
            Assert.assertEquals((String)"l1 should have length 1", (int)1, (int)ontList.size());
            Assert.assertEquals((String)"l2 should have length 1", (int)1, (int)ontList2.size());
            ontList.setTail(ontList2);
            this.checkValid("settail3", ontList, true);
            this.checkValid("settail4", ontList2, true);
            Assert.assertEquals((String)"l1 should have length 2", (int)2, (int)ontList.size());
            Assert.assertEquals((String)"l2 should have length 1", (int)1, (int)ontList2.size());
        }
    }

    protected static class SetHeadTest
    extends ListTest {
        public SetHeadTest() {
            super("SetHeadTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.createResource("uri:urn:x-rdf:test#root");
            Property property = ontModel.createProperty(TestList.NS, "p");
            Resource resource2 = OntListImpl.RDF_LIST_VOCAB.getNil();
            ontModel.add(resource2, RDF.type, OntListImpl.RDF_LIST_VOCAB.getCellType());
            Resource resource3 = ontModel.createResource();
            ontModel.add(resource3, RDF.type, RDF.List);
            ontModel.add(resource3, RDF.first, "fred");
            ontModel.add(resource3, RDF.rest, resource2);
            ontModel.add(resource, property, resource3);
            OntList ontList = this.getListRoot(ontModel);
            this.checkValid("sethead1", ontList, true);
            Assert.assertEquals((String)"List head should be 'fred'", (Object)"fred", (Object)((Literal)ontList.getHead()).getString());
            ontList.setHead(ontModel.createLiteral(42L));
            this.checkValid("sethead2", ontList, true);
            Assert.assertEquals((String)"List head should be '42'", (int)42, (int)((Literal)ontList.getHead()).getInt());
        }
    }

    protected static class TailTest
    extends ListTest {
        protected int i;

        public TailTest(int n) {
            super("TailTest");
            this.i = n;
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list" + this.i + ".rdf");
            OntList ontList = this.getListRoot(ontModel);
            int n = 0;
            while (n < this.i) {
                ontList = ontList.getTail();
                ++n;
            }
            Assert.assertTrue((String)("Should have reached the end of the list after " + this.i + " getTail()'s"), (boolean)ontList.isEmpty());
        }
    }

    protected static class HeadTest
    extends ListTest {
        public HeadTest() {
            super("HeadTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list5.rdf");
            OntList ontList = this.getListRoot(ontModel);
            String[] stringArray = new String[]{"a", "b", "c", "d", "e"};
            int n = 0;
            while (n < stringArray.length) {
                Assert.assertEquals((String)"head of list has incorrect URI", (Object)(TestList.NS + stringArray[n]), (Object)((Resource)ontList.getHead()).getURI());
                ontList = ontList.getTail();
                ++n;
            }
        }
    }

    protected static class ValidityTest
    extends ListTest {
        public ValidityTest() {
            super("ValidityTest");
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            Resource resource = ontModel.createResource("uri:urn:x-rdf:test#root");
            Property property = ontModel.createProperty(TestList.NS, "p");
            Resource resource2 = OntListImpl.RDF_LIST_VOCAB.getNil();
            ontModel.add(resource, property, resource2);
            OntList ontList = this.getListRoot(ontModel);
            this.checkValid("valid1", ontList, true);
            Resource resource3 = ontModel.createResource();
            ontModel.getProperty(resource, property).remove();
            ontModel.add(resource, property, resource3);
            ontModel.setStrictMode(false);
            OntList ontList2 = this.getListRoot(ontModel);
            this.checkValid("valid2", ontList2, false);
            ontModel.add(resource3, RDF.type, RDF.List);
            this.checkValid("valid3", ontList2, false);
            ontModel.add(resource3, RDF.first, "fred");
            this.checkValid("valid4", ontList2, false);
            ontModel.add(resource3, RDF.rest, resource2);
            this.checkValid("valid5", ontList2, true);
        }
    }

    protected static class CountTest
    extends ListTest {
        protected int i;

        public CountTest(int n) {
            super("CountTest");
            this.i = n;
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel("http://www.w3.org/2002/07/owl#");
            ontModel.read("file:testing/ontology/list" + this.i + ".rdf");
            OntList ontList = this.getListRoot(ontModel);
            Assert.assertEquals((String)("List size should be " + this.i), (int)this.i, (int)ontList.size());
        }
    }

    protected static class ListTest
    extends TestCase {
        public ListTest(String string) {
            super(string);
        }

        protected void checkValid(String string, OntList ontList, boolean bl) {
            ontList.setStrict(true);
            boolean bl2 = ontList.isValid();
            Assert.assertEquals((String)("Validity test " + string + " returned wrong isValid() result"), (boolean)bl, (boolean)bl2);
        }

        protected OntList getListRoot(Model model) {
            Resource resource = model.getResource("uri:urn:x-rdf:test#root");
            Assert.assertNotNull((String)"Root resource should not be null", (Object)resource);
            Resource resource2 = resource.getProperty(model.getProperty("uri:urn:x-rdf:test#p")).getResource();
            OntList ontList = (OntList)resource2.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = TestList.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
            Assert.assertNotNull((String)"as(OntList) should not return null for root", (Object)ontList);
            return ontList;
        }
    }
}

