/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.Axiom;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCreate
extends TestCase {
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";
    protected static CreateTestCase[] testCases = new CreateTestCase[]{new CreateTestCase("OWL create ontology", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createOntology(TestCreate.BASE);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Ontology;
        }
    }, new CreateTestCase("DAML create ontology", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createOntology(TestCreate.BASE);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Ontology;
        }
    }, new CreateTestCase("OWL create class", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("OWL create anon class", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass();
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("DAML create class", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("DAML create anon class", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createClass();
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof OntClass;
        }
    }, new CreateTestCase("OWL create individual", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#a"){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual(ontClass, "http://jena.hpl.hp.com/testing/ontology#a");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("OWL create anon individual", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual(ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("DAML create individual", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#a"){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual(ontClass, "http://jena.hpl.hp.com/testing/ontology#a");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("DAML create anon individual", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            OntClass ontClass = ontModel.createClass("http://jena.hpl.hp.com/testing/ontology#C");
            return ontModel.createIndividual(ontClass);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Individual;
        }
    }, new CreateTestCase("OWL create object property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty;
        }
    }, new CreateTestCase("OWL create datatype property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty;
        }
    }, new CreateTestCase("OWL create annotation property", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createAnnotationProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof AnnotationProperty;
        }
    }, new CreateTestCase("DAML create object property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createObjectProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof ObjectProperty;
        }
    }, new CreateTestCase("DAML create datatype property", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#p"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createDatatypeProperty("http://jena.hpl.hp.com/testing/ontology#p");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof DatatypeProperty;
        }
    }, new CreateTestCase("OWL create axiom", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createAxiom(OWL.AllDifferent, null);
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Axiom;
        }
    }, new CreateTestCase("OWL create restriction", "http://www.w3.org/2002/07/owl#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }, new CreateTestCase("OWL create anon restriction", "http://www.w3.org/2002/07/owl#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction();
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }, new CreateTestCase("DAML create restriction", "http://www.daml.org/2001/03/daml+oil#", "http://jena.hpl.hp.com/testing/ontology#C"){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction("http://jena.hpl.hp.com/testing/ontology#C");
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }, new CreateTestCase("DAML create anon restriction", "http://www.daml.org/2001/03/daml+oil#", null){

        public OntResource doCreate(OntModel ontModel) {
            return ontModel.createRestriction();
        }

        public boolean test(OntResource ontResource) {
            return ontResource instanceof Restriction;
        }
    }};

    public TestCreate(String string) {
        super(string);
    }

    protected String getTestName() {
        return "TestCreate";
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestCreate");
        int n = 0;
        while (n < testCases.length) {
            testSuite.addTest((Test)testCases[n]);
            ++n;
        }
        return testSuite;
    }

    protected static class CreateTestCase
    extends TestCase {
        protected String m_lang;
        protected String m_uri;

        public CreateTestCase(String string, String string2, String string3) {
            super(string);
            this.m_lang = string2;
            this.m_uri = string3;
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel(this.m_lang);
            OntResource ontResource = this.doCreate(ontModel);
            Assert.assertNotNull((String)"Result of creation step should not be null", (Object)ontResource);
            if (this.m_uri == null) {
                Assert.assertTrue((String)"Created resource should be anonymous", (boolean)ontResource.isAnon());
            } else {
                Assert.assertEquals((String)"Created resource has wrong uri", (Object)this.m_uri, (Object)ontResource.getURI());
            }
            Assert.assertTrue((String)"Result test failed", (boolean)this.test(ontResource));
        }

        public OntResource doCreate(OntModel ontModel) {
            throw new RuntimeException("This method should be overridden");
        }

        public boolean test(OntResource ontResource) {
            return true;
        }
    }
}

