/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.path.PathExpr;
import com.hp.hpl.jena.ontology.path.PathSet;
import com.hp.hpl.jena.ontology.path.impl.NamedUnitPathExpr;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class OntTestCase
extends TestCase {
    public static final Boolean T = Boolean.TRUE;
    public static final Boolean F = Boolean.FALSE;
    public static final String BASE = "http://jena.hpl.hp.com/testing/ontology";
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";

    public OntTestCase(String string) {
        super(string);
    }

    protected TestSuite getSuite() {
        TestSuite testSuite = new TestSuite(this.getTestName());
        Object[][] objectArray = this.testData();
        int n = 0;
        while (n < objectArray.length) {
            testSuite.addTest((Test)new OntologyPropertyTest(objectArray[n]));
            ++n;
        }
        return testSuite;
    }

    protected abstract String getTestName();

    protected abstract Object[][] testData();

    public static interface PS {
        public PathSet ps(OntModel var1);
    }

    public static class OntologyPropertyTest
    extends TestCase {
        protected PS m_ps;
        protected Property m_property;
        protected String m_profileURI;
        protected String m_source;
        protected boolean m_inProfile;
        protected int m_count;
        protected String m_resourceValURI;
        protected Object m_literalVal;
        protected OntModel m_model;
        protected Resource m_resourceType;

        public OntologyPropertyTest(Object[] objectArray) {
            super((String)objectArray[0]);
            this.m_ps = (PS)objectArray[1];
            this.m_property = (Property)objectArray[2];
            this.m_profileURI = (String)objectArray[3];
            this.m_source = (String)objectArray[4];
            this.m_inProfile = (Boolean)objectArray[5];
            this.m_count = objectArray[6] == null ? 0 : (Integer)objectArray[6];
            this.m_resourceValURI = (String)objectArray[7];
            this.m_resourceType = (Resource)objectArray[8];
            this.m_literalVal = objectArray[9];
        }

        public void setUp() {
            OntDocumentManager.getInstance().setProcessImports(false);
            this.m_model = ModelFactory.createOntologyModel(this.m_profileURI);
            this.m_model.read(this.m_source);
        }

        public void tearDown() {
        }

        public void runTest() {
            PathSet pathSet;
            try {
                pathSet = this.m_ps.ps(this.m_model);
            }
            catch (OntologyException ontologyException) {
                pathSet = null;
            }
            Assert.assertEquals((String)("property should " + (this.m_inProfile ? " " : "not ") + "be in language profile"), (boolean)this.m_inProfile, (pathSet != null ? 1 : 0) != 0);
            if (this.m_inProfile) {
                PathExpr pathExpr = pathSet.getExpression();
                Assert.assertEquals((String)"Property named in path expression not correct", (Object)this.m_property, (Object)((NamedUnitPathExpr)pathExpr).getProperty());
                Assert.assertEquals((String)("Property set size for " + this.m_property + " not correct"), (int)this.m_count, (int)pathSet.size());
                if (this.m_resourceValURI != null) {
                    Assert.assertTrue((String)("Property value for " + this.m_property + " should be a resource"), (boolean)(pathSet.getValue() instanceof Resource));
                    Assert.assertEquals((String)("Property value for " + this.m_property + " not correct"), (Object)this.m_model.getResource(this.m_resourceValURI), (Object)pathSet.getValue());
                } else if (this.m_resourceType != null) {
                    Assert.assertTrue((String)("Property value for " + this.m_property + " should be a resource"), (boolean)(pathSet.getValue() instanceof Resource));
                    Assert.assertEquals((String)("Property value for " + this.m_property + " has wrong type"), (Object)this.m_resourceType, (Object)((Resource)pathSet.getValue()).getProperty(RDF.type).getResource());
                } else if (this.m_literalVal != null) {
                    RDFNode rDFNode = pathSet.getValue();
                    Assert.assertTrue((String)("Property value for " + this.m_property + " should be a literal"), (boolean)(rDFNode instanceof Literal));
                    Assert.assertTrue((String)("Property value for " + this.m_property + " failed equality test"), (boolean)((Literal)rDFNode).getValue().equals(this.m_literalVal));
                }
            }
        }
    }
}

