/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.NoSuchTripleException;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.VirtualTripleException;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class OntologyGraph
implements Graph {
    protected MultiUnion m_unionGraph = new MultiUnion();
    protected InfGraph m_inf;
    protected Reasoner m_reasoner = TransitiveReasonerFactory.theInstance().create(null);

    public boolean mightContain(Graph graph) {
        return this.m_unionGraph.mightContain(graph);
    }

    public QueryHandler queryHandler() {
        return this.m_inf != null ? this.m_inf.queryHandler() : this.m_unionGraph.queryHandler();
    }

    public Reifier getReifier() {
        return this.m_unionGraph.getReifier();
    }

    public void add(Triple triple) throws UnsupportedOperationException, VirtualTripleException {
        this.m_unionGraph.add(triple);
    }

    public void delete(Triple triple) throws UnsupportedOperationException, NoSuchTripleException, VirtualTripleException {
        this.m_unionGraph.delete(triple);
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.m_inf != null ? this.m_inf.find(tripleMatch) : this.m_unionGraph.find(tripleMatch);
    }

    public ExtendedIterator find(Node node, Node node2, Node node3) {
        return this.m_inf != null ? this.m_inf.find(node, node2, node3) : this.m_unionGraph.find(node, node2, node3);
    }

    public boolean isIsomorphicWith(Graph graph) {
        return this.m_inf != null ? this.m_inf.isIsomorphicWith(graph) : this.m_unionGraph.isIsomorphicWith(graph);
    }

    public boolean contains(Node node, Node node2, Node node3) {
        return this.m_inf != null ? this.m_inf.contains(node, node2, node3) : this.m_unionGraph.contains(node, node2, node3);
    }

    public boolean contains(Triple triple) {
        return this.m_inf != null ? this.m_inf.contains(triple) : this.m_unionGraph.contains(triple);
    }

    public void close() {
        this.m_unionGraph.close();
    }

    public int size() throws UnsupportedOperationException {
        return this.m_unionGraph.size();
    }

    public int capabilities() {
        return this.m_inf != null ? this.m_inf.capabilities() : this.m_unionGraph.capabilities();
    }

    public MultiUnion getUnion() {
        return this.m_unionGraph;
    }

    public InfGraph getInf() {
        return this.m_inf;
    }

    public void bind() {
        this.m_inf = this.m_reasoner.bind(this.m_unionGraph);
    }
}

