/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphFactory;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.Axiom;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntReadState;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.impl.OntologyGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OntModelImpl
extends ModelCom
implements OntModel {
    protected OntDocumentManager m_docMgr;
    protected GraphFactory m_graphFactory;
    protected Profile m_profile;
    protected Set m_imported = new HashSet();
    protected BindingQueryPlan m_individualsQuery;
    protected List m_individualsQueryAlias = null;
    protected boolean m_strictMode = true;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Ontology;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DatatypeProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Individual;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Axiom;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ClassDescription;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AnnotationProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;

    public OntModelImpl(String string, Model model, OntDocumentManager ontDocumentManager, GraphFactory graphFactory) {
        super(new OntologyGraph(), BuiltinPersonalities.model);
        Profile profile = ProfileRegistry.getInstance().getProfile(string);
        if (profile == null) {
            throw new OntologyException("Ontology model could not locate language profile for ontology language " + string);
        }
        this.getUnionGraph().addGraph(model.getGraph());
        this.m_profile = profile;
        this.m_docMgr = ontDocumentManager;
        this.m_graphFactory = graphFactory;
        this.m_individualsQuery = this.queryXTypeOfType(profile.CLASS());
        if (profile.hasAliasFor(profile.CLASS())) {
            this.m_individualsQueryAlias = new ArrayList();
            Iterator iterator = profile.listAliasesFor(profile.CLASS());
            while (iterator.hasNext()) {
                this.m_individualsQueryAlias.add(this.queryXTypeOfType((Resource)iterator.next()));
            }
        }
        this.m_docMgr.loadImports(this, new OntReadState(null, this));
        ((OntologyGraph)this.graph).bind();
    }

    public OntDocumentManager getDocumentManager() {
        return this.m_docMgr;
    }

    public Iterator listOntologies() {
        return this.findByTypeAs(this.getProfile().ONTOLOGY(), class$com$hp$hpl$jena$ontology$Ontology == null ? (class$com$hp$hpl$jena$ontology$Ontology = OntModelImpl.class$("com.hp.hpl.jena.ontology.Ontology")) : class$com$hp$hpl$jena$ontology$Ontology);
    }

    public Iterator listOntProperties() {
        return this.findByTypeAs(RDF.Property, class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
    }

    public Iterator listObjectProperties() {
        return this.findByTypeAs(this.getProfile().OBJECT_PROPERTY(), class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty);
    }

    public Iterator listDatatypeProperties() {
        return this.findByTypeAs(this.getProfile().DATATYPE_PROPERTY(), class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty);
    }

    public Iterator listIndividuals() {
        return this.queryFor(this.m_individualsQuery, this.m_individualsQueryAlias, class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = OntModelImpl.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual);
    }

    public Iterator listAxioms() {
        ArrayList<BindingQueryPlan> arrayList = new ArrayList<BindingQueryPlan>();
        Iterator iterator = this.getProfile().getAxiomTypes();
        if (iterator.hasNext()) {
            Object object;
            while (iterator.hasNext()) {
                object = new Query();
                ((Query)object).addMatch(Query.X, RDF.type.asNode(), ((Resource)iterator.next()).asNode());
                arrayList.add(this.queryHandler().prepareBindings((Query)object, new Node[]{Query.X}));
            }
            object = (BindingQueryPlan)arrayList.remove(0);
            return this.queryFor((BindingQueryPlan)object, arrayList, class$com$hp$hpl$jena$ontology$Axiom == null ? (class$com$hp$hpl$jena$ontology$Axiom = OntModelImpl.class$("com.hp.hpl.jena.ontology.Axiom")) : class$com$hp$hpl$jena$ontology$Axiom);
        }
        return iterator;
    }

    public Iterator listClasses() {
        return this.findByTypeAs(this.getProfile().getClassDescriptionTypes(), class$com$hp$hpl$jena$ontology$ClassDescription == null ? (class$com$hp$hpl$jena$ontology$ClassDescription = OntModelImpl.class$("com.hp.hpl.jena.ontology.ClassDescription")) : class$com$hp$hpl$jena$ontology$ClassDescription);
    }

    public Iterator listEnumeratedClasses() {
        return this.findByDefiningPropertyAs(this.getProfile().ONE_OF(), class$com$hp$hpl$jena$ontology$ClassDescription == null ? (class$com$hp$hpl$jena$ontology$ClassDescription = OntModelImpl.class$("com.hp.hpl.jena.ontology.ClassDescription")) : class$com$hp$hpl$jena$ontology$ClassDescription);
    }

    public Iterator listUnionClasses() {
        return this.findByDefiningPropertyAs(this.getProfile().UNION_OF(), class$com$hp$hpl$jena$ontology$ClassDescription == null ? (class$com$hp$hpl$jena$ontology$ClassDescription = OntModelImpl.class$("com.hp.hpl.jena.ontology.ClassDescription")) : class$com$hp$hpl$jena$ontology$ClassDescription);
    }

    public Iterator listComplementClasses() {
        return this.findByDefiningPropertyAs(this.getProfile().COMPLEMENT_OF(), class$com$hp$hpl$jena$ontology$ClassDescription == null ? (class$com$hp$hpl$jena$ontology$ClassDescription = OntModelImpl.class$("com.hp.hpl.jena.ontology.ClassDescription")) : class$com$hp$hpl$jena$ontology$ClassDescription);
    }

    public Iterator listIntersectionClasses() {
        return this.findByDefiningPropertyAs(this.getProfile().INTERSECTION_OF(), class$com$hp$hpl$jena$ontology$ClassDescription == null ? (class$com$hp$hpl$jena$ontology$ClassDescription = OntModelImpl.class$("com.hp.hpl.jena.ontology.ClassDescription")) : class$com$hp$hpl$jena$ontology$ClassDescription);
    }

    public Iterator listNamedClasses() {
        return ((ExtendedIterator)this.listClasses()).filterDrop(new Filter(){

            public boolean accept(Object object) {
                return ((Resource)object).isAnon();
            }
        });
    }

    public Iterator listRestrictions() {
        return this.findByTypeAs(this.getProfile().RESTRICTION(), class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction);
    }

    public Iterator listAnnotationProperties() {
        return this.findByType(this.getProfile().ANNOTATION_PROPERTY()).andThen(WrappedIterator.create(this.getProfile().getAnnotationProperties())).mapWith(new SubjectNodeAs(class$com$hp$hpl$jena$ontology$AnnotationProperty == null ? (class$com$hp$hpl$jena$ontology$AnnotationProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.AnnotationProperty")) : class$com$hp$hpl$jena$ontology$AnnotationProperty));
    }

    public Ontology createOntology(String string) {
        return (Ontology)this.createOntResource(class$com$hp$hpl$jena$ontology$Ontology == null ? (class$com$hp$hpl$jena$ontology$Ontology = OntModelImpl.class$("com.hp.hpl.jena.ontology.Ontology")) : class$com$hp$hpl$jena$ontology$Ontology, this.getProfile().ONTOLOGY(), string);
    }

    public Individual createIndividual(OntClass ontClass) {
        return (Individual)this.createOntResource(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = OntModelImpl.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual, ontClass, null);
    }

    public Individual createIndividual(OntClass ontClass, String string) {
        return (Individual)this.createOntResource(class$com$hp$hpl$jena$ontology$Individual == null ? (class$com$hp$hpl$jena$ontology$Individual = OntModelImpl.class$("com.hp.hpl.jena.ontology.Individual")) : class$com$hp$hpl$jena$ontology$Individual, ontClass, string);
    }

    public ObjectProperty createObjectProperty(String string) {
        return (ObjectProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty, this.getProfile().OBJECT_PROPERTY(), string);
    }

    public DatatypeProperty createDatatypeProperty(String string) {
        return (DatatypeProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty, this.getProfile().DATATYPE_PROPERTY(), string);
    }

    public AnnotationProperty createAnnotationProperty(String string) {
        return (AnnotationProperty)this.createOntResource(class$com$hp$hpl$jena$ontology$AnnotationProperty == null ? (class$com$hp$hpl$jena$ontology$AnnotationProperty = OntModelImpl.class$("com.hp.hpl.jena.ontology.AnnotationProperty")) : class$com$hp$hpl$jena$ontology$AnnotationProperty, this.getProfile().ANNOTATION_PROPERTY(), string);
    }

    public Axiom createAxiom(Resource resource, String string) {
        return (Axiom)this.createOntResource(class$com$hp$hpl$jena$ontology$Axiom == null ? (class$com$hp$hpl$jena$ontology$Axiom = OntModelImpl.class$("com.hp.hpl.jena.ontology.Axiom")) : class$com$hp$hpl$jena$ontology$Axiom, resource, string);
    }

    public OntClass createClass() {
        return (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), null);
    }

    public OntClass createClass(String string) {
        return (OntClass)this.createOntResource(class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntModelImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, this.getProfile().CLASS(), string);
    }

    public Restriction createRestriction() {
        return (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), null);
    }

    public Restriction createRestriction(String string) {
        return (Restriction)this.createOntResource(class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OntModelImpl.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, this.getProfile().RESTRICTION(), string);
    }

    public OntResource createOntResource(Class clazz, Resource resource, String string) {
        return (OntResource)this.getResourceWithType(string, resource).as(clazz);
    }

    public Profile getProfile() {
        return this.m_profile;
    }

    public boolean hasLoadedImport(String string) {
        return this.m_imported.contains(string);
    }

    public void addLoadedImport(String string) {
        this.m_imported.add(string);
    }

    public List listImportedOntologyURIs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StmtIterator stmtIterator = this.listStatements(null, RDF.type, this.m_profile.ONTOLOGY());
        while (stmtIterator.hasNext()) {
            Resource resource = stmtIterator.nextStatement().getSubject();
            StmtIterator stmtIterator2 = resource.listProperties(this.m_profile.IMPORTS());
            while (stmtIterator2.hasNext()) {
                arrayList.add(stmtIterator2.nextStatement().getResource().getURI());
            }
        }
        return arrayList;
    }

    public GraphFactory getGraphFactory() {
        return this.m_graphFactory;
    }

    public Model read(String string) {
        super.read(this.m_docMgr.getCacheURL(string));
        this.m_docMgr.addGraph(string, this.getGraph());
        this.m_docMgr.loadImports(this, new OntReadState(null, this));
        ((OntologyGraph)this.graph).bind();
        return this;
    }

    public Model read(Reader reader, String string) {
        super.read(reader, string);
        this.m_docMgr.loadImports(this, new OntReadState(null, this));
        ((OntologyGraph)this.graph).bind();
        return this;
    }

    public Model read(InputStream inputStream, String string) {
        super.read(inputStream, string);
        this.m_docMgr.loadImports(this, new OntReadState(null, this));
        ((OntologyGraph)this.graph).bind();
        return this;
    }

    public Model read(String string, String string2) {
        super.read(this.m_docMgr.getCacheURL(string), string2);
        this.m_docMgr.addGraph(string, this.getGraph());
        this.m_docMgr.loadImports(this, new OntReadState(string2, this));
        ((OntologyGraph)this.graph).bind();
        return this;
    }

    public Model read(Reader reader, String string, String string2) {
        super.read(reader, string, string2);
        this.m_docMgr.loadImports(this, new OntReadState(string2, this));
        ((OntologyGraph)this.graph).bind();
        return this;
    }

    public Model read(InputStream inputStream, String string, String string2) {
        super.read(inputStream, string, string2);
        this.m_docMgr.loadImports(this, new OntReadState(string2, this));
        ((OntologyGraph)this.graph).bind();
        return this;
    }

    public void read(String string, OntReadState ontReadState) {
        super.read(this.m_docMgr.getCacheURL(string), ontReadState.getSyntax());
        this.m_docMgr.addGraph(string, this.getGraph());
        this.m_docMgr.loadImports(this, ontReadState);
    }

    public List getSubGraphs() {
        return ((MultiUnion)this.getGraph()).getSubGraphs();
    }

    public Graph getBaseGraph() {
        return ((MultiUnion)this.getGraph()).getBaseGraph();
    }

    public Model getBaseModel() {
        return ModelFactory.createModelForGraph(this.getBaseGraph());
    }

    public void addSubGraph(Graph graph) {
        this.getUnionGraph().addGraph(graph);
    }

    public boolean strictMode() {
        return this.m_strictMode;
    }

    public void setStrictMode(boolean bl) {
        this.m_strictMode = bl;
    }

    protected MultiUnion getUnionGraph() {
        return ((OntologyGraph)this.graph).getUnion();
    }

    protected ExtendedIterator findByType(Resource resource) {
        return this.getGraph().find(null, RDF.type.asNode(), resource.asNode());
    }

    protected ExtendedIterator findByType(Resource resource, Iterator iterator) {
        ExtendedIterator extendedIterator = this.findByType(resource);
        if (iterator != null) {
            while (iterator.hasNext()) {
                extendedIterator = extendedIterator.andThen(this.findByType((Resource)iterator.next()));
            }
        }
        return extendedIterator;
    }

    protected ExtendedIterator findByType(Resource resource, boolean bl) {
        return this.findByType(resource, bl ? this.getProfile().listAliasesFor(resource) : null);
    }

    protected ExtendedIterator findByTypeAs(Resource resource, Iterator iterator, Class clazz) {
        return this.findByType(resource, iterator).mapWith(new SubjectNodeAs(clazz));
    }

    protected ExtendedIterator findByTypeAs(Iterator iterator, Class clazz) {
        return this.findByTypeAs((Resource)iterator.next(), iterator, clazz);
    }

    protected ExtendedIterator findByTypeAs(Resource resource, Class clazz) {
        return this.findByType(resource, true).mapWith(new SubjectNodeAs(clazz));
    }

    protected ExtendedIterator queryFor(BindingQueryPlan bindingQueryPlan, List list, Class clazz) {
        GetBinding getBinding = new GetBinding(0);
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings().mapWith(getBinding);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtendedIterator extendedIterator2 = ((BindingQueryPlan)iterator.next()).executeBindings().mapWith(getBinding);
                extendedIterator = extendedIterator.andThen(extendedIterator2);
            }
        }
        return extendedIterator.mapWith(new SubjectNodeAs(clazz));
    }

    protected BindingQueryPlan queryXTypeOfType(Resource resource) {
        Query query = new Query();
        query.addMatch(Query.X, RDF.type.asNode(), Query.Y);
        query.addMatch(Query.Y, RDF.type.asNode(), resource.asNode());
        return this.queryHandler().prepareBindings(query, new Node[]{Query.X});
    }

    protected ExtendedIterator findByDefiningProperty(Property property) {
        return this.getGraph().find(null, property.getNode(), null);
    }

    protected ExtendedIterator findByDefiningPropertyAs(Property property, Class clazz) {
        return this.findByDefiningProperty(property).mapWith(new SubjectNodeAs(clazz));
    }

    protected Resource getResourceWithType(String string, Resource resource) {
        return this.getResource(string).addProperty(RDF.type, resource);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class GetBinding
    implements Map1 {
        protected int m_index;

        protected GetBinding(int n) {
            this.m_index = n;
        }

        public Object map1(Object object) {
            return ((List)object).get(this.m_index);
        }
    }

    protected class SubjectNodeAs
    implements Map1 {
        protected Class m_asKey;

        protected SubjectNodeAs(Class clazz) {
            this.m_asKey = clazz;
        }

        public Object map1(Object object) {
            Node node = object instanceof Triple ? ((Triple)object).getSubject() : (object instanceof EnhNode ? ((EnhNode)object).asNode() : (Node)object);
            return OntModelImpl.this.getNodeAs(node, this.m_asKey);
        }
    }
}

