/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.EmptyListException;
import com.hp.hpl.jena.ontology.InvalidListException;
import com.hp.hpl.jena.ontology.ListIndexException;
import com.hp.hpl.jena.ontology.OntList;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OntListImpl
extends OntResourceImpl
implements OntList {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new OntListImpl(node, enhGraph);
            }
            throw new OntologyException("Cannot convert node " + node + " to OntList");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Profile profile;
            Profile profile2 = profile = enhGraph instanceof OntModel ? ((OntModel)((Object)enhGraph)).getProfile() : null;
            return profile != null && profile.isSupported(node, enhGraph, class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = OntListImpl.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
        }
    };
    public static final OntList.Vocabulary RDF_LIST_VOCAB = new OntList.Vocabulary(){

        public Resource getNil() {
            return RDF.nil;
        }

        public Property getHead() {
            return RDF.first;
        }

        public Property getTail() {
            return RDF.rest;
        }

        public Resource getCellType() {
            return RDF.List;
        }
    };
    protected boolean m_checkValid = false;
    protected String m_errorMsg = null;
    protected OntList m_tail = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntList;

    public OntListImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public int size() {
        if (this.m_checkValid) {
            this.checkValid();
        }
        int n = 0;
        ClosableIterator closableIterator = this.iterator();
        while (closableIterator.hasNext()) {
            ++n;
            closableIterator.next();
        }
        return n;
    }

    public RDFNode getHead() {
        if (this.m_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the head of an empty list");
        return this.getProperty(this.getVocabulary().getHead()).getObject();
    }

    public RDFNode setHead(RDFNode rDFNode) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the head of an empty list");
        Statement statement = this.getProperty(this.getVocabulary().getHead());
        RDFNode rDFNode2 = statement.getObject();
        statement.remove();
        this.addProperty(this.getVocabulary().getHead(), rDFNode);
        return rDFNode2;
    }

    public OntList getTail() {
        if (this.m_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the tail of an empty list");
        Resource resource = this.getProperty(this.getVocabulary().getTail()).getResource();
        return (OntList)resource.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = OntListImpl.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
    }

    public OntList setTail(OntList ontList) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to set the tail of an empty list");
        return (OntList)OntListImpl.setTailAux(this, ontList, this.getVocabulary().getTail()).as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = OntListImpl.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
    }

    public boolean isEmpty() {
        if (this.m_checkValid) {
            this.checkValid();
        }
        return this.equals(this.getVocabulary().getNil());
    }

    public OntList.Vocabulary getVocabulary() {
        return RDF_LIST_VOCAB;
    }

    public OntList cons(RDFNode rDFNode) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        return (OntList)this.newListCell(rDFNode, this).as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = OntListImpl.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
    }

    public OntList add(RDFNode rDFNode) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return this.cons(rDFNode);
        }
        OntList ontList = this.findElement(true, 0);
        OntListImpl.setTailAux(ontList, this.newListCell(rDFNode, this.getVocabulary().getNil()), this.getVocabulary().getTail());
        return this;
    }

    public RDFNode get(int n) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get an element from the empty list");
        return this.findElement(false, n).getHead();
    }

    public RDFNode replace(int n, RDFNode rDFNode) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to replace a value in the empty list");
        return this.findElement(false, n).setHead(rDFNode);
    }

    public boolean contains(RDFNode rDFNode) {
        return this.indexOf(rDFNode, 0) >= 0;
    }

    public int indexOf(RDFNode rDFNode) {
        return this.indexOf(rDFNode, 0);
    }

    public int indexOf(RDFNode rDFNode, int n) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        Resource resource = this.findElement(false, n);
        int n2 = n;
        Property property = this.getVocabulary().getHead();
        Property property2 = this.getVocabulary().getTail();
        Resource resource2 = this.getVocabulary().getNil();
        boolean bl = resource.hasProperty(property, rDFNode);
        while (!bl && !resource.equals(resource2)) {
            resource = resource.getProperty(property2).getResource();
            ++n2;
            bl = resource.hasProperty(property, rDFNode);
        }
        return bl ? n2 : -1;
    }

    public OntList append(OntList ontList) {
        if (this.m_checkValid) {
            this.checkValid();
            if (!ontList.getValidityErrorMessage().equals(this.getVocabulary())) {
                throw new IllegalArgumentException("Cannot append two lists that have different vocabularies");
            }
        }
        if (this.isEmpty()) {
            return ontList;
        }
        return this.copy(this.iterator()).concatenate(ontList);
    }

    public OntList concatenate(OntList ontList) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return ontList;
        }
        this.findElement(true, 0).setTail(ontList);
        return this;
    }

    public OntList concatenate(Iterator iterator) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        return this.concatenate(this.copy(iterator));
    }

    public OntList copy() {
        if (this.m_checkValid) {
            this.checkValid();
        }
        return this.copy(this.iterator());
    }

    public void apply(OntList.ApplyFn applyFn) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        ClosableIterator closableIterator = this.iterator();
        while (closableIterator.hasNext()) {
            applyFn.apply((RDFNode)closableIterator.next());
        }
    }

    public Object reduce(OntList.ReduceFn reduceFn, Object object) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        Object object2 = object;
        ClosableIterator closableIterator = this.iterator();
        while (closableIterator.hasNext()) {
            object2 = reduceFn.reduce((RDFNode)closableIterator.next(), object2);
        }
        return object2;
    }

    public OntList removeHead() {
        if (this.m_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Attempted to delete the head of a nil list");
        OntList ontList = this.getTail();
        this.removeProperties();
        return ontList;
    }

    public void removeAll() {
        OntList ontList = this;
        while (!ontList.isEmpty()) {
            ontList = ontList.removeHead();
        }
    }

    public ClosableIterator iterator() {
        return new OntListIterator(this);
    }

    public List asJavaList() {
        ArrayList arrayList = new ArrayList();
        ClosableIterator closableIterator = this.iterator();
        while (closableIterator.hasNext()) {
            arrayList.add(closableIterator.next());
        }
        return arrayList;
    }

    public boolean sameListAs(OntList ontList) {
        if (this.m_checkValid) {
            this.checkValid();
        }
        Resource resource = this;
        Resource resource2 = ontList;
        Property property = this.getVocabulary().getHead();
        Property property2 = this.getVocabulary().getTail();
        Resource resource3 = this.getVocabulary().getNil();
        while (!resource.equals(resource3) && !resource2.equals(resource3)) {
            RDFNode rDFNode = resource.getProperty(property).getObject();
            RDFNode rDFNode2 = resource2.getProperty(property).getObject();
            if (rDFNode == null || !rDFNode.equals(rDFNode2)) {
                return false;
            }
            resource = resource.getProperty(property2).getResource();
            resource2 = resource2.getProperty(property2).getResource();
        }
        return resource.equals(resource3) && resource2.equals(resource3);
    }

    public boolean isStrict() {
        return this.m_checkValid;
    }

    public void setStrict(boolean bl) {
        this.m_checkValid = bl;
    }

    public boolean isValid() {
        this.m_errorMsg = null;
        try {
            this.checkValid();
        }
        catch (InvalidListException invalidListException) {
            this.m_errorMsg = invalidListException.getMessage();
        }
        return this.m_errorMsg == null;
    }

    public String getValidityErrorMessage() {
        return this.m_errorMsg;
    }

    public Resource newListCell(RDFNode rDFNode, Resource resource) {
        Resource resource2 = this.getModel().createResource(this.getVocabulary().getCellType());
        resource2.addProperty(this.getVocabulary().getHead(), rDFNode);
        resource2.addProperty(this.getVocabulary().getTail(), resource);
        return resource2;
    }

    protected void checkValid() {
        OntList.Vocabulary vocabulary = this.getVocabulary();
        if (!this.equals(vocabulary.getNil())) {
            this.checkValidProperty(RDF.type, vocabulary.getCellType());
            this.checkValidProperty(vocabulary.getHead(), null);
            this.checkValidProperty(vocabulary.getTail(), null);
        }
    }

    private void checkValidProperty(Property property, RDFNode rDFNode) {
        int n = 0;
        StmtIterator stmtIterator = this.getModel().listStatements(new SimpleSelector((Resource)this, property, rDFNode));
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        if (n == 0) {
            throw new InvalidListException("List node " + this.toString() + " is not valid: it should have property " + property.toString() + (rDFNode == null ? "" : " with value " + rDFNode));
        }
        if (n > 1) {
            throw new InvalidListException("List node " + this.toString() + " is not valid: it has more than one value for " + property.toString());
        }
    }

    protected void checkNotNil(String string) {
        if (this.isEmpty()) {
            throw new EmptyListException(string);
        }
    }

    protected OntList findElement(boolean bl, int n) {
        Property property = this.getVocabulary().getTail();
        Resource resource = this.getVocabulary().getNil();
        Resource resource2 = this;
        int n2 = n;
        boolean bl2 = bl && resource2.hasProperty(property, resource) || !bl && n2 == 0;
        while (!bl2 && !resource2.equals(resource)) {
            resource2 = resource2.getProperty(property).getResource();
            boolean bl3 = bl2 = bl && resource2.hasProperty(property, resource) || !bl && --n2 == 0;
        }
        if (!bl2) {
            if (!bl) {
                throw new ListIndexException("Tried to access element " + n + " that is beyond the length of the list");
            }
            throw new InvalidListException("Could not find last element of list (suggests list is not valid)");
        }
        return (OntList)resource2.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = OntListImpl.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
    }

    protected OntList copy(Iterator iterator) {
        Resource resource = null;
        RDFNode rDFNode = null;
        Property property = this.getVocabulary().getHead();
        Property property2 = this.getVocabulary().getTail();
        Resource resource2 = this.getVocabulary().getCellType();
        while (iterator.hasNext()) {
            Resource resource3 = this.getModel().createResource(resource2);
            resource3.addProperty(property, (RDFNode)iterator.next());
            if (resource != null) {
                resource.addProperty(property2, resource3);
            } else {
                rDFNode = resource3;
            }
            resource = resource3;
        }
        resource.addProperty(property2, this.getVocabulary().getNil());
        return (OntList)rDFNode.as(class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = OntListImpl.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList);
    }

    protected static Resource setTailAux(Resource resource, Resource resource2, Property property) {
        Statement statement = resource.getProperty(property);
        Resource resource3 = statement.getResource();
        statement.remove();
        resource.addProperty(property, resource2);
        return resource3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class OntListIterator
    implements ClosableIterator {
        protected OntList m_head;
        protected OntList m_seen = null;

        protected OntListIterator(OntList ontList) {
            this.m_head = ontList;
        }

        public void close() {
        }

        public boolean hasNext() {
            return !this.m_head.isEmpty();
        }

        public Object next() {
            this.m_seen = this.m_head;
            this.m_head = this.m_head.getTail();
            return this.m_seen.getHead();
        }

        public void remove() {
            if (this.m_seen == null) {
                throw new IllegalStateException("Illegal remove from list operator");
            }
            this.m_seen.removeProperties();
            this.m_seen = null;
        }
    }
}

