/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class OWLProfile
extends AbstractProfile {
    private static Object[][] s_supportsCheckTable = new Object[][]{{class$com$hp$hpl$jena$ontology$AllDifferent == null ? (class$com$hp$hpl$jena$ontology$AllDifferent = OWLProfile.class$("com.hp.hpl.jena.ontology.AllDifferent")) : class$com$hp$hpl$jena$ontology$AllDifferent, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AllDifferent.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$AnnotationProperty == null ? (class$com$hp$hpl$jena$ontology$AnnotationProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.AnnotationProperty")) : class$com$hp$hpl$jena$ontology$AnnotationProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            Iterator iterator = ((OntModel)((Object)enhGraph)).getProfile().getAnnotationProperties();
            while (iterator.hasNext()) {
                if (!((Resource)iterator.next()).asNode().equals(node)) continue;
                return true;
            }
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$Axiom == null ? (class$com$hp$hpl$jena$ontology$Axiom = OWLProfile.class$("com.hp.hpl.jena.ontology.Axiom")) : class$com$hp$hpl$jena$ontology$Axiom, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            Iterator iterator = ((OntModel)((Object)enhGraph)).getProfile().getAxiomTypes();
            while (iterator.hasNext()) {
                if (!enhGraph.asGraph().contains(node, RDF.type.asNode(), ((Resource)iterator.next()).asNode())) continue;
                return true;
            }
            return false;
        }
    }}, {class$com$hp$hpl$jena$ontology$ClassDescription == null ? (class$com$hp$hpl$jena$ontology$ClassDescription = OWLProfile.class$("com.hp.hpl.jena.ontology.ClassDescription")) : class$com$hp$hpl$jena$ontology$ClassDescription, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Class.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$DatatypeProperty == null ? (class$com$hp$hpl$jena$ontology$DatatypeProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.DatatypeProperty")) : class$com$hp$hpl$jena$ontology$DatatypeProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.ObjectProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$FunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$FunctionalProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.FunctionalProperty")) : class$com$hp$hpl$jena$ontology$FunctionalProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.FunctionalProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$InverseFunctionalProperty == null ? (class$com$hp$hpl$jena$ontology$InverseFunctionalProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.InverseFunctionalProperty")) : class$com$hp$hpl$jena$ontology$InverseFunctionalProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$ObjectProperty == null ? (class$com$hp$hpl$jena$ontology$ObjectProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.ObjectProperty")) : class$com$hp$hpl$jena$ontology$ObjectProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.ObjectProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OWLProfile.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Class.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$OntList == null ? (class$com$hp$hpl$jena$ontology$OntList = OWLProfile.class$("com.hp.hpl.jena.ontology.OntList")) : class$com$hp$hpl$jena$ontology$OntList, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return node.equals(RDF.nil.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$Ontology == null ? (class$com$hp$hpl$jena$ontology$Ontology = OWLProfile.class$("com.hp.hpl.jena.ontology.Ontology")) : class$com$hp$hpl$jena$ontology$Ontology, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Ontology.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), RDF.Property.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.ObjectProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$Restriction == null ? (class$com$hp$hpl$jena$ontology$Restriction = OWLProfile.class$("com.hp.hpl.jena.ontology.Restriction")) : class$com$hp$hpl$jena$ontology$Restriction, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$SymmetricProperty == null ? (class$com$hp$hpl$jena$ontology$SymmetricProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.SymmetricProperty")) : class$com$hp$hpl$jena$ontology$SymmetricProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {class$com$hp$hpl$jena$ontology$TransitiveProperty == null ? (class$com$hp$hpl$jena$ontology$TransitiveProperty = OWLProfile.class$("com.hp.hpl.jena.ontology.TransitiveProperty")) : class$com$hp$hpl$jena$ontology$TransitiveProperty, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}};
    protected static HashMap s_supportsChecks = new HashMap();
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AllDifferent;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$AnnotationProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Axiom;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ClassDescription;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$DatatypeProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$ObjectProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$FunctionalProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$InverseFunctionalProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntClass;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntList;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Ontology;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$Restriction;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$SymmetricProperty;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$TransitiveProperty;

    public String NAMESPACE() {
        return "http://www.w3.org/2002/07/owl#";
    }

    public Resource CLASS() {
        return OWL.Class;
    }

    public Resource RESTRICTION() {
        return OWL.Restriction;
    }

    public Resource THING() {
        return OWL.Thing;
    }

    public Resource NOTHING() {
        return OWL.Nothing;
    }

    public Resource OBJECT_PROPERTY() {
        return OWL.ObjectProperty;
    }

    public Resource DATATYPE_PROPERTY() {
        return OWL.DatatypeProperty;
    }

    public Resource TRANSITIVE_PROPERTY() {
        return OWL.TransitiveProperty;
    }

    public Resource SYMMETRIC_PROPERTY() {
        return OWL.SymmetricProperty;
    }

    public Resource FUNCTIONAL_PROPERTY() {
        return OWL.FunctionalProperty;
    }

    public Resource INVERSE_FUNCTIONAL_PROPERTY() {
        return OWL.InverseFunctionalProperty;
    }

    public Resource ALL_DIFFERENT() {
        return OWL.AllDifferent;
    }

    public Resource ONTOLOGY() {
        return OWL.Ontology;
    }

    public Resource DEPRECATED_CLASS() {
        return OWL.DeprecatedClass;
    }

    public Resource DEPRECATED_PROPERTY() {
        return OWL.DeprecatedProperty;
    }

    public Resource ANNOTATION_PROPERTY() {
        return OWL.AnnotationProperty;
    }

    public Property EQUIVALENT_PROPERTY() {
        return OWL.equivalentProperty;
    }

    public Property EQUIVALENT_CLASS() {
        return OWL.equivalentClass;
    }

    public Property DISJOINT_WITH() {
        return OWL.disjointWith;
    }

    public Property SAME_INDIVIDUAL_AS() {
        return OWL.sameIndividualAs;
    }

    public Property SAME_AS() {
        return OWL.sameAs;
    }

    public Property DIFFERENT_FROM() {
        return OWL.differentFrom;
    }

    public Property DISTINCT_MEMBERS() {
        return OWL.distinctMembers;
    }

    public Property UNION_OF() {
        return OWL.unionOf;
    }

    public Property INTERSECTION_OF() {
        return OWL.intersectionOf;
    }

    public Property COMPLEMENT_OF() {
        return OWL.complementOf;
    }

    public Property ONE_OF() {
        return OWL.oneOf;
    }

    public Property ON_PROPERTY() {
        return OWL.onProperty;
    }

    public Property ALL_VALUES_FROM() {
        return OWL.allValuesFrom;
    }

    public Property HAS_VALUE() {
        return OWL.hasValue;
    }

    public Property SOME_VALUES_FROM() {
        return OWL.someValuesFrom;
    }

    public Property MIN_CARDINALITY() {
        return OWL.minCardinality;
    }

    public Property MAX_CARDINALITY() {
        return OWL.maxCardinality;
    }

    public Property CARDINALITY() {
        return OWL.cardinality;
    }

    public Property INVERSE_OF() {
        return OWL.inverseOf;
    }

    public Property IMPORTS() {
        return OWL.imports;
    }

    public Property PRIOR_VERSION() {
        return OWL.priorVersion;
    }

    public Property BACKWARD_COMPATIBLE_WITH() {
        return OWL.backwardCompatibleWith;
    }

    public Property INCOMPATIBLE_WITH() {
        return OWL.incompatibleWith;
    }

    public Property SUB_PROPERTY_OF() {
        return RDFS.subPropertyOf;
    }

    public Property SUB_CLASS_OF() {
        return RDFS.subClassOf;
    }

    public Property DOMAIN() {
        return RDFS.domain;
    }

    public Property RANGE() {
        return RDFS.range;
    }

    public Property VERSION_INFO() {
        return OWL.versionInfo;
    }

    public Property LABEL() {
        return RDFS.label;
    }

    public Property COMMENT() {
        return RDFS.comment;
    }

    public Property SEE_ALSO() {
        return RDFS.seeAlso;
    }

    public Property IS_DEFINED_BY() {
        return RDFS.isDefinedBy;
    }

    protected Resource[][] aliasTable() {
        return new Resource[][]{{OWL.sameAs, OWL.sameIndividualAs}};
    }

    public Iterator getAxiomTypes() {
        return Arrays.asList(OWL.AllDifferent).iterator();
    }

    public Iterator getAnnotationProperties() {
        return Arrays.asList(OWL.versionInfo, RDFS.label, RDFS.seeAlso, OWL.comment, RDFS.isDefinedBy).iterator();
    }

    public Iterator getClassDescriptionTypes() {
        return Arrays.asList(OWL.Class, OWL.Restriction).iterator();
    }

    public boolean isSupported(Node node, EnhGraph enhGraph, Class clazz) {
        if (enhGraph instanceof OntModel) {
            OntModel ontModel = (OntModel)((Object)enhGraph);
            if (!ontModel.strictMode()) {
                return true;
            }
            SupportsCheck supportsCheck = (SupportsCheck)s_supportsChecks.get(clazz);
            return supportsCheck != null && supportsCheck.doCheck(node, enhGraph);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n = 0;
        while (n < s_supportsCheckTable.length) {
            s_supportsChecks.put(s_supportsCheckTable[n][0], s_supportsCheckTable[n][1]);
            ++n;
        }
    }

    protected static class SupportsCheck {
        protected SupportsCheck() {
        }

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return true;
        }
    }
}

