/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.OneToManyMap;
import java.util.Iterator;

public abstract class AbstractProfile
implements Profile {
    protected OneToManyMap m_aliasesMap;

    public boolean hasAliasFor(Resource resource) {
        return this.aliasMap().containsKey(resource);
    }

    public Resource getAliasFor(Resource resource) {
        return (Resource)this.aliasMap().get(resource);
    }

    public Iterator listAliasesFor(Resource resource) {
        return this.aliasMap().getAll(resource);
    }

    protected abstract Resource[][] aliasTable();

    protected OneToManyMap aliasMap() {
        if (this.m_aliasesMap == null) {
            this.m_aliasesMap = new OneToManyMap();
            Resource[][] resourceArray = this.aliasTable();
            int n = 0;
            while (n < resourceArray.length) {
                this.m_aliasesMap.put(resourceArray[n][0], resourceArray[n][1]);
                this.m_aliasesMap.put(resourceArray[n][1], resourceArray[n][0]);
                ++n;
            }
        }
        return this.m_aliasesMap;
    }
}

