/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.ontology.daml.PropertyIterator;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.ontology.daml.impl.PropertyAccessorImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;

public class DAMLPropertyImpl
extends DAMLCommonImpl
implements DAMLProperty {
    private PropertyAccessor m_propDomain = null;
    private PropertyAccessor m_propRange = null;
    private PropertyAccessor m_propSubPropertyOf = null;
    private PropertyAccessor m_propSamePropertyAs = null;

    public DAMLPropertyImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, string2, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().Property());
    }

    public DAMLPropertyImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().Property());
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.indexOf("Impl");
        int n2 = string.lastIndexOf(".") + 1;
        string = n > 0 ? string.substring(n2, n) : string.substring(n2);
        String string2 = this.isUnique() ? "unique " : "";
        return this.getURI() == null ? "<" + string2 + "Anonymous " + string + "@" + Integer.toHexString(this.hashCode()) + ">" : "<" + string2 + string + " " + this.getURI() + ">";
    }

    public void setIsUnique(boolean bl) {
        if (bl) {
            this.setRDFType(this.getVocabulary().UniqueProperty(), false);
        } else {
            this.removeProperty(RDF.type, this.getVocabulary().UniqueProperty());
        }
    }

    public boolean isUnique() {
        return this.hasRDFType(this.getVocabulary().UniqueProperty());
    }

    public PropertyAccessor prop_domain() {
        if (this.m_propDomain == null) {
            this.m_propDomain = new PropertyAccessorImpl(this.getVocabulary().domain(), this);
        }
        return this.m_propDomain;
    }

    public PropertyAccessor prop_subPropertyOf() {
        if (this.m_propSubPropertyOf == null) {
            this.m_propSubPropertyOf = new PropertyAccessorImpl(this.getVocabulary().subPropertyOf(), this);
        }
        return this.m_propSubPropertyOf;
    }

    public PropertyAccessor prop_samePropertyAs() {
        if (this.m_propSamePropertyAs == null) {
            this.m_propSamePropertyAs = new PropertyAccessorImpl(this.getVocabulary().samePropertyAs(), this);
        }
        return this.m_propSamePropertyAs;
    }

    public PropertyAccessor prop_range() {
        if (this.m_propRange == null) {
            this.m_propRange = new PropertyAccessorImpl(this.getVocabulary().range(), this);
        }
        return this.m_propRange;
    }

    public Iterator getSameProperties() {
        return new PropertyIterator(this, this.getVocabulary().samePropertyAs(), this.getVocabulary().samePropertyAs(), true, true);
    }

    public Iterator getEquivalentValues() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(super.getEquivalentValues(), new PropertyIterator(this, this.getVocabulary().samePropertyAs(), this.getVocabulary().samePropertyAs(), true, false, false));
        concatenatedIterator.setDefaultValue(this);
        return concatenatedIterator;
    }

    public Iterator getSuperProperties() {
        return this.getSuperProperties(true);
    }

    public Iterator getSuperProperties(boolean bl) {
        return new PropertyIterator(this, this.getVocabulary().subPropertyOf(), null, bl, false, true);
    }

    public Iterator getSubProperties() {
        return this.getSubProperties(true);
    }

    public Iterator getSubProperties(boolean bl) {
        return new PropertyIterator(this, null, this.getVocabulary().subPropertyOf(), bl, false, true);
    }

    public Iterator getDomainClasses() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.getSelfIterator(), this.getSuperProperties());
        return new PropertyIterator(concatenatedIterator, this.getVocabulary().domain(), null, false, false);
    }

    public Iterator getRangeClasses() {
        ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.getSelfIterator(), this.getSuperProperties());
        return new PropertyIterator(concatenatedIterator, this.getVocabulary().range(), null, false, false);
    }

    public boolean isProperty() {
        return true;
    }

    public int getOrdinal() {
        return 0;
    }

    Object getKey() {
        return DAML_OIL.Property.getURI();
    }

    public Resource port(Model model) throws RDFException {
        if (this.getModel() == model) {
            return this;
        }
        if (model instanceof DAMLModel) {
            return new DAMLPropertyImpl(this.getNameSpace(), this.getLocalName(), (DAMLModel)model, this.getVocabulary());
        }
        throw new RDFException(0, "Cannot port DAML object to non-DAML model.");
    }
}

