/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLOntology;
import com.hp.hpl.jena.ontology.daml.LiteralAccessor;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.ontology.daml.impl.LiteralAccessorImpl;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.iterator.ConcatenatedNodeIterator;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.DAML_OIL_2000_12;

public class DAMLOntologyImpl
extends DAMLCommonImpl
implements DAMLOntology {
    private LiteralAccessor m_propVersionInfo = null;

    public DAMLOntologyImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().Ontology());
    }

    public DAMLOntologyImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, string2, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().Ontology());
    }

    public LiteralAccessor prop_versionInfo() {
        if (this.m_propVersionInfo == null) {
            this.m_propVersionInfo = new LiteralAccessorImpl(this.getVocabulary().versionInfo(), this);
        }
        return this.m_propVersionInfo;
    }

    public NodeIterator getImportedOntologies() {
        return new ConcatenatedNodeIterator(this.getPropertyValues(DAML_OIL.imports), this.getPropertyValues(DAML_OIL_2000_12.imports));
    }

    public void addImportedOntology(String string) {
        try {
            this.addProperty(this.getVocabulary().imports(), this.getModel().createLiteral(string));
            if (this.getDAMLModel().getLoader().getLoadImportedOntologies()) {
                this.getModel().read(string);
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception while adding imports property: " + rDFException, rDFException);
        }
    }

    Object getKey() {
        return DAML_OIL.Ontology.getURI();
    }
}

