/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDatatype;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLOntology;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.impl.DAMLClassImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLDatatypeImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLDatatypePropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLInstanceImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLListImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLLoader;
import com.hp.hpl.jena.ontology.daml.impl.DAMLObjectPropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLOntologyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl;
import com.hp.hpl.jena.ontology.daml.impl.DAMLRestrictionImpl;
import com.hp.hpl.jena.ontology.daml.impl.VocabularyManager;
import com.hp.hpl.jena.ontology.daml.impl.XMLDatatypeRegistry;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.DAML_OIL_2000_12;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DAMLModelImpl
extends ModelMem
implements DAMLModel {
    protected static Object[][] DAML_CLASS_TABLE = new Object[][]{{DAML_OIL.Class, class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLClassImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl}, {DAML_OIL_2000_12.Class, class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLClassImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl}, {RDFS.Class, class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLClassImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl}, {DAML_OIL_2000_12.Disjoint, class$com$hp$hpl$jena$ontology$daml$impl$DAMLDisjointImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLDisjointImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLDisjointImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLDisjointImpl}, {DAML_OIL.Restriction, class$com$hp$hpl$jena$ontology$daml$impl$DAMLRestrictionImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLRestrictionImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLRestrictionImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLRestrictionImpl}, {DAML_OIL_2000_12.Restriction, class$com$hp$hpl$jena$ontology$daml$impl$DAMLRestrictionImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLRestrictionImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLRestrictionImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLRestrictionImpl}, {DAML_OIL.List, class$com$hp$hpl$jena$ontology$daml$impl$DAMLListImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLListImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLListImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLListImpl}, {DAML_OIL_2000_12.List, class$com$hp$hpl$jena$ontology$daml$impl$DAMLListImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLListImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLListImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLListImpl}, {DAML_OIL.Ontology, class$com$hp$hpl$jena$ontology$daml$impl$DAMLOntologyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLOntologyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLOntologyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLOntologyImpl}, {DAML_OIL_2000_12.Ontology, class$com$hp$hpl$jena$ontology$daml$impl$DAMLOntologyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLOntologyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLOntologyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLOntologyImpl}, {DAML_OIL.Property, class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl}, {DAML_OIL_2000_12.Property, class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl}, {RDF.Property, class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl}, {DAML_OIL.DatatypeProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLDatatypePropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLDatatypePropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLDatatypePropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLDatatypePropertyImpl}, {DAML_OIL.ObjectProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLObjectPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl}, {DAML_OIL_2000_12.UniqueProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl}, {DAML_OIL_2000_12.TransitiveProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl}, {DAML_OIL_2000_12.UnambiguousProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl}, {DAML_OIL.UniqueProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl}, {DAML_OIL.TransitiveProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLObjectPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl}, {DAML_OIL.UnambiguousProperty, class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl == null ? (class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl = DAMLModelImpl.class$("com.hp.hpl.jena.ontology.daml.impl.DAMLObjectPropertyImpl")) : class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl}};
    private DAMLLoader m_loader = new DAMLLoader(this);
    protected Map m_indexes = new HashMap();
    protected OneToManyMap m_nameIndex = new OneToManyMap();
    protected OneToManyMap m_namespaceIndex = new OneToManyMap();
    protected XMLDatatypeRegistry m_xmlDatatypeRegistry = new XMLDatatypeRegistry();
    protected boolean m_useEquivalence = true;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLClassImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLDisjointImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLRestrictionImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLListImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLOntologyImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLPropertyImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLDatatypePropertyImpl;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$daml$impl$DAMLObjectPropertyImpl;

    public DAMLModelImpl() {
        this.initStore();
    }

    public DAMLOntology createDAMLOntology(String string) {
        return (DAMLOntology)this.index(new DAMLOntologyImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLInstance createDAMLInstance(DAMLClass dAMLClass, String string) {
        DAMLInstanceImpl dAMLInstanceImpl = new DAMLInstanceImpl(string, this, VocabularyManager.getDefaultVocabulary());
        dAMLInstanceImpl.setRDFType(dAMLClass);
        return (DAMLInstance)this.index(dAMLInstanceImpl);
    }

    public DAMLClass createDAMLClass(String string) {
        return (DAMLClass)this.index(new DAMLClassImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLProperty createDAMLProperty(String string) {
        return (DAMLProperty)this.index(new DAMLPropertyImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLObjectProperty createDAMLObjectProperty(String string) {
        return (DAMLObjectProperty)this.index(new DAMLObjectPropertyImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLDatatypeProperty createDAMLDatatypeProperty(String string) {
        return (DAMLDatatypeProperty)this.index(new DAMLDatatypePropertyImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLDatatype createDAMLDatatype(String string) {
        return (DAMLDatatype)this.index(new DAMLDatatypeImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLList createDAMLList(String string) {
        return (DAMLList)this.index(new DAMLListImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLRestriction createDAMLRestriction(String string) {
        return (DAMLRestriction)this.index(new DAMLRestrictionImpl(string, this, VocabularyManager.getDefaultVocabulary()));
    }

    public DAMLCommon createDAMLValue(String string, Resource resource, DAMLVocabulary dAMLVocabulary) {
        boolean bl = false;
        DAMLCommon dAMLCommon = null;
        int n = 0;
        while (!bl && n < DAML_CLASS_TABLE.length) {
            Resource resource2 = (Resource)DAML_CLASS_TABLE[n][0];
            Class clazz = (Class)DAML_CLASS_TABLE[n][1];
            if (resource2.equals(resource)) {
                bl = true;
                try {
                    dAMLCommon = (DAMLCommon)clazz.getDeclaredConstructor(DAMLLoader.s_constructSig).newInstance(string, this, VocabularyManager.getVocabulary(resource.getURI()));
                }
                catch (Exception exception) {
                    Log.debug("Failed to construct DAML value " + clazz.getName(), exception);
                    throw new RuntimeException("Unexpected error while constructing DAML value from RDF model: " + exception);
                }
            }
            ++n;
        }
        if (!bl && resource instanceof DAMLClass) {
            dAMLCommon = new DAMLInstanceImpl(string, this, VocabularyManager.getVocabulary(resource.getURI()));
        }
        try {
            if (dAMLCommon != null) {
                this.add(dAMLCommon, RDF.type, resource);
                this.index(dAMLCommon);
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDFException while adding statment to model: " + rDFException, rDFException);
        }
        return dAMLCommon;
    }

    public DAMLCommon getDAMLValue(String string) {
        Resource resource = null;
        if (this.containsResource(string)) {
            try {
                resource = this.getResource(string);
            }
            catch (RDFException rDFException) {
                Log.severe("RFD exception while getting resource: " + rDFException, rDFException);
            }
            if (resource != null && resource instanceof DAMLCommon) {
                return (DAMLCommon)resource;
            }
        }
        return null;
    }

    public DAMLCommon getDAMLValue(String string, DAMLClass dAMLClass, DAMLVocabulary dAMLVocabulary) {
        DAMLCommon dAMLCommon = this.getDAMLValue(string);
        if (dAMLCommon == null && dAMLClass != null) {
            return this.createDAMLValue(string, dAMLClass, dAMLVocabulary);
        }
        return dAMLCommon;
    }

    public Iterator listDAMLClasses() {
        return this.getIndex(DAML_OIL.Class.getURI()).iterator();
    }

    public Iterator listDAMLProperties() {
        return this.getIndex(DAML_OIL.Property.getURI()).iterator();
    }

    public Iterator listDAMLInstances() {
        return this.getIndex(DAML_OIL.Thing.getURI()).iterator();
    }

    public Model read(String string) {
        return this.read(string, string, null);
    }

    public Model read(String string, String string2) {
        return this.read(string, string, string2);
    }

    public Model read(Reader reader, String string) {
        return this.read(reader, string, null);
    }

    public Model read(String string, String string2, String string3) {
        this.getLoader().resetStatus();
        this.getLoader().read(string, string2, string3);
        return this;
    }

    public Model read(Reader reader, String string, String string2) {
        this.getLoader().resetStatus();
        try {
            this.getLoader().read(reader, string, string2);
            if (!this.getLoadSuccessful()) {
                Log.info("Errors reported during model load: check log file for details, status code = " + this.getLoader().getStatus());
            }
        }
        catch (RuntimeException runtimeException) {
            Log.severe("Saw runtime exception: " + runtimeException, runtimeException);
        }
        return this;
    }

    public Model add(Model model) {
        this.getLoader().add(model);
        return this;
    }

    public DAMLLoader getLoader() {
        return this.m_loader;
    }

    public boolean getLoadSuccessful() {
        return this.getLoader().getStatus() == 0L;
    }

    public XMLDatatypeRegistry getDatatypeRegistry() {
        return this.m_xmlDatatypeRegistry;
    }

    DAMLCommon index(DAMLCommon dAMLCommon) {
        Object object = ((DAMLCommonImpl)dAMLCommon).getKey();
        this.getIndex(object).add(dAMLCommon);
        return dAMLCommon;
    }

    void unindex(DAMLCommon dAMLCommon) {
        Object object = ((DAMLCommonImpl)dAMLCommon).getKey();
        this.getIndex(object).remove(dAMLCommon);
    }

    public void setUseEquivalence(boolean bl) {
        this.m_useEquivalence = bl;
    }

    public boolean getUseEquivalence() {
        return this.m_useEquivalence;
    }

    protected void initStore() {
    }

    protected ArrayList getIndex(Object object) {
        ArrayList arrayList = (ArrayList)this.m_indexes.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.m_indexes.put(object, arrayList);
        }
        return arrayList;
    }

    protected boolean containsResource(String string) {
        try {
            Resource resource = this.getResource(string);
            StmtIterator stmtIterator = this.listStatements(new SimpleSelector(resource, null, (RDFNode)null));
            if (stmtIterator.hasNext()) {
                stmtIterator.close();
                return true;
            }
            stmtIterator.close();
            StmtIterator stmtIterator2 = this.listStatements(new SimpleSelector(null, null, resource));
            if (stmtIterator2.hasNext()) {
                stmtIterator2.close();
                return true;
            }
            stmtIterator2.close();
            try {
                Property property = this.getProperty(string);
                StmtIterator stmtIterator3 = this.listStatements(new SimpleSelector(null, property, (RDFNode)null));
                if (stmtIterator3.hasNext()) {
                    stmtIterator3.close();
                    return true;
                }
                stmtIterator3.close();
            }
            catch (RDFException rDFException) {
            }
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception: " + rDFException, rDFException);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

