/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml;

import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.NodeIteratorWrapper;
import com.hp.hpl.jena.util.iterator.ResIteratorWrapper;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class PropertyIterator
implements Iterator {
    protected LinkedList m_nodeQueue;
    protected Property m_pred;
    protected Property m_inverse;
    protected HashSet m_predEquivs;
    protected HashSet m_inverseEquivs;
    protected boolean m_transitive;
    protected WeakHashMap m_seen;
    protected Resource m_root;
    protected List m_roots;
    protected Object m_defaultValue;
    protected boolean m_defaultValueSeen;
    protected boolean m_useEquivalence;
    protected Model m_model;

    public PropertyIterator(Resource resource, Property property, Property property2, boolean bl, boolean bl2) {
        this(resource, property, property2, bl, bl2, true);
    }

    public PropertyIterator(Resource resource, Property property, Property property2, boolean bl, boolean bl2, boolean bl3) {
        this.m_nodeQueue = new LinkedList();
        this.m_pred = null;
        this.m_inverse = null;
        this.m_predEquivs = new HashSet();
        this.m_inverseEquivs = new HashSet();
        this.m_transitive = false;
        this.m_seen = new WeakHashMap();
        this.m_root = null;
        this.m_roots = null;
        this.m_defaultValue = null;
        this.m_defaultValueSeen = false;
        this.m_useEquivalence = true;
        this.m_model = null;
        this.m_root = resource;
        this.m_pred = property;
        this.m_inverse = property2;
        this.m_transitive = bl;
        this.m_useEquivalence = bl3;
        this.setModel();
        this.cachePropertyEquivs();
        if (bl2) {
            this.enqueue(resource);
        } else {
            this.expandQueue(resource);
        }
    }

    public PropertyIterator(Iterator iterator, Property property, Property property2, boolean bl, boolean bl2) {
        this(iterator, property, property2, bl, bl2, true);
    }

    /*
     * Unable to fully structure code
     */
    public PropertyIterator(Iterator var1_1, Property var2_2, Property var3_3, boolean var4_4, boolean var5_5, boolean var6_6) {
        block4: {
            super();
            this.m_nodeQueue = new LinkedList<E>();
            this.m_pred = null;
            this.m_inverse = null;
            this.m_predEquivs = new HashSet<E>();
            this.m_inverseEquivs = new HashSet<E>();
            this.m_transitive = false;
            this.m_seen = new WeakHashMap<K, V>();
            this.m_root = null;
            this.m_roots = null;
            this.m_defaultValue = null;
            this.m_defaultValueSeen = false;
            this.m_useEquivalence = true;
            this.m_model = null;
            this.m_roots = new ArrayList<E>();
            this.m_pred = var2_2;
            this.m_inverse = var3_3;
            this.m_transitive = var4_4;
            this.m_useEquivalence = var6_6;
            this.setModel();
            this.cachePropertyEquivs();
            if (!var5_5) ** GOTO lbl40
            while (var1_1.hasNext()) {
                var7_7 = (Resource)var1_1.next();
                if (this.m_model == null && var7_7.getModel() != null) {
                    this.m_model = var7_7.getModel();
                }
                if (!(var7_7 instanceof Resource)) continue;
                this.m_roots.add(var7_7);
                this.enqueue(var7_7);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var7_8 = (Resource)var1_1.next();
                if (this.m_model == null && var7_8.getModel() != null) {
                    this.m_model = var7_8.getModel();
                }
                if (!(var7_8 instanceof Resource)) continue;
                this.m_roots.add(var7_8);
                this.expandQueue(var7_8);
lbl40:
                // 3 sources

                ** while (var1_1.hasNext())
            }
        }
    }

    public boolean hasNext() {
        return !this.m_nodeQueue.isEmpty() || this.hasDefaultValue() && !this.m_defaultValueSeen;
    }

    public Object next() {
        if (!this.m_nodeQueue.isEmpty()) {
            RDFNode rDFNode = (RDFNode)this.m_nodeQueue.removeFirst();
            if (this.hasDefaultValue() && this.m_defaultValue.equals(rDFNode)) {
                this.m_defaultValueSeen = true;
            }
            if (rDFNode instanceof Resource) {
                this.expandQueue((Resource)rDFNode);
            }
            return rDFNode;
        }
        if (this.hasDefaultValue() && !this.m_defaultValueSeen) {
            this.m_defaultValueSeen = true;
            return this.m_defaultValue;
        }
        throw new NoSuchElementException("Tried to access next() element from empty property iterator");
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a property iterator");
    }

    public void setDefaultValue(Object object) {
        this.m_defaultValue = object;
    }

    public boolean hasDefaultValue() {
        return this.m_defaultValue != null;
    }

    private void enqueue(RDFNode rDFNode) {
        if (!this.m_seen.containsKey(rDFNode)) {
            this.m_seen.put(rDFNode, Boolean.TRUE);
            this.m_nodeQueue.addLast(rDFNode);
            if (this.getUseEquivalence() && rDFNode instanceof DAMLCommon) {
                Iterator iterator = ((DAMLCommon)rDFNode).getEquivalentValues();
                while (iterator.hasNext()) {
                    this.enqueue((RDFNode)iterator.next());
                }
            }
        }
    }

    protected void expandQueue(Resource resource) {
        block5: {
            try {
                Iterator iterator;
                if (this.m_pred != null && (this.m_transitive || this.isRoot(resource))) {
                    iterator = this.getStatementObjects(resource);
                    while (iterator.hasNext()) {
                        this.enqueue((RDFNode)iterator.next());
                    }
                }
                if (this.m_inverse == null || !this.m_transitive && !this.isRoot(resource)) break block5;
                iterator = this.getStatementSubjects(resource);
                while (iterator.hasNext()) {
                    this.enqueue((RDFNode)iterator.next());
                }
            }
            catch (RDFException rDFException) {
                Log.severe("RDF exception while traversing graph: " + rDFException, rDFException);
            }
        }
    }

    protected boolean isRoot(Resource resource) {
        boolean bl = false;
        if (this.m_roots != null) {
            return this.m_roots.contains(resource);
        }
        return resource == this.m_root;
    }

    protected Iterator getStatementObjects(Resource resource) throws RDFException {
        Iterator iterator = null;
        if (this.getUseEquivalence() && resource instanceof DAMLCommon) {
            Iterator iterator2 = this.m_predEquivs.iterator();
            while (iterator2.hasNext()) {
                PropertyIterator propertyIterator = new PropertyIterator(resource, (Property)iterator2.next(), null, this.m_transitive, false, false);
                Iterator iterator3 = iterator = iterator == null ? propertyIterator : new ConcatenatedIterator(propertyIterator, iterator);
            }
        } else {
            iterator = this.m_model != null ? new NodeIteratorWrapper(this.m_model.listObjectsOfProperty(resource, this.m_pred)) : new LinkedList().iterator();
        }
        return iterator;
    }

    protected Iterator getStatementSubjects(Resource resource) throws RDFException {
        Iterator iterator = null;
        if (this.getUseEquivalence() && resource instanceof DAMLCommon) {
            Iterator iterator2 = this.m_inverseEquivs.iterator();
            while (iterator2.hasNext()) {
                PropertyIterator propertyIterator = new PropertyIterator(resource, null, (Property)iterator2.next(), this.m_transitive, false, false);
                Iterator iterator3 = iterator = iterator == null ? propertyIterator : new ConcatenatedIterator(propertyIterator, iterator);
            }
        } else {
            iterator = this.m_model != null ? new ResIteratorWrapper(this.m_model.listSubjectsWithProperty(this.m_inverse, resource)) : new LinkedList().iterator();
        }
        return iterator;
    }

    protected void cachePropertyEquivs() {
        if (this.getUseEquivalence()) {
            Iterator iterator;
            if (this.m_pred != null) {
                if (this.m_pred instanceof DAMLProperty) {
                    iterator = ((DAMLProperty)this.m_pred).getEquivalentValues();
                    while (iterator.hasNext()) {
                        this.cacheProperty(this.m_predEquivs, (Property)iterator.next());
                    }
                } else {
                    this.cacheProperty(this.m_predEquivs, this.m_pred);
                }
            }
            if (this.m_inverse != null) {
                if (this.m_inverse instanceof DAMLProperty) {
                    iterator = ((DAMLProperty)this.m_inverse).getEquivalentValues();
                    while (iterator.hasNext()) {
                        this.cacheProperty(this.m_inverseEquivs, (Property)iterator.next());
                    }
                } else {
                    this.cacheProperty(this.m_inverseEquivs, this.m_inverse);
                }
            }
        }
    }

    protected void cacheProperty(HashSet hashSet, Property property) {
        hashSet.add(property);
        if (property instanceof DAMLProperty && !property.getLocalName().equals(DAML_OIL.subPropertyOf.getLocalName())) {
            Iterator iterator = ((DAMLProperty)property).getSubProperties();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
    }

    protected void setModel() {
        if (this.m_root != null && this.m_root.getModel() != null) {
            this.m_model = this.m_root.getModel();
            return;
        }
        if (this.m_pred != null && this.m_pred.getModel() != null) {
            this.m_model = this.m_pred.getModel();
            return;
        }
        if (this.m_inverse != null && this.m_inverse.getModel() != null) {
            this.m_model = this.m_inverse.getModel();
            return;
        }
        if (this.m_roots != null) {
            Iterator iterator = this.m_roots.iterator();
            while (iterator.hasNext()) {
                RDFNode rDFNode = (RDFNode)iterator.next();
                if (!(rDFNode instanceof Resource) || ((Resource)rDFNode).getModel() == null) continue;
                this.m_model = ((Resource)rDFNode).getModel();
                return;
            }
        }
    }

    protected boolean getUseEquivalence() {
        boolean bl = this.m_model == null || !(this.m_model instanceof DAMLModel) || ((DAMLModel)this.m_model).getUseEquivalence();
        return this.m_useEquivalence && bl;
    }
}

