/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.DAML_OILProfile;
import com.hp.hpl.jena.ontology.impl.OWLDLProfile;
import com.hp.hpl.jena.ontology.impl.OWLLiteProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Map;

public class ProfileRegistry {
    public static final String OWL_LANG = "http://www.w3.org/2002/07/owl#";
    public static final String OWL_DL_LANG = "http://www.w3.org/TR/owl-features/#term_OWLDL";
    public static final String OWL_LITE_LANG = "http://www.w3.org/TR/owl-features/#term_OWLLite";
    public static final String DAML_LANG = "http://www.daml.org/2001/03/daml+oil#";
    public static final String RDFS_LANG = RDFS.getURI();
    private static Object[][] s_initData = new Object[][]{{"http://www.w3.org/2002/07/owl#", new OWLProfile()}, {"http://www.w3.org/TR/owl-features/#term_OWLDL", new OWLDLProfile()}, {"http://www.w3.org/TR/owl-features/#term_OWLLite", new OWLLiteProfile()}, {"http://www.daml.org/2001/03/daml+oil#", new DAML_OILProfile()}};
    private static ProfileRegistry s_instance = new ProfileRegistry();
    private Map m_registry = new HashMap();

    private ProfileRegistry() {
        int n = 0;
        while (n < s_initData.length) {
            this.registerProfile((String)s_initData[n][0], (Profile)s_initData[n][1]);
            ++n;
        }
    }

    public static ProfileRegistry getInstance() {
        return s_instance;
    }

    public void registerProfile(String string, Profile profile) {
        this.m_registry.put(string, profile);
    }

    public Profile getProfile(String string) {
        return (Profile)this.m_registry.get(string);
    }
}

