/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphFactory;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntReadState;
import com.hp.hpl.jena.ontology.impl.OntologyGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class OntDocumentManager {
    public static final String DEFAULT_METADATA_PATH = "file:etc/ont-policy.rdf;file:ont-policy.rdf";
    public static final String PATH_DELIMITER = ";";
    public static final String NS = "http://jena.hpl.hp.com/schemas/2003/03/ont-manager#";
    private static final Model vocab = ModelFactory.createDefaultModel();
    public static final Resource ONTOLOGY_SPEC = vocab.createResource("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#OntologySpec");
    public static final Property PUBLIC_URI = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#publicURI");
    public static final Property ALT_URL = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#altURL");
    public static final Property PREFIX = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#prefix");
    public static final Property LANGUAGE = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#language");
    public static final Resource DOC_MGR_POLICY = vocab.createResource("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#DocumentManagerPolicy");
    public static final Property CACHE_MODELS = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#", "cacheModels");
    public static final Property PROCESS_IMPORTS = vocab.createProperty("http://jena.hpl.hp.com/schemas/2003/03/ont-manager#", "processImports");
    private static OntDocumentManager s_instance = new OntDocumentManager();
    protected String m_searchPath = "file:etc/ont-policy.rdf;file:ont-policy.rdf";
    protected Map m_altMap = new HashMap();
    protected Map m_prefixMap = new HashMap();
    protected Map m_uriMap = new HashMap();
    protected Map m_graphMap = new HashMap();
    protected Map m_languageMap = new HashMap();
    private Logger m_log = Logger.getLogger(this.getClass());
    protected boolean m_cacheGraphs = true;
    protected boolean m_processImports = true;
    protected GraphFactory m_graphFactory = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$ontology$OntDocumentManager;

    public OntDocumentManager() {
        this(DEFAULT_METADATA_PATH);
    }

    public OntDocumentManager(String string) {
        this.m_searchPath = string == null ? "" : string;
        this.initialiseMetadata(this.m_searchPath, false);
    }

    public static OntDocumentManager getInstance() {
        return s_instance;
    }

    public String getMetadataSearchPath() {
        return this.m_searchPath;
    }

    public void setMetadataSearchPath(String string, boolean bl) {
        this.m_searchPath = string;
        this.initialiseMetadata(string, bl);
    }

    public Iterator listDocuments() {
        return this.m_altMap.keySet().iterator();
    }

    public String getCacheURL(String string) {
        String string2 = (String)this.m_altMap.get(string);
        return string2 == null ? string : string2;
    }

    public String getLanguage(String string) {
        return (String)this.m_languageMap.get(string);
    }

    public String getPrefixForURI(String string) {
        return (String)this.m_prefixMap.get(string);
    }

    public String getURIForPrefix(String string) {
        return (String)this.m_uriMap.get(string);
    }

    public Graph getGraph(String string) {
        return (Graph)this.m_graphMap.get(string);
    }

    public void addPrefixMapping(String string, String string2) {
        this.m_uriMap.put(string2, string);
        this.m_prefixMap.put(string, string2);
    }

    public void addAltEntry(String string, String string2) {
        this.m_altMap.put(string, string2);
    }

    public void addGraph(String string, Graph graph) {
        if (this.m_cacheGraphs) {
            this.m_graphMap.put(string, graph);
        }
    }

    public void addLanguageEntry(String string, String string2) {
        this.m_languageMap.put(string, string2);
    }

    public void forget(String string) {
        this.m_altMap.remove(string);
        this.m_uriMap.remove(string);
        this.m_prefixMap.remove(string);
        this.m_graphMap.remove(string);
        this.m_languageMap.remove(string);
    }

    public Model getOntology(String string, String string2) {
        OntModel ontModel = ModelFactory.createOntologyModel(string2, null, this);
        ontModel.read(string);
        return ontModel;
    }

    public GraphFactory getDefaultGraphFactory() {
        if (this.m_graphFactory == null) {
            this.m_graphFactory = new GraphFactory(){

                public Graph getGraph() {
                    return new GraphMem();
                }
            };
        }
        return this.m_graphFactory;
    }

    public void setDefaultGraphFactory(GraphFactory graphFactory) {
        this.m_graphFactory = graphFactory;
    }

    public boolean getProcessImports() {
        return this.m_processImports;
    }

    public boolean getCacheGraphs() {
        return this.m_cacheGraphs;
    }

    public void setProcessImports(boolean bl) {
        this.m_processImports = bl;
    }

    public void setCacheGraphs(boolean bl) {
        this.m_cacheGraphs = bl;
    }

    public void clearCache() {
        this.m_graphMap.clear();
    }

    public void loadImports(OntModel ontModel, OntReadState ontReadState) {
        if (this.m_processImports) {
            if (ontReadState.getQueue() == null) {
                ontReadState.setQueue(ontModel.listImportedOntologyURIs());
            } else {
                ontReadState.getQueue().addAll(ontModel.listImportedOntologyURIs());
            }
            while (!ontReadState.getQueue().isEmpty()) {
                String string = (String)ontReadState.getQueue().remove(0);
                if (ontModel.hasLoadedImport(string)) continue;
                this.loadImport(ontModel, string, ontReadState);
            }
        }
    }

    protected void initialiseMetadata(String string, boolean bl) {
        Model model;
        if (bl) {
            this.m_altMap.clear();
            this.m_prefixMap.clear();
            this.m_graphMap.clear();
        }
        if ((model = this.findMetadata(string)) != null) {
            this.loadMetadata(model);
        }
    }

    protected Model findMetadata(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_DELIMITER);
        Model model = ModelFactory.createDefaultModel();
        boolean bl = false;
        while (!bl && stringTokenizer.hasMoreTokens()) {
            try {
                model.read(stringTokenizer.nextToken());
                bl = true;
            }
            catch (RDFException rDFException) {
                // empty catch block
            }
        }
        return bl ? model : null;
    }

    protected void loadMetadata(Model model) {
        ResIterator resIterator = model.listSubjectsWithProperty(RDF.type, ONTOLOGY_SPEC);
        while (resIterator.hasNext()) {
            Resource resource = resIterator.nextResource();
            Statement statement = resource.getProperty(PUBLIC_URI);
            if (statement != null) {
                String string = statement.getResource().getURI();
                Object var6_6 = null;
                Object var7_7 = null;
                Object var8_8 = null;
                try {
                    statement = resource.getProperty(ALT_URL);
                    this.addAltEntry(string, statement.getResource().getURI());
                }
                catch (RDFException rDFException) {
                    // empty catch block
                }
                try {
                    statement = resource.getProperty(PREFIX);
                    this.addPrefixMapping(string, statement.getString());
                }
                catch (RDFException rDFException) {
                    // empty catch block
                }
                try {
                    statement = resource.getProperty(LANGUAGE);
                    this.addLanguageEntry(string, statement.getResource().getURI());
                }
                catch (RDFException rDFException) {}
                continue;
            }
            this.m_log.warn((Object)"Ontology specification node lists no public URI - node ignored");
        }
    }

    protected void loadImport(OntModel ontModel, String string, OntReadState ontReadState) {
        Object object;
        ontModel.addLoadedImport(string);
        ontReadState.getModel().addLoadedImport(string);
        Graph graph = this.getGraph(string);
        if (graph == null) {
            object = ModelFactory.createOntologyModel(ontModel.getProfile().NAMESPACE(), null, this, ontModel.getGraphFactory());
            object.read(string, ontReadState);
            graph = object.getGraph();
        }
        if (graph instanceof OntologyGraph) {
            object = ((OntologyGraph)graph).getUnion();
            ontModel.addSubGraph(((Polyadic)object).getBaseGraph());
            ontReadState.getModel().addSubGraph(((Polyadic)object).getBaseGraph());
            Iterator iterator = ((Polyadic)object).getSubGraphs().iterator();
            while (iterator.hasNext()) {
                Graph graph2 = (Graph)iterator.next();
                ontModel.addSubGraph(graph2);
                ontReadState.getModel().addSubGraph(graph2);
            }
        } else {
            ontModel.addSubGraph(graph);
            ontReadState.getModel().addSubGraph(graph);
        }
    }

    protected void read(OntModel ontModel, String string) {
        String string2 = this.m_uriMap.containsKey(string) ? this.m_uriMap.get(string) : string;
        OntModel ontModel2 = ModelFactory.createOntologyModel(ontModel.getProfile().NAMESPACE(), null, this, ontModel.getGraphFactory());
        try {
            ontModel2.read(string2);
            this.addGraph(string, ontModel2.getGraph());
        }
        catch (RDFException rDFException) {
            Logger.getLogger((Class)(class$com$hp$hpl$jena$ontology$OntDocumentManager == null ? (class$com$hp$hpl$jena$ontology$OntDocumentManager = OntDocumentManager.class$("com.hp.hpl.jena.ontology.OntDocumentManager")) : class$com$hp$hpl$jena$ontology$OntDocumentManager)).warn((Object)("RDFException while reading model from " + string2 + ", with message: " + rDFException.getMessage()), (Throwable)rDFException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

