/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.AntlrUtils;
import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Exception;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;

public class N3toRDF
implements N3ParserEventHandler {
    public static boolean VERBOSE = false;
    Model model;
    Map prefixMap = new HashMap();
    Map resourceRef = new HashMap();
    Map propertyRef = new HashMap();
    static final String NS_rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String NS_rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    static final String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    static final String XMLLiteralURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    String base = null;
    final String anonPrefix = "_";
    private Map bNodeMap = new HashMap();

    public N3toRDF(Model model, String string) {
        this.model = model;
        this.base = string;
        if (VERBOSE) {
            System.out.println("N3toRDF: " + this.base);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void error(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void error(String string) {
        this.error(null, string);
    }

    public void warning(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void warning(String string) {
        this.warning(null, string);
    }

    public void deprecated(Exception exception, String string) {
        throw new N3Exception(string);
    }

    public void deprecated(String string) {
        this.deprecated(null, string);
    }

    public void startFormula(int n, String string) {
        this.error("Line " + n + ": N3toRDF: All statements are asserted - no formulae in RDF");
    }

    public void endFormula(int n, String string) {
    }

    public void directive(int n, AST aST, AST[] aSTArray, String string) {
        if (aST.getType() == 18) {
            if (aSTArray[0].getType() != 6) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not start with a prefix! " + aSTArray[0].getText() + "[" + N3Parser.getTokenNames()[aSTArray[0].getType()] + "]");
                return;
            }
            String string2 = aSTArray[0].getText();
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (aSTArray[1].getType() != 39) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not supply a URIref! " + aSTArray[1].getText());
                return;
            }
            String string3 = aSTArray[1].getText();
            if (string3.equals("")) {
                string3 = this.base;
            }
            if (string3.equals("#")) {
                string3 = this.base + "#";
            }
            if (VERBOSE) {
                System.out.println(string2 + " => " + string3);
            }
            this.prefixMap.put(string2, string3);
            return;
        }
        this.warning("Line " + n + ": N3toRDF: Directive not recongized and ignored: " + aST.getText());
    }

    public void quad(int n, AST aST, AST aST2, AST aST3, String string) {
        if (string != null) {
            this.error("Line " + n + ": N3toRDF: All statement are asserted - no formulae");
        }
        try {
            int n2 = aST2.getType();
            String string2 = aST2.getText();
            Property property = null;
            switch (n2) {
                case 28: {
                    string2 = "http://www.w3.org/2000/10/swap/log#implies";
                    break;
                }
                case 48: {
                    string2 = "http://www.w3.org/2000/10/swap/log#means";
                    break;
                }
                case 29: {
                    string2 = "http://www.w3.org/2000/10/swap/log#implies";
                    AST aST4 = aST3;
                    aST3 = aST;
                    aST = aST4;
                    break;
                }
                case 27: {
                    property = OWL.sameAs;
                    break;
                }
                case 12: {
                    property = RDF.type;
                    break;
                }
                case 6: {
                    ExpandedQName expandedQName = new ExpandedQName(n, string2);
                    property = this.model.createProperty(expandedQName.firstPart, expandedQName.secondPart);
                    break;
                }
                case 39: {
                    break;
                }
                case 15: {
                    property = RDF.first;
                    break;
                }
                case 16: {
                    property = RDF.rest;
                    break;
                }
                default: {
                    this.error("Line " + n + ": N3toRDF: Shouldn't see " + N3EventPrinter.formatSlot(aST2) + " at this point!");
                }
            }
            if (property == null) {
                property = this.model.createProperty(string2);
            } else {
                string2 = property.getURI();
            }
            RDFNode rDFNode = this.createNode(n, aST);
            if (rDFNode instanceof Literal) {
                this.error("Line " + n + ": N3toRDF: Subject can't be a literal");
            }
            RDFNode rDFNode2 = this.createNode(n, aST3);
            Statement statement = this.model.createStatement((Resource)rDFNode, property, rDFNode2);
            if (VERBOSE) {
                System.out.println("Statement: " + statement);
            }
            this.model.add(statement);
        }
        catch (RDFException rDFException) {
            this.error("Line " + n + ": RDFException: " + rDFException);
        }
    }

    private RDFNode createNode(int n, AST aST) throws RDFException {
        String string = aST.getText();
        switch (aST.getType()) {
            case 21: {
                AST aST2 = aST.getNextSibling();
                AST aST3 = aST2 == null ? null : aST2.getNextSibling();
                AST aST4 = null;
                AST aST5 = null;
                if (aST3 != null) {
                    if (aST3.getType() == 38) {
                        aST4 = aST3.getFirstChild();
                    } else {
                        aST5 = aST3;
                    }
                }
                if (aST2 != null) {
                    if (aST2.getType() == 38) {
                        aST4 = aST2.getFirstChild();
                    } else {
                        aST5 = aST2;
                    }
                }
                String string2 = aST5 != null ? aST5.getText().substring(1) : null;
                String string3 = null;
                if (aST4 != null) {
                    string3 = aST4.getText();
                    switch (aST4.getType()) {
                        case 6: {
                            if (string3.startsWith("_:") || string3.startsWith("=:")) {
                                this.error("Line " + n + ": N3toRDF: Use bNode for datatype URI: " + string + "^^" + string3);
                                return this.model.createLiteral("Illegal literal: " + string + "^^" + string3);
                            }
                            ExpandedQName expandedQName = new ExpandedQName(n, string3);
                            string3 = expandedQName.expansion;
                        }
                        case 39: {
                            string3 = this.expandURIRef(string3);
                            break;
                        }
                        default: {
                            this.error("Line " + n + ": N3toRDF: Must use URIref or QName datatype URI: " + string + "^^" + string3 + "(" + N3Parser.getTokenNames()[aST4.getType()] + ")");
                            return this.model.createLiteral("Illegal literal: " + string + "^^" + string3);
                        }
                    }
                }
                return this.model.createTypedLiteral(string, string2, string3);
            }
            case 6: {
                if (string.startsWith("_:") && !this.prefixMap.containsKey("_")) {
                    if (!this.bNodeMap.containsKey(string)) {
                        this.bNodeMap.put(string, this.model.createResource());
                    }
                    return (Resource)this.bNodeMap.get(string);
                }
                ExpandedQName expandedQName = new ExpandedQName(n, string);
                string = expandedQName.expansion;
                return this.model.createResource(this.expandURIRef(string));
            }
            case 17: {
                return RDF.nil;
            }
            case 14: {
                return RDF.List;
            }
            case 39: {
                return this.model.createResource(this.expandURIRef(string));
            }
            case 4: {
                if (!this.bNodeMap.containsKey(string)) {
                    this.bNodeMap.put(string, this.model.createResource());
                }
                return (Resource)this.bNodeMap.get(string);
            }
            case 40: {
                this.error("Line " + n + ": N3toRDF: Can't map variables to RDF: " + string);
                break;
            }
            default: {
                this.error("Line " + n + ": N3toRDF: Can't map to a resource or literal: " + AntlrUtils.ast(aST));
            }
        }
        return null;
    }

    private String expandURIRef(String string) {
        if (string.equals("")) {
            return this.base;
        }
        if (string.equals("#")) {
            return this.base + "#";
        }
        return string;
    }

    class ExpandedQName {
        public String qname;
        public String firstPart;
        public String secondPart;
        public String expansion;

        ExpandedQName(int n, String string) {
            this.qname = string;
            int n2 = this.qname.indexOf(58);
            String string2 = this.qname.substring(0, n2);
            if (!N3toRDF.this.prefixMap.containsKey(string2)) {
                N3toRDF.this.error("Line " + n + ": N3toRDF: Undefined qname: " + this.qname);
            }
            this.secondPart = this.qname.substring(n2 + 1);
            this.firstPart = (String)N3toRDF.this.prefixMap.get(string2);
            this.expansion = this.firstPart + this.secondPart;
        }
    }
}

