/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import com.hp.hpl.jena.n3.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class N3JenaWriter
implements RDFWriter {
    private static final boolean doObjectListsAsLists = false;
    public static boolean DEBUG = false;
    RDFErrorHandler errorHandler = null;
    Map writerPropertyMap = new HashMap();
    public static final String propWriteSimple = "com.hp.hpl.jena.n3.N3JenaWriter.writeSimple";
    int bNodeCounter = 0;
    static final String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    Set rdfLists = null;
    Set rdfListsAll = null;
    Set rdfListsDone = null;
    Set roots = null;
    Set oneRefObjects = null;
    Set oneRefDone = null;
    Set prefixesUsed = null;
    Map prefixMap = new HashMap();
    Map bNodesMap = null;
    static Map wellKnownPropsMap = new HashMap();
    IndentedWriter out = null;
    String baseName = null;
    String indent = this.pad(6);
    int minGap = 1;
    boolean doingBaseHash = false;
    boolean doingPrettyWrite = true;

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public void setNsPrefix(String string, String string2) {
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.indexOf(46) != -1) {
            Log.warning("N3 names prefix can't contain a '.'", "N3JenaWriter", "setNsPrefix");
            return;
        }
        this.prefixMap.put(string, string2);
    }

    public Object setProperty(String string, Object object) throws RDFException {
        Object v = this.writerPropertyMap.get(string);
        this.writerPropertyMap.put(string, object);
        return v;
    }

    public void write(Model model, Writer writer, String string) throws RDFException {
        Model model2 = ModelCom.withHiddenStatements(model);
        Object object = this.writerPropertyMap.get(propWriteSimple);
        try {
            if (object == null) {
                object = System.getProperty(propWriteSimple);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (object != null && object instanceof String && !"false".equals((String)object)) {
            this.doingPrettyWrite = false;
        }
        if (!this.doingPrettyWrite) {
            this.writeSimple(model2, writer, string);
            return;
        }
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.out = new IndentedWriter(writer);
        this.baseName = string;
        this.startWriting();
        this.prepare(model2, string);
        this.writeModel(model2);
        this.finishWriting();
    }

    public synchronized void write(Model model, OutputStream outputStream, String string) throws RDFException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            this.write(model, bufferedWriter, string);
            try {
                ((Writer)bufferedWriter).flush();
            }
            catch (IOException iOException) {
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Failed to create UTF-8 writer");
        }
    }

    private void prepare(Model model, String string) throws RDFException {
        this.preparePrefixes(model);
        this.prepareLists(model);
        this.prepareOneRefBNodes(model);
    }

    private void preparePrefixes(Model model) throws RDFException {
        if (!this.prefixMap.containsValue(RDF.getURI()) && !this.prefixMap.containsKey("rdf")) {
            this.setNsPrefix("rdf", RDF.getURI());
        }
        if (!this.prefixMap.containsValue(RDFS.getURI()) && !this.prefixMap.containsKey("rdfs")) {
            this.setNsPrefix("rdfs", RDFS.getURI());
        }
        if (!this.prefixMap.containsValue(NS_W3_log) && !this.prefixMap.containsKey("log")) {
            this.setNsPrefix("log", NS_W3_log);
        }
        Iterator iterator = this.prefixMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.indexOf(46) == -1) continue;
            iterator.remove();
        }
    }

    private void prepareLists(Model model) throws RDFException {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        StmtIterator stmtIterator = model.listStatements(null, RDF.rest, RDF.nil);
        while (stmtIterator.hasNext()) {
            boolean bl;
            Resource resource = stmtIterator.nextStatement().getSubject();
            Resource resource2 = null;
            while (bl = this.checkListElement(resource)) {
                if (DEBUG) {
                    this.out.println("# RDF list all: " + this.formatResource(resource));
                }
                resource2 = resource;
                hashSet.add(resource);
                StmtIterator stmtIterator2 = model.listStatements(null, RDF.rest, resource);
                if (!stmtIterator2.hasNext()) break;
                resource = stmtIterator2.nextStatement().getSubject();
                if (!stmtIterator2.hasNext()) continue;
                if (!DEBUG) break;
                this.out.println("# RDF shared tail from " + this.formatResource(resource));
                break;
            }
            if (DEBUG) {
                this.out.println("# DAML list head: " + this.formatResource(resource2));
            }
            this.rdfListsAll.addAll(hashSet);
            if (resource2 == null) continue;
            this.rdfLists.add(resource2);
        }
        stmtIterator.close();
    }

    private boolean checkListElement(Resource resource) throws RDFException {
        if (!resource.hasProperty(RDF.rest) || !resource.hasProperty(RDF.first)) {
            if (DEBUG) {
                this.out.println("# RDF list element does not have required properties: " + this.formatResource(resource));
            }
            return false;
        }
        int n = this.countProperties(resource);
        if (n == 2) {
            return true;
        }
        if (n == 3) {
            if (resource.hasProperty(RDF.type, RDF.List)) {
                return true;
            }
            if (DEBUG) {
                this.out.println("# RDF list element: 3 properties but no rdf:type rdf:List" + this.formatResource(resource));
            }
            return false;
        }
        if (DEBUG) {
            this.out.println("# RDF list element does not right number of properties: " + this.formatResource(resource));
        }
        return false;
    }

    private void prepareOneRefBNodes(Model model) throws RDFException {
        NodeIterator nodeIterator = model.listObjects();
        while (nodeIterator.hasNext()) {
            Resource resource;
            RDFNode rDFNode = nodeIterator.nextNode();
            if (!(rDFNode instanceof Resource) || (resource = (Resource)rDFNode).getURI() != null && !resource.getURI().equals("") || this.rdfListsAll.contains(resource)) continue;
            StmtIterator stmtIterator = model.listStatements(null, null, resource);
            if (!stmtIterator.hasNext()) {
                throw new RuntimeException(this.getClass().getName() + ": found object with no arcs!");
            }
            Statement statement = stmtIterator.nextStatement();
            if (stmtIterator.hasNext()) continue;
            if (DEBUG) {
                this.out.println("# OneRef: " + this.formatResource(resource));
            }
            this.oneRefObjects.add(resource);
        }
        nodeIterator.close();
        if (DEBUG) {
            this.out.println("# RDF Lists      = " + this.rdfLists.size());
            this.out.println("# RDF ListsAll   = " + this.rdfListsAll.size());
            this.out.println("# oneRefObjects  = " + this.oneRefObjects.size());
        }
    }

    private void writeModel(Model model) throws RDFException {
        Object object;
        Object object2;
        String string;
        Iterator iterator = this.prefixMap.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object2 = (String)this.prefixMap.get(string);
            object = "@prefix " + string + ": ";
            this.out.print((String)object);
            this.out.print(this.pad(16 - ((String)object).length()));
            this.out.println("<" + (String)object2 + "> .");
        }
        if (!this.prefixMap.containsKey("")) {
            this.doingBaseHash = true;
            string = "@prefix : ";
            this.out.print(string);
            this.out.print(this.pad(16 - string.length()));
            this.out.println("<#> .");
        }
        if (this.doingBaseHash || this.prefixMap.size() != 0) {
            this.out.println();
        }
        boolean bl = true;
        object2 = model.listSubjects();
        while (object2.hasNext()) {
            object = object2.nextResource();
            if (this.rdfListsAll.contains(object) || this.oneRefObjects.contains(object)) {
                if (!DEBUG) continue;
                this.out.println("# Skipping: " + this.formatResource((Resource)object));
                continue;
            }
            if (bl) {
                bl = false;
            } else {
                this.out.println();
            }
            this.writeSubject((Resource)object, true);
        }
        object2.close();
        this.oneRefObjects.removeAll(this.oneRefDone);
        object = this.oneRefObjects.iterator();
        while (object.hasNext()) {
            this.out.println();
            if (DEBUG) {
                this.out.println("# One ref");
            }
            this.writeSubject((Resource)object.next(), false);
        }
        Iterator iterator2 = this.rdfLists.iterator();
        while (iterator2.hasNext()) {
            Resource resource = (Resource)iterator2.next();
            if (this.rdfListsDone.contains(resource)) continue;
            this.out.println();
            if (DEBUG) {
                this.out.println("# RDF List");
            }
            if (this.countArcsTo(resource) > 0) {
                this.out.print(this.formatResource(resource));
                this.out.print(" :- ");
            }
            this.writeList(resource);
            this.out.println(" .");
        }
        this.out.flush();
    }

    private void writeSubject(Resource resource, boolean bl) throws RDFException {
        String string = this.formatResource(resource);
        this.out.print(string);
        if (string.length() + this.minGap < this.indent.length()) {
            this.out.print(this.pad(this.indent.length() - string.length()));
        } else {
            this.out.println();
            this.out.print(this.indent);
        }
        this.out.incIndent(this.indent.length());
        this.writePropertyList(resource, bl);
        this.out.decIndent(this.indent.length());
        this.out.println(" .");
    }

    private void writePropertyList(Resource resource, boolean bl) throws RDFException {
        HashSet<Property> hashSet = new HashSet<Property>();
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            hashSet.add(stmtIterator.nextStatement().getPredicate());
        }
        stmtIterator.close();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            this.writeObjectList(resource, property, bl);
            if (!iterator.hasNext()) continue;
            this.out.println(" ;");
        }
    }

    private void writeObjectList(Resource resource, Property property, boolean bl) throws RDFException {
        String string = null;
        string = wellKnownPropsMap.containsKey(property.getURI()) ? (String)wellKnownPropsMap.get(property.getURI()) : this.formatResource(property);
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            this.out.print(string);
            if (string.length() + this.minGap < this.indent.length()) {
                this.out.print(this.pad(this.indent.length() - string.length()));
            } else {
                this.out.println();
                this.out.print(this.indent);
            }
            this.out.incIndent(this.indent.length());
            this.writeObject(statement.getObject(), bl);
            this.out.decIndent(this.indent.length());
            if (!stmtIterator.hasNext()) continue;
            this.out.println(" ;");
        }
        stmtIterator.close();
    }

    private void writeObject(RDFNode rDFNode, boolean bl) throws RDFException {
        if (rDFNode instanceof Literal) {
            this.writeLiteral((Literal)rDFNode);
            return;
        }
        Resource resource = (Resource)rDFNode;
        if (bl && this.oneRefObjects.contains(resource)) {
            this.oneRefDone.add(resource);
            int n = this.out.getIndent();
            this.out.setIndent(this.out.getCol());
            this.out.print("[ ");
            this.out.incIndent(2);
            this.writePropertyList(resource, bl);
            this.out.decIndent(2);
            this.out.print(" ]");
            this.out.setIndent(n);
            return;
        }
        if (this.rdfLists.contains(resource) && this.countArcsTo(resource) <= 1) {
            this.writeList(resource);
            return;
        }
        this.out.print(this.formatResource(resource));
    }

    private void writeList(Resource resource) throws RDFException {
        this.out.print("(");
        this.out.incIndent(2);
        boolean bl = true;
        Iterator iterator = this.rdfListIterator(resource);
        while (iterator.hasNext()) {
            if (!bl) {
                this.out.print(" ");
            }
            bl = false;
            RDFNode rDFNode = (RDFNode)iterator.next();
            this.writeObject(rDFNode, true);
        }
        this.out.print(")");
        this.out.decIndent(2);
        this.rdfListsDone.add(resource);
    }

    private String formatResource(Resource resource) {
        if (resource.isAnon()) {
            StmtIterator stmtIterator = resource.getModel().listStatements(null, null, resource);
            if (!stmtIterator.hasNext()) {
                stmtIterator.close();
                return "[]";
            }
            stmtIterator.close();
            if (!this.bNodesMap.containsKey(resource)) {
                this.bNodesMap.put(resource, "_:b" + ++this.bNodeCounter);
            }
            return (String)this.bNodesMap.get(resource);
        }
        if (resource.equals(RDF.nil)) {
            return "()";
        }
        String string = resource.getURI();
        if (string.equals(this.baseName)) {
            return "<>";
        }
        String string2 = "";
        String string3 = null;
        if (this.doingBaseHash && string.startsWith(this.baseName + "#")) {
            String string4 = string.substring((this.baseName + "#").length());
            if (string4.indexOf(46) == -1) {
                return ":" + string4;
            }
        } else {
            String string5;
            Iterator iterator = this.prefixMap.keySet().iterator();
            while (iterator.hasNext()) {
                string5 = (String)iterator.next();
                String string6 = (String)this.prefixMap.get(string5);
                if (!string.startsWith(string6) || string2.length() >= string6.length()) continue;
                string3 = string5;
                string2 = string6;
            }
            if (string3 != null && (string5 = string.substring(string2.length())).indexOf(46) == -1) {
                return string3 + ":" + string5;
            }
        }
        return "<" + resource.getURI() + ">";
    }

    private void writeLiteral(Literal literal) {
        String string = literal.getDatatypeURI();
        String string2 = literal.getLanguage();
        String string3 = literal.toString();
        int n = 0;
        int n2 = -1;
        this.out.print("\"");
        while (true) {
            if ((n2 = string3.indexOf(34, n)) == -1) break;
            this.out.print(string3.substring(n, n2));
            this.out.print("\\\"");
            n = n2 + 1;
        }
        this.out.print(string3.substring(n));
        this.out.print("\"");
        if (string2 != null && string2.length() > 0) {
            this.out.print("@");
            this.out.print(string2);
        }
        if (string != null) {
            this.out.print("^^<");
            this.out.print(string);
            this.out.print(">");
        }
    }

    private String pad(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void startWriting() {
        this.rdfLists = new HashSet();
        this.rdfListsAll = new HashSet();
        this.rdfListsDone = new HashSet();
        this.oneRefObjects = new HashSet();
        this.oneRefDone = new HashSet();
        this.prefixesUsed = new HashSet();
        this.bNodesMap = new HashMap();
    }

    protected void finishWriting() {
        this.rdfLists = null;
        this.rdfListsAll = null;
        this.rdfListsDone = null;
        this.oneRefObjects = null;
        this.oneRefDone = null;
        this.prefixesUsed = null;
        this.bNodesMap = null;
    }

    private int countProperties(Resource resource) throws RDFException {
        int n = 0;
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            ++n;
        }
        stmtIterator.close();
        return n;
    }

    private int countProperties(Resource resource, Property property) throws RDFException {
        int n = 0;
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            ++n;
        }
        stmtIterator.close();
        return n;
    }

    private int countArcsTo(Resource resource) throws RDFException {
        return this.countArcsTo(null, resource);
    }

    private int countArcsTo(Property property, Resource resource) throws RDFException {
        int n = 0;
        StmtIterator stmtIterator = resource.getModel().listStatements(null, property, resource);
        while (stmtIterator.hasNext()) {
            stmtIterator.nextStatement();
            ++n;
        }
        stmtIterator.close();
        return n;
    }

    private Iterator rdfListIterator(Resource resource) throws RDFException {
        ArrayList<RDFNode> arrayList = new ArrayList<RDFNode>();
        while (!resource.equals(RDF.nil)) {
            StmtIterator stmtIterator = resource.getModel().listStatements(resource, RDF.first, (RDFNode)null);
            arrayList.add(stmtIterator.nextStatement().getObject());
            if (stmtIterator.hasNext()) {
                throw new RuntimeException("Multi valued list item");
            }
            stmtIterator = resource.getModel().listStatements(resource, RDF.rest, (RDFNode)null);
            resource = (Resource)stmtIterator.nextStatement().getObject();
            if (!stmtIterator.hasNext()) continue;
            throw new RuntimeException("List has two tails");
        }
        return arrayList.iterator();
    }

    public synchronized void writeSimple(Model model, Writer writer, String string) throws RDFException {
        this.doingPrettyWrite = false;
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.out = new IndentedWriter(writer);
        this.baseName = string;
        this.startWriting();
        this.writeModelSimple(model);
        this.finishWriting();
    }

    private void writeModelSimple(Model model) throws RDFException {
        Object object;
        Iterator iterator = this.prefixMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = (String)this.prefixMap.get(object);
            this.out.println("@prefix " + (String)object + ": <" + string + "> .");
        }
        if (!this.prefixMap.containsKey("")) {
            this.doingBaseHash = true;
            this.out.println("@prefix : <#> .");
        }
        if (this.doingBaseHash || this.prefixMap.size() != 0) {
            this.out.println();
        }
        object = model.listSubjects();
        while (object.hasNext()) {
            this.writeSubject(object.nextResource(), false);
            if (!object.hasNext()) continue;
            this.out.println();
        }
        object.close();
        this.out.flush();
    }

    static {
        wellKnownPropsMap.put("http://www.w3.org/2000/10/swap/log#implies", "=>");
        wellKnownPropsMap.put(OWL.sameAs.getURI(), "=");
        wellKnownPropsMap.put(RDF.type.getURI(), "a");
    }
}

