/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class GraphMem
extends GraphBase
implements Graph {
    HashSet triples = new HashSet();
    NodeMap subjects = new NodeMap();
    NodeMap predicates = new NodeMap();
    NodeMap objects = new NodeMap();

    public void add(Triple triple) {
        if (this.getReifier().handledAdd(triple) || this.triples.contains(triple)) {
            return;
        }
        this.triples.add(triple);
        this.subjects.add(triple.getSubject(), triple);
        this.predicates.add(triple.getPredicate(), triple);
        this.objects.add(triple.getObject(), triple);
    }

    public void delete(Triple triple) {
        if (this.getReifier().handledRemove(triple)) {
            return;
        }
        this.triples.remove(triple);
        this.subjects.remove(triple.getSubject(), triple);
        this.predicates.remove(triple.getPredicate(), triple);
        this.objects.remove(triple.getObject(), triple);
    }

    public int size() throws UnsupportedOperationException {
        return this.triples.size();
    }

    public boolean contains(Triple triple) {
        return this.triples.contains(triple);
    }

    public boolean contains(Node node, Node node2, Node node3) {
        return this.contains(new Triple(node, node2, node3));
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        Node node = tripleMatch.getSubject();
        Node node2 = tripleMatch.getPredicate();
        Node node3 = tripleMatch.getObject();
        if (node != null) {
            return new TripleMatchIterator(tripleMatch, this.subjects.iterator(node));
        }
        if (node3 != null && !node3.isLiteral()) {
            return new TripleMatchIterator(tripleMatch, this.objects.iterator(node3));
        }
        if (node2 != null) {
            return new TripleMatchIterator(tripleMatch, this.predicates.iterator(node2));
        }
        return new TripleMatchIterator(tripleMatch, this.triples.iterator());
    }

    protected class NodeMap {
        HashMap map = new HashMap();

        protected NodeMap() {
        }

        protected void add(Node node, Triple triple) {
            LinkedList<Triple> linkedList = (LinkedList<Triple>)this.map.get(node);
            if (linkedList == null) {
                linkedList = new LinkedList<Triple>();
                this.map.put(node, linkedList);
            }
            linkedList.add(triple);
        }

        protected void remove(Node node, Triple triple) {
            LinkedList linkedList = (LinkedList)this.map.get(node);
            if (linkedList != null) {
                linkedList.remove(triple);
                if (linkedList.size() == 0) {
                    this.map.put(node, null);
                }
            }
        }

        protected Iterator iterator(Node node) {
            LinkedList linkedList = (LinkedList)this.map.get(node);
            if (linkedList == null) {
                return new LinkedList().iterator();
            }
            return linkedList.iterator();
        }
    }
}

