/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.IllegalDateTimeFieldException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.graph.LiteralLabel;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.test.Rational;
import com.hp.hpl.jena.graph.test.RationalType;
import com.hp.hpl.jena.mem.ModelMem;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.SimpleSelector;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTypedLiterals
extends TestCase {
    private Model m = new ModelMem();
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$test$TestTypedLiterals;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$hp$hpl$jena$datatypes$xsd$XSDDuration;
    static /* synthetic */ Class class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime;

    public TestTypedLiterals(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$test$TestTypedLiterals == null ? (class$com$hp$hpl$jena$graph$test$TestTypedLiterals = TestTypedLiterals.class$("com.hp.hpl.jena.graph.test.TestTypedLiterals")) : class$com$hp$hpl$jena$graph$test$TestTypedLiterals);
    }

    public void testUnknown() {
        String string = "urn:x-hp-dt:unknown";
        String string2 = "urn:x-hp-dt:unknown2";
        Literal literal = this.m.createTypedLiteral("foo", "lang1", string);
        Literal literal2 = this.m.createTypedLiteral("foo", "lang2", string);
        Literal literal3 = this.m.createTypedLiteral("15", "lang1", string);
        Literal literal4 = this.m.createTypedLiteral("foo", "lang1", string);
        Literal literal5 = this.m.createTypedLiteral("foo", "lang1", string2);
        Literal literal6 = this.m.createLiteral("foo", "lang1");
        Assert.assertNotNull((Object)literal);
        Assert.assertNotNull((Object)literal2);
        Assert.assertNotNull((Object)literal3);
        Assert.assertNotNull((Object)literal4);
        Assert.assertNotNull((Object)literal5);
        this.assertSame("language sensitive comparison", literal, literal4);
        this.assertDiffer("language sensitive", literal, literal2);
        this.assertDiffer("datatype sensitive", literal, literal5);
        this.assertDiffer("value sensitive", literal, literal3);
        this.assertDiffer("typed and plain differ", literal, literal6);
        try {
            int n = literal3.getInt();
            Assert.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Extract value", (Object)literal.getValue(), (Object)"foo");
        Assert.assertEquals((String)"Extract lang", (Object)literal.getLanguage(), (Object)"lang1");
        Assert.assertEquals((String)"Extract xml tag", (boolean)literal.getWellFormed(), (boolean)false);
    }

    public void testUserDef() {
        RDFDatatype rDFDatatype = RationalType.theRationalType;
        TypeMapper.getInstance().registerDatatype(rDFDatatype);
        Literal literal = this.m.createTypedLiteral("3/5", "lang1", rDFDatatype);
        Literal literal2 = this.m.createTypedLiteral("3/5", "lang2", rDFDatatype);
        Literal literal3 = this.m.createTypedLiteral("7/5", "lang1", rDFDatatype);
        Assert.assertNotNull((Object)literal);
        Assert.assertNotNull((Object)literal2);
        Assert.assertNotNull((Object)literal3);
        this.assertSame("language should be ignored", literal, literal2);
        this.assertDiffer("values should be tested!", literal, literal3);
        Assert.assertSame((String)"Datatype incorrect", (Object)literal.getDatatype(), (Object)rDFDatatype);
        Assert.assertEquals((String)"Datatype uri incorrect", (Object)literal.getDatatypeURI(), (Object)"urn:x-hp-dt:rational");
        Object object = literal.getValue();
        Assert.assertTrue((String)"Value space check", (boolean)(object instanceof Rational));
        Assert.assertTrue((String)"Value check", (((Rational)object).getNumerator() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Value check", (((Rational)object).getDenominator() == 5 ? 1 : 0) != 0);
        try {
            int n = literal.getInt();
            Assert.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Extract lang", (Object)literal.getLanguage(), (Object)"lang1");
        Assert.assertEquals((String)"Extract xml tag", (boolean)literal.getWellFormed(), (boolean)false);
    }

    public void testXSDbasics() {
        String string = "http://www.w3.org/2001/XMLSchema#int";
        Literal literal = this.m.createTypedLiteral(42);
        Literal literal2 = this.m.createTypedLiteral("42", "", (RDFDatatype)XSDDatatype.XSDint);
        Literal literal3 = this.m.createTypedLiteral("42", "lang", (RDFDatatype)XSDDatatype.XSDint);
        Literal literal4 = this.m.createTypedLiteral("63");
        this.assertSame("Default map failed", literal, literal2);
        Assert.assertEquals((String)"Value wrong", (Object)literal.getValue(), (Object)new Integer(42));
        Assert.assertEquals((String)"class wrong", literal.getValue().getClass(), (Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer));
        Assert.assertEquals((String)"Value accessor problem", (int)literal.getInt(), (int)42);
        Assert.assertEquals((String)"wrong type name", (Object)literal2.getDatatypeURI(), (Object)string);
        Assert.assertEquals((String)"wrong type", (Object)literal2.getDatatype(), (Object)XSDDatatype.XSDint);
        this.assertSame("Lang sensitive", literal2, literal3);
        this.assertDiffer("Not value sensitive", literal, literal4);
        this.checkIllegalLiteral("zap", XSDDatatype.XSDint);
        this.checkIllegalLiteral("42.1", XSDDatatype.XSDint);
        literal = this.m.createTypedLiteral(42.42);
        literal2 = this.m.createTypedLiteral("42.42", "", (RDFDatatype)XSDDatatype.XSDfloat);
        literal3 = this.m.createTypedLiteral("42.42", "", (RDFDatatype)XSDDatatype.XSDdouble);
        Assert.assertEquals((String)"class wrong", literal.getValue().getClass(), (Object)(class$java$lang$Double == null ? (class$java$lang$Double = TestTypedLiterals.class$("java.lang.Double")) : class$java$lang$Double));
        this.assertFloatEquals("value wrong", ((Double)literal.getValue()).floatValue(), 42.42);
        Assert.assertEquals((String)"class wrong", literal2.getValue().getClass(), (Object)(class$java$lang$Float == null ? (class$java$lang$Float = TestTypedLiterals.class$("java.lang.Float")) : class$java$lang$Float));
        this.assertFloatEquals("value wrong", ((Float)literal2.getValue()).floatValue(), 42.42);
        this.assertFloatEquals("Value accessor problem", literal.getFloat(), 42.42);
        Assert.assertEquals((String)"wrong type", (Object)literal2.getDatatype(), (Object)XSDDatatype.XSDfloat);
        this.assertSame("equality fn", literal, literal3);
        this.checkLegalLiteral("12345", XSDDatatype.XSDlong, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDlong, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDlong);
        this.checkLegalLiteral("1234", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(1234));
        this.checkLegalLiteral("-1234", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(-1234));
        this.checkLegalLiteral("32767", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MAX_VALUE));
        this.checkLegalLiteral("-32768", XSDDatatype.XSDshort, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(Short.MIN_VALUE));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDshort);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDshort);
        this.checkLegalLiteral("42", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(42));
        this.checkLegalLiteral("-42", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-42));
        this.checkLegalLiteral("127", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(127));
        this.checkLegalLiteral("-128", XSDDatatype.XSDbyte, class$java$lang$Byte == null ? (class$java$lang$Byte = TestTypedLiterals.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(-128));
        this.checkIllegalLiteral("32769", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("128", XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("2.3", XSDDatatype.XSDbyte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedLong, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDunsignedLong, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedLong);
        this.checkLegalLiteral("12345", XSDDatatype.XSDunsignedInt, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("2147483648", XSDDatatype.XSDunsignedInt, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0x80000000L));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedInt);
        this.checkLegalLiteral("1234", XSDDatatype.XSDunsignedShort, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(1234));
        this.checkLegalLiteral("32679", XSDDatatype.XSDunsignedShort, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(32679));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDunsignedShort);
        this.checkLegalLiteral("123", XSDDatatype.XSDunsignedByte, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(123));
        this.checkLegalLiteral("129", XSDDatatype.XSDunsignedByte, class$java$lang$Short == null ? (class$java$lang$Short = TestTypedLiterals.class$("java.lang.Short")) : class$java$lang$Short, new Short(129));
        this.checkIllegalLiteral("-123", XSDDatatype.XSDunsignedByte);
        this.checkLegalLiteral("12345", XSDDatatype.XSDinteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDinteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDinteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDinteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDpositiveInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkIllegalLiteral("0", XSDDatatype.XSDpositiveInteger);
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDpositiveInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDpositiveInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDnonNegativeInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonNegativeInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.checkIllegalLiteral("-12345", XSDDatatype.XSDnonNegativeInteger);
        this.checkLegalLiteral("9223372036854775808", XSDDatatype.XSDnonNegativeInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnegativeInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkIllegalLiteral("0", XSDDatatype.XSDnegativeInteger);
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnegativeInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnegativeInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("-12345", XSDDatatype.XSDnonPositiveInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(-12345L));
        this.checkLegalLiteral("0", XSDDatatype.XSDnonPositiveInteger, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.checkIllegalLiteral("12345", XSDDatatype.XSDnonPositiveInteger);
        this.checkLegalLiteral("-9223372036854775808", XSDDatatype.XSDnonPositiveInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = TestTypedLiterals.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("12345", XSDDatatype.XSDdecimal, class$java$lang$Long == null ? (class$java$lang$Long = TestTypedLiterals.class$("java.lang.Long")) : class$java$lang$Long, new Long("12345"));
        this.checkLegalLiteral("42.45", XSDDatatype.XSDdecimal, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TestTypedLiterals.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("42.45"));
        this.checkLegalLiteral("9223372036854775808.1234", XSDDatatype.XSDdecimal, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TestTypedLiterals.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("9223372036854775808.1234"));
        this.checkLegalLiteral("123.4", XSDDatatype.XSDdecimal, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TestTypedLiterals.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimal("123.4"));
        this.checkIllegalLiteral("123,4", XSDDatatype.XSDdecimal);
        this.checkLegalLiteral("true", XSDDatatype.XSDboolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = TestTypedLiterals.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Boolean(true));
        this.checkLegalLiteral("false", XSDDatatype.XSDboolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = TestTypedLiterals.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Boolean(false));
        literal = this.m.createTypedLiteral(true);
        Assert.assertEquals((String)"boolean mapping", (Object)XSDDatatype.XSDboolean, (Object)literal.getDatatype());
        this.checkLegalLiteral("hello world", XSDDatatype.XSDstring, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "hello world");
        literal = this.m.createTypedLiteral("foo bar");
        Assert.assertEquals((String)"string mapping", (Object)XSDDatatype.XSDstring, (Object)literal.getDatatype());
    }

    public void testMiscEquality() {
        Literal literal = this.m.createTypedLiteral("10", "", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal2 = this.m.createTypedLiteral("010", "en", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal3 = this.m.createTypedLiteral("010", "", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal4 = this.m.createTypedLiteral("010", "fr", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSame("Int lex form", literal, literal3);
        this.assertSame("Ignore language in integer", literal, literal2);
        this.assertSame("Ignore language in integer", literal, literal4);
    }

    public void testPlainSameValueAs() {
        Literal literal = this.m.createTypedLiteral("10", "", (RDFDatatype)XSDDatatype.XSDstring);
        Literal literal2 = this.m.createTypedLiteral("10", "", (RDFDatatype)null);
        Literal literal3 = this.m.createTypedLiteral("10", "", (String)null);
        Literal literal4 = this.m.createLiteral("10");
        Literal literal5 = this.m.createTypedLiteral("10", "", (RDFDatatype)XSDDatatype.XSDint);
        this.assertSame("Null type = plain literal", literal2, literal4);
        this.assertSame("Null type = plain literal", literal2, literal3);
        this.assertSame("Null type = plain literal", literal4, literal3);
        Assert.assertTrue((String)"null type", (literal3.getDatatype() == null ? 1 : 0) != 0);
        this.assertDiffer("String != int", literal, literal5);
        this.assertDiffer("Plain != int", literal2, literal5);
        this.assertDiffer("Plain != int", literal4, literal5);
        if (LiteralLabel.enablePlainSameAsString) {
            this.assertSame("String != plain??", literal, literal2);
            this.assertSame("String != plain??", literal, literal4);
        } else {
            this.assertDiffer("String != plain??", literal, literal2);
            this.assertDiffer("String != plain??", literal, literal4);
        }
    }

    public void testUserDefined() throws IOException {
        String string = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String string2 = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper typeMapper = TypeMapper.getInstance();
        List list = XSDDatatype.loadUserDefined(string, new FileReader(string2), null, typeMapper);
        this.assertIteratorValues(list.iterator(), new Object[]{string + "#XSDEnumerationHeight", string + "#over12", string + "#over17", string + "#over59", string + "#clothingsize"});
        RDFDatatype rDFDatatype = typeMapper.getSafeTypeByName(string + "#XSDEnumerationHeight");
        this.checkLegalLiteral("short", rDFDatatype, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "short");
        this.checkLegalLiteral("tall", rDFDatatype, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "tall");
        this.checkIllegalLiteral("shortish", rDFDatatype);
        RDFDatatype rDFDatatype2 = typeMapper.getSafeTypeByName(string + "#over12");
        this.checkLegalLiteral("15", rDFDatatype2, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(15));
        this.checkIllegalLiteral("12", rDFDatatype2);
        RDFDatatype rDFDatatype3 = typeMapper.getSafeTypeByName(string + "#clothingsize");
        this.checkLegalLiteral("42", rDFDatatype3, class$java$lang$Integer == null ? (class$java$lang$Integer = TestTypedLiterals.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(42));
        this.checkLegalLiteral("short", rDFDatatype3, class$java$lang$String == null ? (class$java$lang$String = TestTypedLiterals.class$("java.lang.String")) : class$java$lang$String, "short");
    }

    public void testDateTime() {
        Literal literal = this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", "", (RDFDatatype)XSDDatatype.XSDduration);
        Assert.assertEquals((String)"duration data type", (Object)XSDDatatype.XSDduration, (Object)literal.getDatatype());
        Assert.assertEquals((String)"duration java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDuration == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDuration = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDuration")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDuration), literal.getValue().getClass());
        Assert.assertEquals((String)"duration value", (int)1, (int)((XSDDuration)literal.getValue()).getYears());
        Assert.assertEquals((String)"duration value", (int)2, (int)((XSDDuration)literal.getValue()).getMonths());
        Assert.assertEquals((String)"duration value", (int)3, (int)((XSDDuration)literal.getValue()).getDays());
        Assert.assertEquals((String)"duration value", (int)5, (int)((XSDDuration)literal.getValue()).getHours());
        Assert.assertEquals((String)"duration value", (int)6, (int)((XSDDuration)literal.getValue()).getMinutes());
        Assert.assertEquals((String)"duration value", (int)7, (int)((XSDDuration)literal.getValue()).getFullSeconds());
        this.assertFloatEquals("duration value", 18367.5, ((XSDDuration)literal.getValue()).getTimePart());
        Assert.assertEquals((String)"serialization", (Object)"P1Y2M3DT5H6M7.5S", (Object)literal.getValue().toString());
        Assert.assertEquals((String)"equality test", (Object)literal, (Object)this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", "", (RDFDatatype)XSDDatatype.XSDduration));
        Assert.assertTrue((String)"inequality test", (literal != this.m.createTypedLiteral("P1Y2M2DT5H6M7.5S", "", (RDFDatatype)XSDDatatype.XSDduration) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("1999-05-31T12:56:32Z", "", (RDFDatatype)XSDDatatype.XSDdateTime);
        XSDDateTime xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdateTime, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        Assert.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        Assert.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        Assert.assertEquals((String)"dateTime value", (int)31, (int)xSDDateTime.getDays());
        Assert.assertEquals((String)"dateTime value", (int)12, (int)xSDDateTime.getHours());
        Assert.assertEquals((String)"dateTime value", (int)56, (int)xSDDateTime.getMinutes());
        Assert.assertEquals((String)"dateTime value", (int)32, (int)xSDDateTime.getFullSeconds());
        Assert.assertEquals((String)"serialization", (Object)"1999-5-31T12:56:32.0Z", (Object)literal.getValue().toString());
        Calendar calendar = xSDDateTime.asCalendar();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(1999, 5, 31, 12, 56, 32);
        gregorianCalendar.set(14, 0);
        Assert.assertEquals((String)"calendar value", (Object)calendar, (Object)gregorianCalendar);
        Assert.assertEquals((String)"equality test", (Object)literal, (Object)this.m.createTypedLiteral("1999-05-31T12:56:32Z", "", (RDFDatatype)XSDDatatype.XSDdateTime));
        Assert.assertTrue((String)"inequality test", (literal != this.m.createTypedLiteral("1999-04-31T12:56:32Z", "", (RDFDatatype)XSDDatatype.XSDdateTime) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("1999-05-31", "", (RDFDatatype)XSDDatatype.XSDdate);
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdate, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        Assert.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        Assert.assertEquals((String)"dateTime value", (int)31, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getHours();
            Assert.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("12:56:32", "", (RDFDatatype)XSDDatatype.XSDtime);
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDtime, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime value", (int)12, (int)xSDDateTime.getHours());
        Assert.assertEquals((String)"dateTime value", (int)56, (int)xSDDateTime.getMinutes());
        Assert.assertEquals((String)"dateTime value", (int)32, (int)xSDDateTime.getFullSeconds());
        try {
            xSDDateTime.getDays();
            Assert.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("1999-05", "", (RDFDatatype)XSDDatatype.XSDgYearMonth);
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYearMonth, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        Assert.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        try {
            xSDDateTime.getDays();
            Assert.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("1999", "", (RDFDatatype)XSDDatatype.XSDgYear);
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYear, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime value", (int)1999, (int)xSDDateTime.getYears());
        try {
            xSDDateTime.getMonths();
            Assert.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("--05--", "", (RDFDatatype)XSDDatatype.XSDgMonth);
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonth, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        try {
            xSDDateTime.getYears();
            Assert.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("--05-25", "", (RDFDatatype)XSDDatatype.XSDgMonthDay);
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonthDay, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime value", (int)5, (int)xSDDateTime.getMonths());
        Assert.assertEquals((String)"dateTime value", (int)25, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getYears();
            Assert.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {
            // empty catch block
        }
        literal = this.m.createTypedLiteral("---25", "", (RDFDatatype)XSDDatatype.XSDgDay);
        Assert.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgDay, (Object)literal.getDatatype());
        Assert.assertEquals((String)"dateTime java type", (Object)(class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime == null ? (class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime = TestTypedLiterals.class$("com.hp.hpl.jena.datatypes.xsd.XSDDateTime")) : class$com$hp$hpl$jena$datatypes$xsd$XSDDateTime), literal.getValue().getClass());
        xSDDateTime = (XSDDateTime)literal.getValue();
        Assert.assertEquals((String)"dateTime value", (int)25, (int)xSDDateTime.getDays());
        try {
            xSDDateTime.getMonths();
            Assert.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException illegalDateTimeFieldException) {}
    }

    public void testTypedQueries() {
        ModelMem modelMem = new ModelMem();
        Property property = modelMem.createProperty("urn:x-eg/p");
        Literal literal = modelMem.createTypedLiteral("10", "fr", "http://www.w3.org/2001/XMLSchema#integer");
        Literal literal2 = modelMem.createTypedLiteral("010", "en", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSame("sameas test", literal, literal2);
        Resource resource = modelMem.createResource("urn:x-eg/a");
        resource.addProperty(property, literal);
        Assert.assertTrue((boolean)modelMem.getGraph().find(null, property.asNode(), literal.asNode()).hasNext());
        Assert.assertTrue((boolean)modelMem.getGraph().find(null, property.asNode(), literal2.asNode()).hasNext());
        Assert.assertTrue((boolean)modelMem.getGraph().find(resource.asNode(), property.asNode(), literal2.asNode()).hasNext());
        Query query = new Query();
        query.addMatch(resource.asNode(), property.asNode(), literal2.asNode());
        ExtendedIterator extendedIterator = modelMem.getGraph().queryHandler().prepareBindings(query, new Node[0]).executeBindings();
        Assert.assertTrue((boolean)extendedIterator.hasNext());
        SimpleSelector simpleSelector = new SimpleSelector(resource, property, literal2);
        Assert.assertTrue((boolean)modelMem.listStatements(simpleSelector).hasNext());
    }

    public void testIsValidLiteral() {
        Literal literal = this.m.createTypedLiteral("1000", "", (RDFDatatype)XSDDatatype.XSDinteger);
        LiteralLabel literalLabel = literal.asNode().getLiteral();
        Assert.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDunsignedInt.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDunsignedLong.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDunsignedShort.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDpositiveInteger.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel));
        Assert.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((!XSDDatatype.XSDbyte.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((!XSDDatatype.XSDnegativeInteger.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("-2", "", (RDFDatatype)XSDDatatype.XSDinteger);
        literalLabel = literal.asNode().getLiteral();
        Assert.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(literalLabel));
        Assert.assertTrue((!XSDDatatype.XSDunsignedInt.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((!XSDDatatype.XSDunsignedLong.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((!XSDDatatype.XSDunsignedShort.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(literalLabel));
        Assert.assertTrue((!XSDDatatype.XSDpositiveInteger.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)XSDDatatype.XSDbyte.isValidLiteral(literalLabel));
        Assert.assertTrue((boolean)XSDDatatype.XSDnegativeInteger.isValidLiteral(literalLabel));
        literal = this.m.createTypedLiteral("4.5", "", (RDFDatatype)XSDDatatype.XSDfloat);
        literalLabel = literal.asNode().getLiteral();
        Assert.assertTrue((!XSDDatatype.XSDdouble.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Assert.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        Literal literal2 = this.m.createTypedLiteral("foo", "", (RDFDatatype)XSDDatatype.XSDstring);
        Assert.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literal2.asNode().getLiteral()));
        Assert.assertTrue((boolean)XSDDatatype.XSDnormalizedString.isValidLiteral(literal2.asNode().getLiteral()));
        Assert.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literal2.asNode().getLiteral()) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("foo bar");
        literalLabel = literal.asNode().getLiteral();
        Assert.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel));
        Assert.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literalLabel) ? 1 : 0) != 0);
        literal = this.m.createTypedLiteral("12");
        literalLabel = literal.asNode().getLiteral();
        Assert.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(literalLabel));
        Assert.assertTrue((!XSDDatatype.XSDint.isValidLiteral(literalLabel) ? 1 : 0) != 0);
    }

    private void assertDiffer(String string, Literal literal, Literal literal2) {
        Assert.assertTrue((String)string, (!literal.sameValueAs(literal2) ? 1 : 0) != 0);
    }

    private void assertSame(String string, Literal literal, Literal literal2) {
        Assert.assertTrue((String)string, (boolean)literal.sameValueAs(literal2));
    }

    private void assertFloatEquals(String string, double d, double d2) {
        Assert.assertTrue((String)string, (Math.abs(d - d2) < 0.001 ? 1 : 0) != 0);
    }

    public void checkIllegalLiteral(String string, RDFDatatype rDFDatatype) {
        try {
            Literal literal = this.m.createTypedLiteral(string, "lang", rDFDatatype);
            literal.getValue();
            Assert.assertTrue((String)("Failed to catch '" + string + "' as an illegal " + rDFDatatype), (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {}
    }

    public void checkLegalLiteral(String string, RDFDatatype rDFDatatype, Class clazz, Object object) {
        Literal literal = this.m.createTypedLiteral(string, "lang", rDFDatatype);
        Assert.assertEquals(literal.getValue().getClass(), (Object)clazz);
        Assert.assertEquals((Object)literal.getValue(), (Object)object);
        Assert.assertEquals((Object)literal.getDatatype(), (Object)rDFDatatype);
    }

    public void assertIteratorValues(Iterator iterator, Object[] objectArray) {
        boolean[] blArray = new boolean[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            blArray[n] = false;
            ++n;
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl = false;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (e.equals(objectArray[n2])) {
                    bl = true;
                    blArray[n2] = true;
                }
                ++n2;
            }
            Assert.assertTrue((boolean)bl);
        }
        int n4 = 0;
        while (n4 < objectArray.length) {
            Assert.assertTrue((boolean)blArray[n4]);
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

