/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphBase;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestReifier
extends GraphTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$test$TestReifier;

    public TestReifier(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$test$TestReifier == null ? (class$com$hp$hpl$jena$graph$test$TestReifier = TestReifier.class$("com.hp.hpl.jena.graph.test.TestReifier")) : class$com$hp$hpl$jena$graph$test$TestReifier);
    }

    public void testEmptyReifiers() {
        Assert.assertEquals((String)"no reified triples", (int)0, (int)GraphTestBase.graphWith("x R y").getReifier().getHiddenTriples().size());
        Assert.assertEquals((String)"no reified triples", (int)0, (int)GraphTestBase.graphWith("x R y; p S q").getReifier().getHiddenTriples().size());
    }

    public void testSameReifier() {
        Graph graph = GraphTestBase.graphWith("");
        Reifier reifier = graph.getReifier();
        graph.add(GraphTestBase.triple("x R y"));
        Assert.assertTrue((String)"same reifier", (reifier == graph.getReifier() ? 1 : 0) != 0);
    }

    public void testParent() {
        Graph graph = GraphTestBase.graphWith("");
        Graph graph2 = GraphTestBase.graphWith("");
        Assert.assertTrue((String)"correct reifier (G)", (graph == graph.getReifier().getParentGraph() ? 1 : 0) != 0);
        Assert.assertTrue((String)"correct reifier (H)", (graph2 == graph2.getReifier().getParentGraph() ? 1 : 0) != 0);
    }

    public void testIntercept() {
        Graph graph = GraphBase.withReification(GraphTestBase.graphWith(""));
        Reifier reifier = graph.getReifier();
        Node node = GraphTestBase.node("sub");
        Node node2 = GraphTestBase.node("obj");
        Node node3 = GraphTestBase.node("http://example.org/type");
        GraphTestBase.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(new Triple(node, Reifier.type, node3)));
        GraphTestBase.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(new Triple(node, node, Reifier.subject)));
        GraphTestBase.assertFalse("reifier must not intercept quadlet", reifier.handledAdd(new Triple(node, node, Reifier.type)));
        Assert.assertTrue((String)"reifier must intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, Reifier.predicate, node2)));
        Assert.assertTrue((String)"reifier must intercept quadlet", (boolean)reifier.handledAdd(new Triple(node, Reifier.type, Reifier.Statement)));
    }

    public void testHiddenTriples() {
        Graph graph = GraphBase.withReification(GraphTestBase.graphWith(""));
        Reifier reifier = graph.getReifier();
        Node node = GraphTestBase.node("SSS");
        Node node2 = GraphTestBase.node("PPP");
        Node node3 = GraphTestBase.node("OOO ");
        graph.add(new Triple(node, Reifier.predicate, node2));
        Assert.assertEquals((String)"graph must still be empty", (int)0, (int)graph.size());
        Assert.assertEquals((String)"reifier must have the triple", (int)1, (int)reifier.getHiddenTriples().size());
        GraphTestBase.assertContains("xxx", "SSS rdf:predicate PPP", reifier.getHiddenTriples());
        graph.add(new Triple(node, Reifier.subject, node));
        GraphTestBase.assertContains("xxx", "SSS rdf:subject SSS", reifier.getHiddenTriples());
    }

    public void testRetrieveTriplesByNode() {
        Graph graph = GraphTestBase.graphWith("");
        Reifier reifier = graph.getReifier();
        Node node = Node.createAnon();
        Node node2 = Node.createAnon();
        reifier.reifyAs(node, GraphTestBase.triple("x R y"));
        Assert.assertEquals((String)"gets correct triple", (Object)GraphTestBase.triple("x R y"), (Object)reifier.getTriple(node));
        reifier.reifyAs(node2, GraphTestBase.triple("p S q"));
        GraphTestBase.assertDiffer("the anon nodes must be distinct", node, node2);
        Assert.assertEquals((String)"gets correct triple", (Object)GraphTestBase.triple("p S q"), (Object)reifier.getTriple(node2));
        Assert.assertTrue((String)"node is known bound", (boolean)reifier.hasTriple(node2));
        Assert.assertTrue((String)"node is known bound", (boolean)reifier.hasTriple(node));
        GraphTestBase.assertFalse("node is known unbound", reifier.hasTriple(Node.ANY));
        GraphTestBase.assertFalse("node is known unbound", reifier.hasTriple(Node.createURI("any:thing")));
    }

    public void testRetrieveTriplesByTriple() {
        Graph graph = GraphTestBase.graphWith("");
        Reifier reifier = graph.getReifier();
        Triple triple = GraphTestBase.triple("x R y");
        Triple triple2 = GraphTestBase.triple("y R x");
        Node node = GraphTestBase.node("someNode");
        reifier.reifyAs(node, triple);
        Assert.assertTrue((String)"R must have T", (boolean)reifier.hasTriple(triple));
        GraphTestBase.assertFalse("R must not have T2", reifier.hasTriple(triple2));
    }

    public void testReifyAs() {
        Graph graph = GraphTestBase.graphWith("");
        Reifier reifier = graph.getReifier();
        Node node = Node.createURI("some:uri");
        Assert.assertEquals((String)"node used", (Object)node, (Object)reifier.reifyAs(node, GraphTestBase.triple("x R y")));
        Assert.assertEquals((String)"retrieves correctly", (Object)GraphTestBase.triple("x R y"), (Object)reifier.getTriple(node));
    }

    public void testAllNodes() {
        Reifier reifier = GraphTestBase.graphWith("").getReifier();
        reifier.reifyAs(GraphTestBase.node("x"), GraphTestBase.triple("cows eat grass"));
        reifier.reifyAs(GraphTestBase.node("y"), GraphTestBase.triple("pigs can fly"));
        reifier.reifyAs(GraphTestBase.node("z"), GraphTestBase.triple("dogs may bark"));
        Assert.assertEquals((String)"", (Object)this.nodeSet("z y x"), (Object)this.iteratorToSet(reifier.allNodes()));
    }

    public void testRemoveByNode() {
        Graph graph = GraphTestBase.graphWith("");
        Reifier reifier = graph.getReifier();
        Node node = GraphTestBase.node("x");
        Node node2 = GraphTestBase.node("y");
        reifier.reifyAs(node, GraphTestBase.triple("x R a"));
        reifier.reifyAs(node2, GraphTestBase.triple("y R a"));
        reifier.remove(node, GraphTestBase.triple("x R a"));
        GraphTestBase.assertFalse("triple X has gone", reifier.hasTriple(node));
        Assert.assertEquals((String)"triple Y still there", (Object)GraphTestBase.triple("y R a"), (Object)reifier.getTriple(node2));
    }

    public void testException() {
        Graph graph = GraphTestBase.graphWith("");
        Reifier reifier = graph.getReifier();
        Node node = GraphTestBase.node("x");
        reifier.reifyAs(node, GraphTestBase.triple("x R y"));
        reifier.reifyAs(node, GraphTestBase.triple("x R y"));
        try {
            reifier.reifyAs(node, GraphTestBase.triple("x R z"));
            Assert.fail((String)"did not detected already reified node");
        }
        catch (Reifier.AlreadyReifiedException alreadyReifiedException) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

