/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.LiteralLabel;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.AnonId;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestNode
extends GraphTestBase {
    private static final String U = "http://some.domain.name/magic/spells.incant";
    private static final String N = "Alice";
    private static final LiteralLabel L = new LiteralLabel("ashes are burning", "en", false);
    private static final AnonId A = new AnonId();
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$test$TestNode;

    public TestNode(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$test$TestNode == null ? (class$com$hp$hpl$jena$graph$test$TestNode = TestNode.class$("com.hp.hpl.jena.graph.test.TestNode")) : class$com$hp$hpl$jena$graph$test$TestNode);
    }

    public void testBlanks() {
        Assert.assertTrue((String)"anonymous nodes are blank", (boolean)Node.createAnon().isBlank());
        GraphTestBase.assertFalse("anonymous nodes aren't literal", Node.createAnon().isLiteral());
        GraphTestBase.assertFalse("anonymous nodes aren't URIs", Node.createAnon().isURI());
        GraphTestBase.assertFalse("anonymous nodes aren't variables", Node.createAnon().isVariable());
        Assert.assertEquals((String)"anonymous nodes have the right id", (Object)Node.createAnon(A).getBlankNodeId(), (Object)A);
    }

    public void testLiterals() {
        GraphTestBase.assertFalse("literal nodes aren't blank", Node.createLiteral(L).isBlank());
        Assert.assertTrue((String)"literal nodes are literal", (boolean)Node.createLiteral(L).isLiteral());
        GraphTestBase.assertFalse("literal nodes aren't variables", Node.createLiteral(L).isVariable());
        GraphTestBase.assertFalse("literal nodes aren't URIs", Node.createLiteral(L).isURI());
        Assert.assertEquals((String)"literal nodes preserve value", (Object)Node.createLiteral(L).getLiteral(), (Object)L);
    }

    public void testURIs() {
        GraphTestBase.assertFalse("URI nodes aren't blank", Node.createURI(U).isBlank());
        GraphTestBase.assertFalse("URI nodes aren't literal", Node.createURI(U).isLiteral());
        GraphTestBase.assertFalse("URI nodes aren't variables", Node.createURI(U).isVariable());
        Assert.assertTrue((String)"URI nodes are URIs", (boolean)Node.createURI(U).isURI());
        Assert.assertEquals((String)"URI nodes preserve URI", (Object)Node.createURI(U).getURI(), (Object)U);
    }

    public void testVariables() {
        GraphTestBase.assertFalse("variable nodes aren't blank", Node.createVariable(N).isBlank());
        GraphTestBase.assertFalse("variable nodes aren't literal", Node.createVariable(N).isLiteral());
        GraphTestBase.assertFalse("variable nodes aren't URIs", Node.createVariable(N).isURI());
        Assert.assertTrue((String)"variable nodes are variable", (boolean)Node.createVariable(N).isVariable());
        Assert.assertEquals((String)"variable nodes keep their name", (Object)N, (Object)Node.createVariable(N).getName());
        Assert.assertEquals((String)"variable nodes keep their name", (Object)"Alicex", (Object)Node.createVariable("Alicex").getName());
    }

    public void testANY() {
        GraphTestBase.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
        GraphTestBase.assertFalse("ANY nodes aren't literals", Node.ANY.isLiteral());
        GraphTestBase.assertFalse("ANY nodes aren't URIs", Node.ANY.isURI());
        GraphTestBase.assertFalse("ANY nodes aren't variables", Node.ANY.isVariable());
        GraphTestBase.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
        GraphTestBase.assertFalse("ANY nodes aren't blank", Node.ANY.isBlank());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[][] eqTestCases() {
        Object[][] objectArray;
        try {
            Node.cache(false);
            AnonId anonId = new AnonId();
            LiteralLabel literalLabel = new LiteralLabel(anonId.toString(), "", false);
            Node node = GraphTestBase.node("a");
            Node node2 = GraphTestBase.node("b");
            Triple triple = new Triple(node, node, node);
            Triple triple2 = new Triple(node2, node2, node2);
            String string = anonId.toString();
            String string2 = anonId.toString();
            objectArray = new Object[][]{{Node.ANY, "0"}, {Node.createAnon(anonId), "1"}, {Node.createAnon(), "2"}, {Node.createAnon(anonId), "1"}, {Node.createLiteral(L), "3"}, {Node.createLiteral(literalLabel), "4"}, {Node.createLiteral(L), "3"}, {Node.createURI(U), "5"}, {Node.createURI(string), "6"}, {Node.createURI(U), "5"}, {Node.createVariable(N), "7"}, {Node.createVariable(string2), "8"}, {Node.createVariable(N), "7"}};
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Node.cache(true);
            throw throwable;
        }
        Node.cache(true);
        return objectArray;
    }

    public void testNodeEquals() {
        Object[][] objectArray = this.eqTestCases();
        int n = 0;
        while (n < objectArray.length) {
            Object[] objectArray2 = objectArray[n];
            GraphTestBase.assertFalse(objectArray2[0] + " should not equal null", objectArray2[0].equals(null));
            GraphTestBase.assertFalse(objectArray2[0] + "should not equal 'String'", objectArray2[0].equals("String"));
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object[] objectArray3 = objectArray[n2];
                this.testEquality(objectArray2[1].equals(objectArray3[1]), objectArray2[0], objectArray3[0]);
                ++n2;
            }
            ++n;
        }
    }

    private void testEquality(boolean bl, Object object, Object object2) {
        String string = this.getType(object) + " " + object + " and " + this.getType(object2) + " " + object2;
        if (bl) {
            Assert.assertEquals((String)(string + "should be equal"), (Object)object, (Object)object2);
        } else {
            GraphTestBase.assertDiffer(string + " should differ", object, object2);
        }
    }

    private String getType(Object object) {
        String string = object.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEquals() {
        try {
            Node.cache(false);
            GraphTestBase.assertDiffer("different variables", Node.createVariable("xx"), Node.createVariable("yy"));
            Assert.assertEquals((String)"same vars", (Object)Node.createVariable("aa"), (Object)Node.createVariable("aa"));
            Assert.assertEquals((String)"same URI", (Object)Node.createURI(U), (Object)Node.createURI(U));
            Assert.assertEquals((String)"same anon", (Object)Node.createAnon(A), (Object)Node.createAnon(A));
            Assert.assertEquals((String)"same literal", (Object)Node.createLiteral(L), (Object)Node.createLiteral(L));
            GraphTestBase.assertFalse("distinct URIs", Node.createURI(U) == Node.createURI(U));
            GraphTestBase.assertFalse("distinct blanks", Node.createAnon(A) == Node.createAnon(A));
            GraphTestBase.assertFalse("distinct literals", Node.createLiteral(L) == Node.createLiteral(L));
            GraphTestBase.assertFalse("distinct vars", Node.createVariable("aa") == Node.createVariable("aa"));
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Node.cache(true);
            throw throwable;
        }
        Node.cache(true);
    }

    public void testLabels() {
        AnonId anonId = new AnonId();
        Triple triple = GraphTestBase.triple("x R y");
        Assert.assertEquals((String)"get URI value", (Object)U, (Object)Node.createURI(U).getURI());
        Assert.assertEquals((String)"get blank value", (Object)anonId, (Object)Node.createAnon(anonId).getBlankNodeId());
        Assert.assertEquals((String)"get literal value", (Object)L, (Object)Node.createLiteral(L).getLiteral());
        Assert.assertEquals((String)"get variable name", (Object)N, (Object)Node.createVariable(N).getName());
    }

    public void testFailingLabels() {
        Triple triple = GraphTestBase.triple("x R y");
        Node node = Node.createURI(U);
        Node node2 = Node.createAnon();
        Node node3 = Node.createLiteral(L);
        Node node4 = Node.createVariable(N);
        Node node5 = Node.ANY;
        this.testGetURIFails(node5);
        this.testGetURIFails(node2);
        this.testGetURIFails(node3);
        this.testGetURIFails(node4);
        this.testGetLiteralFails(node5);
        this.testGetLiteralFails(node);
        this.testGetLiteralFails(node2);
        this.testGetLiteralFails(node4);
        this.testGetNameFails(node5);
        this.testGetNameFails(node);
        this.testGetNameFails(node2);
        this.testGetNameFails(node3);
        this.testGetBlankNodeIdFails(node5);
        this.testGetBlankNodeIdFails(node);
        this.testGetBlankNodeIdFails(node3);
        this.testGetBlankNodeIdFails(node4);
    }

    public void testGetBlankNodeIdFails(Node node) {
        try {
            node.getBlankNodeId();
            Assert.fail((String)(node.getClass() + " should fail getName()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testGetURIFails(Node node) {
        try {
            node.getURI();
            Assert.fail((String)(node.getClass() + " should fail getURI()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testGetNameFails(Node node) {
        try {
            node.getName();
            Assert.fail((String)(node.getClass() + " should fail getName()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testGetLiteralFails(Node node) {
        try {
            node.getLiteral();
            Assert.fail((String)(node.getClass() + " should fail getLiteral()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testCache() {
        Assert.assertTrue((String)"remembers URI", (Node.createURI(U) == Node.createURI(U) ? 1 : 0) != 0);
        Assert.assertTrue((String)"remembers literal", (Node.createLiteral(L) == Node.createLiteral(L) ? 1 : 0) != 0);
        Assert.assertTrue((String)"remembers blanks", (Node.createAnon(A) == Node.createAnon(A) ? 1 : 0) != 0);
        Assert.assertTrue((String)"remembers variables", (Node.createVariable(N) == Node.createVariable(N) ? 1 : 0) != 0);
        GraphTestBase.assertFalse("is not confused", Node.createVariable(N) == Node.createURI(N));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

