/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphBase;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestGraph
extends GraphTestBase {
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$test$TestGraph;

    public TestGraph(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$test$TestGraph == null ? (class$com$hp$hpl$jena$graph$test$TestGraph = TestGraph.class$("com.hp.hpl.jena.graph.test.TestGraph")) : class$com$hp$hpl$jena$graph$test$TestGraph);
    }

    public static void testAGraph(String string, Graph graph) {
        GraphTestBase.graphAdd(graph, "x R y; p S q; a T b");
        GraphTestBase.assertContainsAll(string + ": simple graph", graph, "x R y; p S q; a T b");
        Assert.assertEquals((String)(string + ": size"), (int)graph.size(), (int)3);
        GraphTestBase.graphAdd(graph, "spindizzies lift cities; Diracs communicate instantaneously");
        Assert.assertEquals((String)(string + ": size after adding"), (int)graph.size(), (int)5);
        graph.delete(GraphTestBase.triple("x R y"));
        graph.delete(GraphTestBase.triple("a T b"));
        Assert.assertEquals((String)(string + ": size after deleting"), (int)graph.size(), (int)3);
        GraphTestBase.assertContainsAll(string + ": modified simple graph", graph, "p S q; spindizzies lift cities; Diracs communicate instantaneously");
        GraphTestBase.assertOmitsAll(string + ": modified simple graph", graph, "x R y; a T b");
        ExtendedIterator extendedIterator = graph.find(null, GraphTestBase.node("lift"), null);
        Assert.assertTrue((String)(string + ": finds some triple(s)"), (boolean)extendedIterator.hasNext());
        Assert.assertEquals((String)(string + ": finds a 'lift' triple"), (Object)GraphTestBase.triple("spindizzies lift cities"), extendedIterator.next());
        GraphTestBase.assertFalse(string + ": finds exactly one triple", extendedIterator.hasNext());
    }

    public static void testStuff() {
        TestGraph.testAGraph("StoreMem", new GraphMem());
        TestGraph.testAGraph("StoreMemBySubject", new GraphMem());
    }

    public void testReificationControl() {
        Graph graph = GraphTestBase.graphWith("x rdf:subject S");
        Graph graph2 = GraphBase.withReification(graph);
        Assert.assertEquals((String)"should not hide reification triple", (int)1, (int)graph.size());
        Assert.assertEquals((String)"should not hide reification triple", (int)1, (int)graph2.size());
        graph2.add(GraphTestBase.triple("x rdf:object O"));
        Assert.assertEquals((String)"", (int)1, (int)graph.size());
        Assert.assertEquals((String)"", (int)1, (int)graph2.size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

