/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphTestBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class QueryTest
extends GraphTestBase {
    private Query Q;
    private Node X = GraphTestBase.node("?x");
    private Node Y = GraphTestBase.node("?y");
    private Node Z = GraphTestBase.node("?z");
    private Graph empty;
    private Graph single;
    private static final String[][] tests = new String[][]{{"", "pigs might fly", "", ""}, {"", "", "pigs might fly", ""}, {"", "a pings b; b pings c", "a pings _x; _x pings c", "a pings b; b pings c"}, {"", "a pings b; b pings c; a pings x; x pings c", "a pings _x; _x pings c", "a pings b; b pings c; a pings x; x pings c"}};
    static /* synthetic */ Class class$com$hp$hpl$jena$graph$query$test$QueryTest;

    public QueryTest(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$hp$hpl$jena$graph$query$test$QueryTest == null ? (class$com$hp$hpl$jena$graph$query$test$QueryTest = QueryTest.class$("com.hp.hpl.jena.graph.query.test.QueryTest")) : class$com$hp$hpl$jena$graph$query$test$QueryTest);
    }

    public void setUp() {
        this.Q = new Query();
        this.empty = GraphTestBase.graphWith("");
        this.single = GraphTestBase.graphWith("spindizzies drive cities");
    }

    private void checkQueryVariables() {
        Assert.assertEquals((Object)this.X, (Object)Query.X);
        Assert.assertEquals((Object)this.Y, (Object)Query.Y);
        Assert.assertEquals((Object)this.Z, (Object)Query.Z);
    }

    private void testTreeQuery(String string, String string2, String string3, String string4) {
        Graph graph = GraphTestBase.graphWith(string2);
        Graph graph2 = GraphTestBase.graphWith(string3);
        Graph graph3 = graph.queryHandler().prepareTree(graph2).executeTree();
        if (string.equals("")) {
            string = "checking {" + string2 + "} against {" + string3 + "} should give {" + string4 + "}" + " not " + graph3;
        }
        this.assertEquals(string, GraphTestBase.graphWith(string4), graph3);
    }

    private void testTreeQuery(String string, String string2, String string3) {
        this.testTreeQuery("checking", string, string2, string3);
    }

    public void testManyThings() {
        int n = 0;
        while (n < tests.length) {
            this.testTreeQuery(tests[n][0], tests[n][1], tests[n][2], tests[n][3]);
            ++n;
        }
    }

    public void testAtomicTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke", "birds will joke");
    }

    public void testCompositeTreeQuery() {
        this.testTreeQuery("pigs might fly; birds will joke; cats must watch", "birds will joke; pigs might fly", "pigs might fly; birds will joke");
    }

    public void testChainedTreeQuery() {
        this.testTreeQuery("a pings b; b pings c; c pings d", "a pings b; b pings c", "a pings b; b pings c");
    }

    public void testBinding1() {
        Graph graph = GraphTestBase.graphWith("rice grows quickly");
        Query query = new Query();
        Node node = GraphTestBase.node("?v1");
        Node node2 = GraphTestBase.node("?v3");
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query.addMatch(node, GraphTestBase.node("grows"), node2), new Node[]{node, node2});
        Domain domain = (Domain)bindingQueryPlan.executeBindings().next();
        Assert.assertEquals((String)"binding subject to rice", (Object)domain.get(0), (Object)GraphTestBase.node("rice"));
        Assert.assertEquals((String)"binding object to quickly", (Object)domain.get(1), (Object)GraphTestBase.node("quickly"));
    }

    public void testBinding2() {
        Graph graph = GraphTestBase.graphWith("rice grows quickly; time isan illusion");
        String[][] stringArrayArray = new String[][]{{"time", "isan", "illusion"}, {"rice", "grows", "quickly"}};
        Query query = new Query();
        Node node = GraphTestBase.node("?v1");
        Node node2 = GraphTestBase.node("?v2");
        Node node3 = GraphTestBase.node("?v3");
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query.addMatch(node, node2, node3), new Node[]{node, node2, node3});
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        int n = 0;
        while (n < stringArrayArray.length) {
            if (!extendedIterator.hasNext()) {
                Assert.fail((String)"wanted some more results");
            }
            Domain domain = (Domain)extendedIterator.next();
            int n2 = 0;
            while (n2 < 3) {
                Assert.assertEquals((String)"binding failure", (Object)domain.get(n2), (Object)GraphTestBase.node(stringArrayArray[n][n2]));
                ++n2;
            }
            ++n;
        }
        GraphTestBase.assertFalse("iterator should be empty", extendedIterator.hasNext());
    }

    public void testMultiplePatterns() {
        Graph graph = GraphTestBase.graphWith("ben wrote Clayface; Starfish ingenre SF; Clayface ingenre Geology; bill wrote Starfish");
        Query query = new Query();
        Node node = GraphTestBase.node("?X");
        Node node2 = GraphTestBase.node("?A");
        query.addMatch(node, GraphTestBase.node("wrote"), node2).addMatch(node2, GraphTestBase.node("ingenre"), GraphTestBase.node("SF"));
        BindingQueryPlan bindingQueryPlan = graph.queryHandler().prepareBindings(query, new Node[]{node});
        ExtendedIterator extendedIterator = bindingQueryPlan.executeBindings();
        if (extendedIterator.hasNext()) {
            Domain domain = (Domain)extendedIterator.next();
            if (domain.size() == 1) {
                if (domain.get(0).equals(GraphTestBase.node("bill"))) {
                    if (extendedIterator.hasNext()) {
                        System.out.println("! failed: more than one multiple pattern answer: " + (Domain)extendedIterator.next());
                    }
                } else {
                    System.out.println("! failed: multiple pattern answer should be 'bill'");
                }
            } else {
                System.out.println("! failed: multiple pattern answer should have one element");
            }
        } else {
            System.out.println("! failed: multiple pattern query should have an answer");
        }
    }

    public void testNodeVariablesA() {
        Graph graph = GraphTestBase.graphWith("storms hit England");
        Node node = GraphTestBase.node("?spoo");
        this.Q.addMatch(node, GraphTestBase.node("hit"), GraphTestBase.node("England"));
        ExtendedIterator extendedIterator = graph.queryHandler().prepareBindings(this.Q, new Node[]{node}).executeBindings();
        Assert.assertTrue((String)"tnv: it has a solution", (boolean)extendedIterator.hasNext());
        Assert.assertEquals((String)"", (Object)GraphTestBase.node("storms"), ((List)extendedIterator.next()).get(0));
        GraphTestBase.assertFalse("tnv: just the one solution", extendedIterator.hasNext());
    }

    public void testNodeVariablesB() {
        Graph graph = GraphTestBase.graphWith("storms hit England");
        Node node = GraphTestBase.node("?spoo");
        Node node2 = GraphTestBase.node("?flarn");
        this.Q.addMatch(node, GraphTestBase.node("hit"), node2);
        ExtendedIterator extendedIterator = graph.queryHandler().prepareBindings(this.Q, new Node[]{node2, node}).executeBindings();
        Assert.assertTrue((String)"tnv: it has a solution", (boolean)extendedIterator.hasNext());
        List list = (List)extendedIterator.next();
        Assert.assertEquals((String)"tnvB", (Object)GraphTestBase.node("storms"), list.get(1));
        Assert.assertEquals((String)"tnvB", (Object)GraphTestBase.node("England"), list.get(0));
        GraphTestBase.assertFalse("tnv: just the one solution", extendedIterator.hasNext());
    }

    public Set nodeSet(String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(GraphTestBase.node(stringTokenizer.nextToken()));
        }
        return hashSet;
    }

    public void testGraphConstraints(String string, String string2, String string3) {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Node node = GraphTestBase.node("?O");
        Query query = new Query();
        query.addMatch(Query.ANY, Query.ANY, node);
        Graph graph = GraphTestBase.graphWith("pigs fly south; dogs fly badly; plans fly flat");
        query.addConstraint(GraphTestBase.graphWith(string2));
        Set set = this.iteratorToSet(graph.queryHandler().prepareBindings(query, new Node[]{node}).executeBindings().mapWith(map1));
        Assert.assertEquals((String)"tgs", (Object)this.nodeSet(string3), (Object)set);
    }

    public void testGraphConstraints() {
        this.testGraphConstraints("tgs A", "", "south flat badly");
        this.testGraphConstraints("tgs B", "?O &ne badly", "south flat");
        this.testGraphConstraints("tgs C", "?O &ne badly; ?O &ne flat", "south");
    }

    public void testSeveralGraphConstraints() {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Node node = GraphTestBase.node("?O");
        Query query = new Query();
        query.addMatch(Query.ANY, Query.ANY, node);
        Graph graph = GraphTestBase.graphWith("pigs fly south; dogs fly badly; plans fly flat");
        query.addConstraint(GraphTestBase.graphWith("?O &ne badly"));
        query.addConstraint(GraphTestBase.graphWith("?O &ne flat"));
        Set set = this.iteratorToSet(graph.queryHandler().prepareBindings(query, new Node[]{node}).executeBindings().mapWith(map1));
        Assert.assertEquals((String)"tsgs", (Object)this.nodeSet("south"), (Object)set);
    }

    public void testBindingQuery() {
        Graph graph = GraphTestBase.graphWith("");
        Graph graph2 = GraphTestBase.graphWith("pigs might fly; cats chase mice; dogs chase cars; cats might purr");
        Node[] nodeArray = new Node[]{};
        GraphTestBase.assertFalse("empty graph, no bindings", graph.queryHandler().prepareBindings(new Query().addMatch(Query.ANY, Query.ANY, Query.ANY), nodeArray).executeBindings().hasNext());
        Assert.assertTrue((String)"full graph, > 0 bindings", (boolean)graph2.queryHandler().prepareBindings(new Query(), nodeArray).executeBindings().hasNext());
    }

    public static List iteratorToList(ClosableIterator closableIterator) {
        ArrayList arrayList = new ArrayList();
        while (closableIterator.hasNext()) {
            arrayList.add(closableIterator.next());
        }
        return arrayList;
    }

    public void testEmpty() {
        List list = QueryTest.iteratorToList(this.Q.executeBindings(this.empty, new Node[0]));
        Assert.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [size]", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        Assert.assertEquals((String)"testEmpty: select [] from {} => 1 empty binding [width]", (int)domain.size(), (int)0);
    }

    public void testOneMatch() {
        this.Q.addMatch(this.X, Query.ANY, Query.ANY);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(this.single, new Node[]{this.X}));
        Assert.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [size]", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        Assert.assertEquals((String)"select X from {spindizzies drive cities} => 1 binding [width]", (int)domain.size(), (int)1);
        Assert.assertTrue((String)"select X from {spindizzies drive cities} => 1 binding [value]", (boolean)domain.get(0).equals(GraphTestBase.node("spindizzies")));
    }

    public void testMismatch() {
        this.Q.addMatch(this.X, this.X, this.X);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(this.single, new Node[]{this.X}));
        Assert.assertEquals((String)"bindings mismatch (X X X)", (int)list.size(), (int)0);
    }

    public void testXXXMatch1() {
        this.Q.addMatch(this.X, this.X, this.X);
        Graph graph = GraphTestBase.graphWith("ring ring ring");
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        Assert.assertEquals((String)"bindings match (X X X)", (int)list.size(), (int)1);
    }

    public HashSet setFrom(Node[] nodeArray) {
        HashSet<Node> hashSet = new HashSet<Node>(nodeArray.length);
        int n = 0;
        while (n < nodeArray.length) {
            hashSet.add(nodeArray[n]);
            ++n;
        }
        return hashSet;
    }

    public void testXXXMatch3() {
        AbstractCollection abstractCollection;
        this.Q.addMatch(this.X, this.X, this.X);
        Graph graph = GraphTestBase.graphWith("ring ring ring; ding ding ding; ping ping ping");
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        Assert.assertEquals((String)"bindings match (X X X)", (int)list.size(), (int)3);
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < list.size()) {
            abstractCollection = (Domain)list.get(n);
            Assert.assertEquals((String)"one bound variable", (int)abstractCollection.size(), (int)1);
            hashSet.add(abstractCollection.get(0));
            ++n;
        }
        abstractCollection = this.setFrom(new Node[]{GraphTestBase.node("ring"), GraphTestBase.node("ding"), GraphTestBase.node("ping")});
        Assert.assertEquals((String)"testMatch getting {ring ding ping}", hashSet, (Object)abstractCollection);
    }

    public void testTwoPatterns() {
        Node node = GraphTestBase.node("reads");
        Node node2 = GraphTestBase.node("inGenre");
        Graph graph = GraphTestBase.graphWith("chris reads blish; blish inGenre SF");
        this.Q.addMatch(this.X, node, this.Y);
        this.Q.addMatch(this.Y, node2, this.Z);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X, this.Z}));
        Assert.assertTrue((String)"testTwoPatterns: one binding", (list.size() == 1 ? 1 : 0) != 0);
        Domain domain = (Domain)list.get(0);
        Assert.assertEquals((String)"testTwoPatterns: width 2", (int)domain.size(), (int)2);
        Assert.assertEquals((String)"testTwoPatterns: X = chris", (Object)domain.get(0), (Object)GraphTestBase.node("chris"));
        Assert.assertEquals((String)"testTwoPatterns: Y = SF", (Object)domain.get(1), (Object)GraphTestBase.node("SF"));
    }

    public void testGraphQuery() {
        Graph graph = GraphTestBase.graphWith("?X reads ?Y; ?Y inGenre ?Z");
        Graph graph2 = GraphTestBase.graphWith("chris reads blish; blish inGenre SF");
        Query query = new Query(graph);
        List list = QueryTest.iteratorToList(query.executeBindings(graph2, new Node[]{GraphTestBase.node("?X"), GraphTestBase.node("?Z")}));
        Assert.assertEquals((String)"testTwoPatterns: one binding", (int)1, (int)list.size());
        Domain domain = (Domain)list.get(0);
        Assert.assertEquals((String)"testTwoPatterns: width 2", (int)domain.size(), (int)2);
        Assert.assertEquals((String)"testTwoPatterns: X = chris", (Object)domain.get(0), (Object)GraphTestBase.node("chris"));
        Assert.assertEquals((String)"testTwoPatterns: Y = SF", (Object)domain.get(1), (Object)GraphTestBase.node("SF"));
    }

    public void testTwoGraphs() {
        Graph graph = GraphTestBase.graphWith("chris reads blish; chris reads norton; chris eats curry");
        Graph graph2 = GraphTestBase.graphWith("blish inGenre SF; curry inGenre food");
        Node node = GraphTestBase.node("reads");
        Node node2 = GraphTestBase.node("inGenre");
        this.Q.addMatch("a", this.X, node, this.Y).addMatch("b", this.Y, node2, this.Z);
        Query.ArgMap argMap = this.Q.args().put("a", graph).put("b", graph2);
        List list = QueryTest.iteratorToList(this.Q.executeBindings(argMap, new Node[]{this.X, this.Z}));
        Assert.assertEquals((String)"testTwoGraphs: one binding", (int)list.size(), (int)1);
        Domain domain = (Domain)list.get(0);
        Assert.assertEquals((String)"testTwoGraphs: width 2", (int)domain.size(), (int)2);
        Assert.assertEquals((String)"testTwoGraphs: X = chris", (Object)domain.get(0), (Object)GraphTestBase.node("chris"));
        Assert.assertEquals((String)"testTwoGraphs: Y = SF", (Object)domain.get(1), (Object)GraphTestBase.node("SF"));
    }

    private void helpConstraint(String string, Graph graph, int n) {
        Query query = new Query();
        Graph graph2 = GraphTestBase.graphWith("blish wrote CIF; blish wrote VOR; hambly wrote Darwath; feynman mechanicked quanta");
        query.addMatch(this.X, GraphTestBase.node("wrote"), Query.ANY);
        query.addConstraint(graph);
        List list = QueryTest.iteratorToList(query.executeBindings(graph2, new Node[]{this.X}));
        Assert.assertEquals((String)("testConstraint " + string + ": number of bindings"), (int)n, (int)list.size());
    }

    public void testConstraint() {
        this.helpConstraint("none", GraphTestBase.graphWith(""), 3);
        this.helpConstraint("X /= blish", GraphTestBase.graphWith("?x &ne blish"), 1);
        this.helpConstraint("X /= blish & X /= hambly", GraphTestBase.graphWith("?x &ne blish; ?x &ne hambly"), 0);
    }

    public void testConstraintTwo() {
        Graph graph = GraphTestBase.graphWith("blish wrote CIF; blish wrote VOR; hambly wrote Darwath; feynman mechanicked quanta");
        this.Q.addMatch(this.X, GraphTestBase.node("wrote"), this.Y);
        this.Q.addConstraint(GraphTestBase.graphWith("?x &ne ?y"));
        List list = QueryTest.iteratorToList(this.Q.executeBindings(graph, new Node[]{this.X}));
        Assert.assertEquals((String)"testConstraint Two: number of bindings", (int)list.size(), (int)3);
    }

    private void helpConstraintThree(String string, Graph graph, int n) {
        Query query = new Query();
        Graph graph2 = GraphTestBase.graphWith("brust wrote jhereg; hedgehog hacked code; angel age 230; brust wrote 230");
        query.addConstraint(graph);
        query.addMatch(this.X, this.Y, this.Z);
        List list = QueryTest.iteratorToList(query.executeBindings(graph2, new Node[]{this.X, this.Z}));
        Assert.assertEquals((String)("testConstraint " + string + ": number of bindings"), (int)n, (int)list.size());
    }

    public void testConstraintThree() {
        this.helpConstraintThree("testConstraintThree 1:", GraphTestBase.graphWith("?x &eq brust"), 2);
        this.helpConstraintThree("testConstraintThree 2:", GraphTestBase.graphWith("?y &eq hacked"), 1);
        this.helpConstraintThree("testConstraintThree 3:", GraphTestBase.graphWith("?z &eq 230"), 2);
        this.helpConstraintThree("testConstraintThree 4:", GraphTestBase.graphWith("?z &eq 230"), 2);
    }

    public void testConstraintFour() {
        Map1 map1 = new Map1(){

            public Object map1(Object object) {
                return ((List)object).get(0);
            }
        };
        Query query = new Query();
        Graph graph = GraphTestBase.graphWith("bill pinged ben; ben pinged weed; weed pinged weed; bill ignored bill");
        query.addMatch(this.X, GraphTestBase.node("pinged"), this.Y);
        query.addConstraint(this.X, Query.NE, this.Y);
        Set set = this.iteratorToSet(query.executeBindings(graph, new Node[]{this.X}).mapWith(map1));
        Assert.assertEquals((String)"", (Object)this.setFrom(new Node[]{GraphTestBase.node("bill"), GraphTestBase.node("ben")}), (Object)set);
    }

    public void testStringResults() {
        Graph graph = GraphTestBase.graphWith("ding dong dilly");
        Query query = new Query().addMatch(this.X, this.Y, Query.ANY);
        List list = QueryTest.iteratorToList(query.executeBindings(graph, new Node[]{this.X, this.Y}));
        Assert.assertEquals((String)"one result back by name", (int)list.size(), (int)1);
        Assert.assertEquals((String)"x = ding", (Object)((Domain)list.get(0)).get(0), (Object)GraphTestBase.node("ding"));
    }

    public void testMissingVariable() {
        Graph graph = GraphTestBase.graphWith("x y z");
        Query query = new Query();
        List list = QueryTest.iteratorToList(query.executeBindings(graph, new Node[]{this.X, this.Y}));
        List list2 = (List)query.executeBindings(graph, new Node[]{this.X, this.Y}).next();
        Assert.assertEquals((String)"undefined variables get null", null, list2.get(0));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

